/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view.profileeditor;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.CstStateItem;
import ch.gpb.elexis.cst.dialog.CstReminderDialog;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.view.profileeditor.CstComposite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class RemindersComposite
extends CstComposite
implements Heartbeat.HeartListener {
    CstProfile aProfile;
    TreeViewer treeviewer;
    Action actionAddObject;
    Action actionDeleteObject;
    Action actionEditObject;
    Image imgExclam = UiDesk.getImage((String)"bell-exclamation.png");
    List<Image> imageList = new ArrayList<Image>();
    Label lblHeart;
    Label lblCheckingForActions;

    public RemindersComposite(Composite parent) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        this.setLayout((Layout)gridLayout);
        this.createLayout(this);
        this.treeviewer = new TreeViewer((Composite)this, 2048);
        Tree tree_1 = this.treeviewer.getTree();
        GridData gd_tree_1 = new GridData(16384, 0x1000000, false, false, 4, 1);
        gd_tree_1.heightHint = 230;
        gd_tree_1.widthHint = 500;
        tree_1.setLayoutData((Object)gd_tree_1);
        this.treeviewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        Button btnNewAction = new Button((Composite)this, 0);
        btnNewAction.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        btnNewAction.setText("Start new event chain");
        btnNewAction.addSelectionListener((SelectionListener)new NewItemListener());
        Button btnExpandAll = new Button((Composite)this, 0);
        btnExpandAll.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        btnExpandAll.setText("Expand All");
        btnExpandAll.addSelectionListener((SelectionListener)new ExpandAllListener());
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.treeviewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (RemindersComposite.this.treeviewer.getSelection().isEmpty()) {
                    return;
                }
                if (RemindersComposite.this.treeviewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)RemindersComposite.this.treeviewer.getSelection();
                    manager.add((IAction)RemindersComposite.this.actionAddObject);
                    manager.add((IAction)RemindersComposite.this.actionDeleteObject);
                    manager.add((IAction)RemindersComposite.this.actionEditObject);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeviewer.getControl().setMenu(menu);
        this.treeviewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeviewer);
        this.makeActions();
        CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        new Label((Composite)this, 0);
        this.lblHeart = new Label((Composite)this, 0);
        this.lblHeart.setText(Messages.RemindersComposite_lblHeart_text);
        GridData gd_lblHeart = new GridData(16384, 128, false, false, 1, 1);
        gd_lblHeart.heightHint = 50;
        gd_lblHeart.widthHint = 50;
        this.lblHeart.setLayoutData((Object)gd_lblHeart);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.lblCheckingForActions = new Label((Composite)this, 0);
        this.lblCheckingForActions.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblCheckingForActions.setText(Messages.RemindersComposite_lblCheckingForActions_text);
        this.treeviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection;
                Object selectedNode;
                TreeViewer viewer;
                viewer.setExpandedState(selectedNode, !(viewer = (TreeViewer)event.getViewer()).getExpandedState(selectedNode = (thisSelection = (IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
        this.imageList = Arrays.asList(this.imgHeart1, this.imgHeart2, this.imgHeart3, this.imgHeartA, this.imgHeartB, this.imgHeartC, this.imgHeartD, this.imgHeartE);
        this.lblCheckingForActions.setVisible(false);
        this.lblHeart.setVisible(false);
    }

    private void createLayout(Composite parent) {
        Label labelTherapievorschlag = new Label(parent, 0);
        labelTherapievorschlag.setLayoutData((Object)new GridData(16384, 128, false, false, 4, 1));
        labelTherapievorschlag.setText(Messages.RemindersComposite_title_reminder);
        labelTherapievorschlag.setSize(200, 20);
    }

    public void dispose() {
        super.dispose();
    }

    public void heartbeat() {
        if (this.aProfile == null) {
            return;
        }
        new HeartbeatThread().start();
    }

    private void showMessage(String title, String msg) {
        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)title, (String)msg);
    }

    public void addObject(CstStateItem selItem) {
        if (this.aProfile == null) {
            this.showMessage("No Profile", "Bitte w\ufffdhlen Sie ein Profil");
            return;
        }
        CstReminderDialog dialog = new CstReminderDialog(this.getShell(), CoreHub.actMandant);
        CstStateItem.StateType selType = null;
        String name = null;
        dialog.create();
        if (dialog.open() != 0) {
            return;
        }
        selType = dialog.getItemType();
        name = dialog.getGroupName();
        if (selItem != null) {
            CstStateItem item = new CstStateItem(CstService.getCompactFromDate(new Date()), name, selType, this.aProfile.getId(), selItem.getId(), CoreHub.actMandant.getId());
            System.out.println("created CstStateItem with parent: " + item.getId());
        } else {
            CstStateItem item = new CstStateItem(CstService.getCompactFromDate(new Date()), name, selType, this.aProfile.getId(), null, CoreHub.actMandant.getId());
            System.out.println("created CstStateItem without parent: " + item.getId());
        }
    }

    private void makeActions() {
        this.actionAddObject = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RemindersComposite.this.treeviewer.getSelection();
                System.out.println("sel tree: " + selection.toString());
                CstStateItem selItem = (CstStateItem)((Object)selection.getFirstElement());
                RemindersComposite.this.addObject(selItem);
                RemindersComposite.this.treeviewer.refresh();
                RemindersComposite.this.treeviewer.setExpandedState((Object)selItem, true);
            }
        };
        this.actionAddObject.setText("Add Item");
        this.actionAddObject.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.actionEditObject = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RemindersComposite.this.treeviewer.getSelection();
                System.out.println("sel tree: " + selection.toString());
                CstStateItem selItem = (CstStateItem)((Object)selection.getFirstElement());
                CstReminderDialog dialog = new CstReminderDialog(RemindersComposite.this.getShell(), CoreHub.actMandant);
                dialog.create();
                dialog.setName(selItem.getName());
                dialog.setDescription(selItem.getDescription());
                dialog.setType(selItem.getItemType());
                dialog.setDate(CstService.getDateFromCompact(selItem.getDate()));
                CstStateItem.StateType selType = null;
                String name = null;
                String desc = null;
                Date date = null;
                if (dialog.open() != 0) {
                    return;
                }
                selType = dialog.getItemType();
                name = dialog.getGroupName();
                desc = dialog.getGroupDescription();
                date = dialog.getDate();
                selItem.setName(name);
                selItem.setDescription(desc);
                selItem.setItemType(selType);
                selItem.setDate(CstService.getCompactFromDate(date));
                RemindersComposite.this.treeviewer.refresh();
            }
        };
        this.actionEditObject.setText("Edit Item");
        this.actionEditObject.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.actionDeleteObject = new Action(){

            public void run() {
                TreeSelection selection = (TreeSelection)RemindersComposite.this.treeviewer.getSelection();
                System.out.println("sel tree: " + selection.toString());
                CstStateItem selItem = (CstStateItem)((Object)selection.getFirstElement());
                ArrayList<CstStateItem> result = new ArrayList<CstStateItem>();
                List<CstStateItem> itemsToDelete = RemindersComposite.getChildrenToDelete(selItem, result);
                itemsToDelete.add(selItem);
                for (CstStateItem cstStateItem : itemsToDelete) {
                    cstStateItem.delete();
                }
                RemindersComposite.this.treeviewer.setInput(CstStateItem.getRootItems(RemindersComposite.this.aProfile));
                RemindersComposite.this.expandAll();
            }
        };
        this.actionDeleteObject.setText("Delete Item");
        this.actionDeleteObject.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
    }

    private static List<CstStateItem> getChildrenToDelete(CstStateItem parent, List<CstStateItem> result) {
        List<CstStateItem> items = CstStateItem.getChildren(parent);
        for (CstStateItem item : items) {
            result.add(item);
            if (CstStateItem.getChildren(item).isEmpty()) continue;
            RemindersComposite.getChildrenToDelete(item, result);
        }
        return result;
    }

    private void expandAll() {
        this.treeviewer.expandAll();
    }

    public void clear() {
    }

    public void setProfile(CstProfile aProfile) {
        this.aProfile = aProfile;
        this.treeviewer.setInput(CstStateItem.getRootItems(aProfile));
    }

    class ExpandAllListener
    extends SelectionAdapter {
        ExpandAllListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RemindersComposite.this.expandAll();
        }
    }

    public class HeartbeatThread
    extends Thread {
        int pulse = 300;

        @Override
        public void run() {
            try {
                HeartbeatThread.sleep(1000L);
                UiDesk.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((HeartbeatThread)HeartbeatThread.this).RemindersComposite.this.lblCheckingForActions.setVisible(true);
                        ((HeartbeatThread)HeartbeatThread.this).RemindersComposite.this.lblHeart.setVisible(true);
                    }
                });
                for (final Image image : RemindersComposite.this.imageList) {
                    HeartbeatThread.sleep(this.pulse);
                    UiDesk.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((HeartbeatThread)HeartbeatThread.this).RemindersComposite.this.lblHeart.setImage(image);
                        }
                    });
                }
                UiDesk.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((HeartbeatThread)HeartbeatThread.this).RemindersComposite.this.lblCheckingForActions.setVisible(false);
                        ((HeartbeatThread)HeartbeatThread.this).RemindersComposite.this.lblHeart.setVisible(false);
                    }
                });
                HeartbeatThread.sleep(400L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class NewItemListener
    extends SelectionAdapter {
        NewItemListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RemindersComposite.this.addObject(null);
            RemindersComposite.this.treeviewer.setInput(CstStateItem.getRootItems(RemindersComposite.this.aProfile));
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList list = (LinkedList)inputElement;
            return list.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            CstStateItem file = (CstStateItem)((Object)parentElement);
            List<CstStateItem> children = CstStateItem.getChildren(file);
            return children.toArray();
        }

        public Object getParent(Object element) {
            System.out.println("getParent class: " + element.getClass());
            if (element instanceof LinkedList) {
                LinkedList list = (LinkedList)element;
                Iterator it = list.iterator();
                if (it.hasNext()) {
                    CstStateItem child2 = (CstStateItem)((Object)it.next());
                    return child2;
                }
                return null;
            }
            CstStateItem child = (CstStateItem)((Object)element);
            return CstStateItem.getParent(child);
        }

        public boolean hasChildren(Object element) {
            CstStateItem child = (CstStateItem)((Object)element);
            List<CstStateItem> children = CstStateItem.getChildren(child);
            return !children.isEmpty();
        }
    }

    class ViewLabelProvider
    extends StyledCellLabelProvider {
        ViewLabelProvider() {
        }

        public void update(ViewerCell cell) {
            CstStateItem element = (CstStateItem)((Object)cell.getElement());
            StyledString text = new StyledString();
            text.append(String.valueOf(element.getItemType().name()) + ": " + element.getName());
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            switch (element.getItemType().ordinal()) {
                case 0: {
                    cell.setForeground(RemindersComposite.this.ORANGE);
                    cell.setImage(RemindersComposite.this.imgAction);
                    break;
                }
                case 1: {
                    cell.setForeground(RemindersComposite.this.COLOR_RED);
                    cell.setImage(RemindersComposite.this.imgDecision);
                    break;
                }
                case 2: {
                    cell.setText(String.valueOf(element.getItemType().name()) + "   f\ufffdllig am:" + CstService.getGermanFromCompact(element.getDate()));
                    if (new Date().after(CstService.getDateFromCompact(element.getDate()))) {
                        cell.setImage(RemindersComposite.this.imgReminder);
                        cell.setBackground(RemindersComposite.this.COLOR_RED);
                    } else {
                        cell.setBackground(RemindersComposite.this.WHITE);
                        cell.setImage(RemindersComposite.this.imgReminder);
                    }
                    cell.setForeground(RemindersComposite.this.VIOLET);
                    break;
                }
                case 3: {
                    cell.setForeground(RemindersComposite.this.GREEN);
                    cell.setImage(RemindersComposite.this.imgTrigger);
                    break;
                }
            }
            super.update(cell);
        }

        public String getToolTipText(Object element) {
            CstStateItem item = (CstStateItem)((Object)element);
            return "ID: " + item.getId() + " (" + CstService.getGermanFromCompact(item.getDate()) + ")";
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 2000;
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 200;
        }
    }
}

