/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.data.LabItem;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.gpb.elexis.cst.Activator;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstAbstract;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.gpb.elexis.cst.data.LabItemWrapper;
import ch.gpb.elexis.cst.dialog.CstCategoryDialog;
import ch.gpb.elexis.cst.dialog.CstLabItemSelectionDialog;
import ch.gpb.elexis.cst.dialog.ThemenblockDetailDialog;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CstThemenblockEditor
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.gpb.elexis.cst.views.cstcategoryview";
    private CheckboxTableViewer tableViewerCstGroup;
    private CheckboxTableViewer tableViewerLabItem;
    private Action actionCreateCstGroup;
    private Action actionDeleteCstGroup;
    private Action actionRemoveLabItem;
    private Action actionAddLabItems;
    private Action actionDisplayOnce;
    private Table tableCstGroup;
    private Table tableLabItem;
    private int sortColumn = 0;
    private boolean sortReverse = false;
    private Color myColorRed;
    private List<CstGroup> cstGroups;
    private List<LabItemWrapper> labItems = new ArrayList<LabItemWrapper>();
    private List<LabItem> dialogLabItems = new ArrayList<LabItem>();
    static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    Patient patient;
    Label labelLeft;
    Text txtAbstract;
    Map<Object, Object> itemRanking = null;
    private Logger log = LoggerFactory.getLogger((String)CstThemenblockEditor.class.getName());
    private boolean isRepeatedDialog;

    public void createPartControl(Composite parent) {
        Canvas baseCanvas = new Canvas(parent, 512);
        baseCanvas.setBackground(new Color((Device)Display.getDefault(), 239, 239, 239));
        FillLayout baseGridLayout = new FillLayout();
        baseGridLayout.type = 512;
        baseCanvas.setLayout((Layout)baseGridLayout);
        SashForm form = new SashForm((Composite)baseCanvas, 256);
        form.setLayout((Layout)new GridLayout());
        GridData gdForm = new GridData();
        gdForm.heightHint = 400;
        form.setLayoutData((Object)gdForm);
        Composite child1 = new Composite((Composite)form, 0);
        GridLayout gridLayoutLeft = new GridLayout();
        gridLayoutLeft.numColumns = 1;
        child1.setLayout((Layout)gridLayoutLeft);
        Composite child2 = new Composite((Composite)form, 0);
        GridLayout gridLayoutRight = new GridLayout();
        gridLayoutRight.numColumns = 1;
        child2.setLayout((Layout)gridLayoutRight);
        form.setWeights(new int[]{20, 40});
        this.labelLeft = new Label(child1, 0x1000800);
        this.labelLeft.setText("CST Group");
        this.labelLeft.setSize(100, 20);
        this.labelLeft.setFont(this.createBoldFont(this.labelLeft.getFont()));
        this.labelLeft.setForeground(UiDesk.getColor((String)"blau"));
        this.labelLeft.setBackground(new Color((Device)Display.getDefault(), 251, 247, 247));
        GridData gridDataLabelLeft = new GridData();
        gridDataLabelLeft.horizontalAlignment = 4;
        gridDataLabelLeft.grabExcessHorizontalSpace = true;
        this.labelLeft.setLayoutData((Object)gridDataLabelLeft);
        this.tableCstGroup = new Table(child1, 66340);
        GridData gridDataTableLeft = new GridData();
        gridDataTableLeft.horizontalAlignment = 4;
        gridDataTableLeft.verticalAlignment = 4;
        gridDataTableLeft.grabExcessHorizontalSpace = true;
        gridDataTableLeft.grabExcessVerticalSpace = true;
        this.tableCstGroup.setLayoutData((Object)gridDataTableLeft);
        Label labelRight = new Label(child2, 0x1000800);
        labelRight.setText("Labor Items");
        labelRight.setSize(100, 20);
        labelRight.setFont(this.createBoldFont(labelRight.getFont()));
        labelRight.setBackground(new Color((Device)Display.getDefault(), 251, 247, 247));
        GridData gridDataLabelRight = new GridData();
        gridDataLabelRight.horizontalAlignment = 4;
        gridDataLabelRight.grabExcessHorizontalSpace = true;
        labelRight.setLayoutData((Object)gridDataLabelRight);
        this.tableLabItem = new Table(child2, 66340);
        GridData gridDataTableRight = new GridData();
        gridDataTableRight.horizontalAlignment = 4;
        gridDataTableRight.verticalAlignment = 4;
        gridDataTableRight.grabExcessHorizontalSpace = true;
        gridDataTableRight.grabExcessVerticalSpace = true;
        this.tableLabItem.setLayoutData((Object)gridDataTableRight);
        this.cstGroups = new ArrayList<CstGroup>();
        String[] colLabels = this.getCategoryColumnLabels();
        int[] columnWidth = this.getColumnWidth();
        CategorySortListener categorySortListener = new CategorySortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.tableCstGroup, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)categorySortListener);
            ++i;
        }
        this.tableCstGroup.setHeaderVisible(true);
        this.tableCstGroup.setLinesVisible(true);
        String[] colLabels2 = this.getLabItemsColumnLabels();
        int[] columnWidth2 = this.getColumnWidthLabItem();
        LabItemSortListener labItemSortListener = new LabItemSortListener();
        TableColumn[] cols2 = new TableColumn[colLabels2.length];
        int i2 = 0;
        while (i2 < colLabels2.length) {
            cols2[i2] = new TableColumn(this.tableLabItem, 0);
            cols2[i2].setWidth(columnWidth2[i2]);
            cols2[i2].setText(colLabels2[i2]);
            cols2[i2].setData((Object)new Integer(i2));
            cols2[i2].addSelectionListener((SelectionListener)labItemSortListener);
            ++i2;
        }
        this.tableLabItem.setHeaderVisible(true);
        this.tableLabItem.setLinesVisible(true);
        this.createBoldFont(this.tableCstGroup.getFont());
        this.myColorRed = this.createRedColor(this.tableCstGroup.getFont());
        this.tableViewerCstGroup = new CheckboxTableViewer(this.tableCstGroup);
        this.tableViewerCstGroup.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.tableViewerCstGroup.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider());
        this.tableViewerCstGroup.setSorter((ViewerSorter)new CategorySorter());
        this.tableViewerCstGroup.setInput((Object)this.getViewSite());
        if (this.tableCstGroup.getItems().length > 0) {
            this.tableCstGroup.select(0);
        }
        this.tableViewerLabItem = new CheckboxTableViewer(this.tableLabItem);
        this.tableViewerLabItem.setContentProvider((IContentProvider)new LabItemContentProvider());
        this.tableViewerLabItem.setLabelProvider((IBaseLabelProvider)new LabItemLabelProvider());
        this.tableViewerLabItem.setSorter((ViewerSorter)new LabItemSorter());
        this.tableViewerLabItem.setInput((Object)this.getViewSite());
        this.tableViewerCstGroup.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CstThemenblockEditor.this.tableViewerCstGroup.getSelection();
                CstGroup selGroup = (CstGroup)((Object)selection.getFirstElement());
                if (selGroup != null) {
                    CstThemenblockEditor.this.itemRanking = selGroup.getMap("itemsRanking");
                    CstThemenblockEditor.this.labItems = selGroup.getLabitems();
                    if (CstThemenblockEditor.this.itemRanking == null || CstThemenblockEditor.this.itemRanking.size() == 0) {
                        Hashtable<String, Integer> ranking = new Hashtable<String, Integer>();
                        int i = 1;
                        for (LabItemWrapper item : CstThemenblockEditor.this.labItems) {
                            ranking.put(item.getLabItem().getId(), i++);
                        }
                        CstThemenblockEditor.this.itemRanking = (Map)ranking.clone();
                        selGroup.setMap("itemsRanking", ranking);
                    }
                    CstThemenblockEditor.this.tableViewerLabItem.refresh();
                }
            }
        });
        Composite abstractCanvas = new Composite((Composite)baseCanvas, 256);
        GridLayout abstractGridLayout = new GridLayout(1, true);
        abstractCanvas.setLayout((Layout)abstractGridLayout);
        GridData gdAbstract = new GridData();
        gdAbstract.horizontalAlignment = 4;
        abstractCanvas.setLayoutData((Object)gdAbstract);
        Composite movebuttonCompo = new Composite(abstractCanvas, 0);
        GridLayout movebuttonGridLayout = new GridLayout(3, true);
        movebuttonCompo.setLayout((Layout)movebuttonGridLayout);
        GridData gdButtons = new GridData();
        gdButtons.horizontalAlignment = 0x1000000;
        gdButtons.heightHint = 80;
        gdButtons.verticalAlignment = 4;
        movebuttonCompo.setLayoutData((Object)gdButtons);
        gdButtons.minimumHeight = 80;
        Image imgArrowUp = UiDesk.getImage((String)"arrow-up");
        Image imgArrowDown = UiDesk.getImage((String)"arrow-down");
        Button btnArrowUp = new Button(movebuttonCompo, 2048);
        Button btnArrowDown = new Button(movebuttonCompo, 2048);
        btnArrowUp.setImage(imgArrowUp);
        btnArrowDown.setImage(imgArrowDown);
        GridData gdArrowUp = new GridData(3);
        GridData gdArrowDown = new GridData(3);
        btnArrowUp.setLayoutData((Object)gdArrowUp);
        btnArrowDown.setLayoutData((Object)gdArrowDown);
        btnArrowDown.setText(Messages.Button_MoveDown);
        btnArrowUp.setText(Messages.Button_MoveUp);
        btnArrowUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CstThemenblockEditor.this.moveItemUp();
            }
        });
        btnArrowDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CstThemenblockEditor.this.moveItemDown();
            }
        });
        this.txtAbstract = new Text(abstractCanvas, 2306);
        GridData gridDataText = new GridData(1808);
        gridDataText.verticalAlignment = 4;
        gridDataText.grabExcessVerticalSpace = true;
        gridDataText.grabExcessHorizontalSpace = true;
        gridDataText.heightHint = 200;
        this.txtAbstract.setLayoutData((Object)gridDataText);
        GridData gdBtnSaveAbst = new GridData();
        gdBtnSaveAbst.verticalAlignment = 1024;
        gdBtnSaveAbst.horizontalAlignment = 16384;
        Button btnSaveAbstract = new Button(abstractCanvas, 2048);
        btnSaveAbstract.setLayoutData((Object)gdBtnSaveAbst);
        btnSaveAbstract.setText("Save Abstract for Lab item");
        btnSaveAbstract.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        CstThemenblockEditor.this.saveAbstract();
                    }
                }
            }
        });
        final Label labelAbstract = new Label(abstractCanvas, 0);
        String sLabelAbstract = " Zeichen (max. ca. 500 Z.)";
        labelAbstract.setText("0  Zeichen (max. ca. 500 Z.)");
        GridData gdLabelAbstract = new GridData();
        gdLabelAbstract.verticalAlignment = 1024;
        gdLabelAbstract.horizontalAlignment = 16384;
        labelAbstract.setLayoutData((Object)gdLabelAbstract);
        this.txtAbstract.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                labelAbstract.setText(String.valueOf(String.valueOf(CstThemenblockEditor.this.txtAbstract.getText().length())) + " Zeichen (max. ca. 500 Z.)");
            }
        });
        this.tableViewerLabItem.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CstThemenblockEditor.this.tableViewerLabItem.getSelection();
                LabItemWrapper selItem = (LabItemWrapper)selection.getFirstElement();
                if (selItem != null) {
                    String text;
                    CstAbstract abst = CstAbstract.getByLaboritemId(selItem.getLabItem().getId());
                    if (abst == null) {
                        text = "default";
                    } else {
                        text = abst.getDescription1();
                        CstThemenblockEditor.this.log.debug("desc: " + abst.getDescription1());
                    }
                    CstThemenblockEditor.this.txtAbstract.setText(text);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewerCstGroup.getControl(), "ch.gpb.elexis.cst.viewer");
        this.makeActions();
        this.hookContextMenuCategory();
        this.hookContextMenuLabItem();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    private void saveAbstract() {
        TableItem[] selItemC = this.tableLabItem.getSelection();
        LabItemWrapper selGroup = (LabItemWrapper)selItemC[0].getData();
        CstAbstract abst = CstAbstract.getByLaboritemId(selGroup.getLabItem().getId());
        if (abst == null) {
            abst = new CstAbstract(selGroup.getLabItem().getId(), this.txtAbstract.getText(), "description2");
        } else {
            abst.setDescription1(this.txtAbstract.getText());
        }
    }

    private void loadGroups() {
        this.cstGroups = CstGroup.getCstGroups();
        this.tableViewerCstGroup.refresh();
        if (this.tableViewerCstGroup != null) {
            this.tableViewerCstGroup.refresh();
            this.tableCstGroup.setFocus();
        }
        if (this.tableViewerLabItem != null) {
            this.tableViewerLabItem.refresh();
        }
    }

    private void moveItemUp() {
        IStructuredSelection selection2 = (IStructuredSelection)this.tableViewerCstGroup.getSelection();
        CstGroup selGroup = (CstGroup)((Object)selection2.getFirstElement());
        try {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerLabItem.getSelection();
            LabItemWrapper selItem = (LabItemWrapper)selection.getFirstElement();
            if (selItem == null) {
                return;
            }
            int selIndex = this.tableViewerLabItem.getTable().getSelectionIndex();
            if (selIndex < 1) {
                return;
            }
            TableItem tableItem = this.tableViewerLabItem.getTable().getItem(selIndex - 1);
            LabItemWrapper aboveItem = (LabItemWrapper)tableItem.getData();
            int rank1 = (Integer)this.itemRanking.get(selItem.getLabItem().getId());
            int rank2 = (Integer)this.itemRanking.get(aboveItem.getLabItem().getId());
            this.itemRanking.put(selItem.getLabItem().getId(), rank1 - 1);
            this.itemRanking.put(aboveItem.getLabItem().getId(), rank2 + 1);
            selGroup.setMap("itemsRanking", this.itemRanking);
            this.tableViewerLabItem.refresh();
        }
        catch (Exception e) {
            this.showMessage("Fehler: die Reihenfolge der Laboritems muss neu initialisiert werden.");
            this.reinitRanking(selGroup);
        }
    }

    private void moveItemDown() {
        IStructuredSelection selection2 = (IStructuredSelection)this.tableViewerCstGroup.getSelection();
        CstGroup selGroup = (CstGroup)((Object)selection2.getFirstElement());
        try {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerLabItem.getSelection();
            LabItemWrapper selItem = (LabItemWrapper)selection.getFirstElement();
            if (selItem == null) {
                return;
            }
            int selIndex = this.tableViewerLabItem.getTable().getSelectionIndex();
            if (selIndex + 1 >= this.tableViewerLabItem.getTable().getItemCount()) {
                return;
            }
            TableItem tableItem = this.tableViewerLabItem.getTable().getItem(selIndex + 1);
            LabItemWrapper belowItem = (LabItemWrapper)tableItem.getData();
            int rank1 = (Integer)this.itemRanking.get(selItem.getLabItem().getId());
            int rank2 = (Integer)this.itemRanking.get(belowItem.getLabItem().getId());
            this.itemRanking.put(selItem.getLabItem().getId(), rank1 + 1);
            this.itemRanking.put(belowItem.getLabItem().getId(), rank2 - 1);
            selGroup.setMap("itemsRanking", this.itemRanking);
            this.tableViewerLabItem.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessage("Fehler: die Reihenfolge der Laboritems muss neu initialisiert werden.");
            this.reinitRanking(selGroup);
        }
    }

    private void selectFirstRow() {
        if (this.tableViewerCstGroup != null) {
            Object obj = this.tableViewerCstGroup.getElementAt(0);
            if (!this.cstGroups.isEmpty() && obj != null) {
                this.tableViewerCstGroup.setSelection((ISelection)new StructuredSelection(this.tableViewerCstGroup.getElementAt(0)), true);
            }
        }
    }

    private void selectRow(int row) {
        if (this.tableViewerCstGroup != null) {
            Object obj = this.tableViewerCstGroup.getElementAt(row);
            if (!this.cstGroups.isEmpty() && obj != null) {
                this.tableViewerCstGroup.setSelection((ISelection)new StructuredSelection(this.tableViewerCstGroup.getElementAt(row)), true);
            }
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    private Font createBoldFont(Font baseFont) {
        FontData fd = baseFont.getFontData()[0];
        Font font = new Font(baseFont.getDevice(), fd.getName(), 10, fd.getStyle() | 1);
        return font;
    }

    private Color createRedColor(Font baseFont) {
        this.myColorRed = new Color(baseFont.getDevice(), 255, 0, 0);
        return this.myColorRed;
    }

    private String[] getCategoryColumnLabels() {
        String[] columnLabels = new String[]{Messages.CstCategory_name, Messages.CstCategory_description};
        return columnLabels;
    }

    private String[] getLabItemsColumnLabels() {
        String[] columnLabels = new String[]{Messages.CstLaborPrefs_name, Messages.CstLaborPrefs_short, Messages.CstProfile_Ranking, Messages.CstLaborPrefs_refM, Messages.CstLaborPrefs_refF, "Immer anzeigen"};
        return columnLabels;
    }

    private int[] getColumnWidth() {
        int[] columnWidth = new int[]{120, 250};
        return columnWidth;
    }

    private int[] getColumnWidthLabItem() {
        int[] columnWidth = new int[]{200, 200, 40, 120, 120, 50};
        return columnWidth;
    }

    private void hookContextMenuCategory() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CstThemenblockEditor.this.fillContextMenuCategory(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewerCstGroup.getControl());
        this.tableViewerCstGroup.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewerCstGroup);
    }

    private void hookContextMenuLabItem() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CstThemenblockEditor.this.fillContextMenuLabItem(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewerLabItem.getControl());
        this.tableViewerLabItem.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewerLabItem);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreateCstGroup);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDeleteCstGroup);
    }

    private void fillContextMenuCategory(IMenuManager manager) {
        manager.add((IAction)this.actionCreateCstGroup);
        manager.add((IAction)this.actionDeleteCstGroup);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenuLabItem(IMenuManager manager) {
        manager.add((IAction)this.actionRemoveLabItem);
        manager.add((IAction)this.actionAddLabItems);
        manager.add((IAction)this.actionDisplayOnce);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreateCstGroup);
        manager.add((IAction)this.actionDeleteCstGroup);
    }

    private void makeActions() {
        this.actionCreateCstGroup = new Action(){

            public void run() {
                CstCategoryDialog dialog = new CstCategoryDialog(CstThemenblockEditor.this.tableViewerCstGroup.getControl().getShell());
                dialog.create();
                if (CstThemenblockEditor.this.isRepeatedDialog) {
                    dialog.setErrorMessage(Messages.Cst_Text_cstgroup_exists);
                }
                CstThemenblockEditor.this.isRepeatedDialog = false;
                if (dialog.open() == 0) {
                    if (dialog.getGroupName().length() < 1) {
                        return;
                    }
                } else {
                    return;
                }
                try {
                    Mandant m = CoreHub.actMandant;
                    if (m != null) {
                        CstGroup mapping = new CstGroup(dialog.getGroupName(), dialog.getGroupDescription(), null, m.getId());
                        CstThemenblockEditor.this.log.info("New CstGroup with id: " + mapping.getId());
                        CstThemenblockEditor.this.loadGroups();
                        TableItem[] items = CstThemenblockEditor.this.tableCstGroup.getItems();
                        int i = 0;
                        while (i < items.length) {
                            TableItem item = items[i];
                            CstGroup g = (CstGroup)((Object)item.getData());
                            if (g.getId().equals(mapping.getId())) {
                                CstThemenblockEditor.this.selectRow(i);
                                break;
                            }
                            ++i;
                        }
                        CstThemenblockEditor.this.tableViewerCstGroup.refresh(true);
                        CstThemenblockEditor.this.tableCstGroup.setFocus();
                    } else {
                        CstThemenblockEditor.this.log.info("error: no mandant available", (Object)4);
                    }
                }
                catch (Exception e) {
                    CstThemenblockEditor.this.log.info("CST Category already exists: " + e.getMessage(), (Object)4);
                    CstThemenblockEditor.this.isRepeatedDialog = true;
                    CstThemenblockEditor.this.actionCreateCstGroup.run();
                }
            }
        };
        this.actionCreateCstGroup.setText(Messages.Cst_Text_create_cstgroup);
        this.actionCreateCstGroup.setToolTipText(Messages.Cst_Text_create_cstgroup_tooltip);
        this.actionCreateCstGroup.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.actionDeleteCstGroup = new Action(){

            public void run() {
                TableItem[] selItem = CstThemenblockEditor.this.tableCstGroup.getSelection();
                if (selItem.length == 0) {
                    return;
                }
                CstGroup selGroup = (CstGroup)((Object)selItem[0].getData());
                String sMsg = String.format(Messages.Cst_Text_confirm_delete_group, selGroup.getName());
                CstThemenblockEditor.this.showMessage(sMsg);
                selGroup.delete();
                CstThemenblockEditor.this.loadGroups();
                CstThemenblockEditor.this.tableViewerCstGroup.refresh();
                CstThemenblockEditor.this.selectFirstRow();
                CstThemenblockEditor.this.tableCstGroup.setFocus();
            }
        };
        this.actionDeleteCstGroup.setText(Messages.Cst_Text_delete_cstgroup);
        this.actionDeleteCstGroup.setToolTipText(Messages.Cst_Text_delete_cstgroup_tooltip);
        this.actionDeleteCstGroup.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.actionRemoveLabItem = new Action(){

            public void run() {
                TableItem[] selItemC = CstThemenblockEditor.this.tableCstGroup.getSelection();
                CstGroup selGroup = (CstGroup)((Object)selItemC[0].getData());
                TableItem[] selItem = CstThemenblockEditor.this.tableLabItem.getSelection();
                if (selItem.length == 0) {
                    return;
                }
                LabItemWrapper labItem = (LabItemWrapper)selItem[0].getData();
                CstThemenblockEditor.this.log.debug("LabItem ID:" + labItem.getLabItem().getId());
                selGroup.removeLabitem(labItem.getLabItem());
                CstThemenblockEditor.this.loadGroups();
                CstThemenblockEditor.this.reinitRanking(selGroup);
                CstThemenblockEditor.this.tableViewerCstGroup.refresh();
                CstThemenblockEditor.this.tableViewerLabItem.refresh();
                CstThemenblockEditor.this.tableCstGroup.setFocus();
            }
        };
        this.actionRemoveLabItem.setText(Messages.Cst_Text_delete_from_cstgroup);
        this.actionRemoveLabItem.setToolTipText(Messages.Cst_Text_delete_from_cstgroup_tooltip);
        this.actionRemoveLabItem.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.actionDisplayOnce = new Action(){

            public void run() {
                TableItem[] selItemC = CstThemenblockEditor.this.tableCstGroup.getSelection();
                CstGroup selGroup = (CstGroup)((Object)selItemC[0].getData());
                TableItem[] selItem = CstThemenblockEditor.this.tableLabItem.getSelection();
                if (selItem.length == 0) {
                    return;
                }
                LabItemWrapper labItem = (LabItemWrapper)selItem[0].getData();
                CstThemenblockEditor.this.log.debug("LabItem ID:" + labItem.getLabItem().getId());
                int ret = selGroup.setDisplayOnce(labItem, labItem.getDisplayOnce().equals("1") ? "0" : "1");
                CstThemenblockEditor.this.loadGroups();
                CstThemenblockEditor.this.labItems = selGroup.getLabitems();
                CstThemenblockEditor.this.tableViewerLabItem.refresh();
                CstThemenblockEditor.this.tableCstGroup.setFocus();
            }
        };
        this.actionDisplayOnce.setText("Immer anzeigen");
        this.actionDisplayOnce.setToolTipText(Messages.Cst_Text_delete_from_cstgroup_tooltip);
        this.actionDisplayOnce.setImageDescriptor(Activator.getImageDescriptor("icons/displayonce.png"));
        this.actionAddLabItems = new Action(){

            public void run() {
                if (CstThemenblockEditor.this.dialogLabItems == null || CstThemenblockEditor.this.dialogLabItems.size() == 0) {
                    CstThemenblockEditor.this.dialogLabItems = LabItem.getLabItems();
                }
                CstLabItemSelectionDialog dialog = new CstLabItemSelectionDialog(CstThemenblockEditor.this.tableViewerLabItem.getControl().getShell(), CstThemenblockEditor.this.dialogLabItems);
                dialog.create();
                if (dialog.open() != 0) {
                    return;
                }
                List<LabItemWrapper> itemsToAdd = LabItemWrapper.wrap(dialog.getSelItems());
                TableItem[] selItemC = CstThemenblockEditor.this.tableCstGroup.getSelection();
                if (selItemC == null || selItemC.length < 1) {
                    return;
                }
                CstGroup selGroup = (CstGroup)((Object)selItemC[0].getData());
                if (selGroup == null) {
                    return;
                }
                try {
                    selGroup.addItems(itemsToAdd);
                }
                catch (Exception e) {
                    CstThemenblockEditor.this.showMessage("The Lab Item already exists in this CSTGroup");
                }
                CstThemenblockEditor.this.reinitRanking(selGroup);
                CstThemenblockEditor.this.tableViewerLabItem.refresh();
                CstThemenblockEditor.this.loadGroups();
                CstThemenblockEditor.this.tableViewerCstGroup.refresh();
                CstThemenblockEditor.this.tableViewerLabItem.refresh();
                CstThemenblockEditor.this.tableCstGroup.setFocus();
            }
        };
        this.actionAddLabItems.setText(Messages.Cst_Text_add_to_cstgroup);
        this.actionAddLabItems.setToolTipText(Messages.Cst_Text_add_to_cstgroup_tooltip);
        this.actionAddLabItems.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
    }

    private void reinitRanking(CstGroup selGroup) {
        this.labItems = selGroup.getLabitems();
        Hashtable<String, Integer> ranking = new Hashtable<String, Integer>();
        int i = 1;
        for (LabItemWrapper item : this.labItems) {
            ranking.put(item.getLabItem().getId(), i++);
        }
        this.itemRanking = (Map)ranking.clone();
        selGroup.setMap("itemsRanking", ranking);
        this.log.debug("reinitialize the ranking");
    }

    private void hookDoubleClickAction() {
        this.tableViewerCstGroup.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] selItem = CstThemenblockEditor.this.tableCstGroup.getSelection();
                selItem[0].getData();
                ISelection selection = CstThemenblockEditor.this.tableViewerCstGroup.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                CstGroup profile = (CstGroup)((Object)obj);
                ThemenblockDetailDialog dialog = new ThemenblockDetailDialog(CstThemenblockEditor.this.tableViewerCstGroup.getControl().getShell());
                dialog.create();
                dialog.setName(profile.getName());
                dialog.setDescription(profile.getDescription());
                if (dialog.open() == 0) {
                    profile.setName(dialog.getName());
                    profile.setDescription(dialog.getDescription());
                    CstThemenblockEditor.this.loadGroups();
                    CstThemenblockEditor.this.tableViewerCstGroup.setSelection(selection);
                }
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.tableViewerCstGroup.getControl().getShell(), (String)"CST View", (String)message);
    }

    public void setFocus() {
        this.tableViewerCstGroup.getControl().setFocus();
        this.loadGroups();
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
    }

    class CategoryContentProvider
    implements IStructuredContentProvider {
        CategoryContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return CstThemenblockEditor.this.cstGroups.toArray();
        }
    }

    class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        CategoryLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            CstGroup cstGroup = (CstGroup)((Object)obj);
            switch (index) {
                case 0: {
                    return cstGroup.getName();
                }
                case 1: {
                    return cstGroup.getDescription();
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            boolean cfr_ignored_0 = element instanceof LabItemWrapper;
            return font;
        }

        public Color getForeground(Object element) {
            if (element instanceof CstGroup) {
                CstGroup cstGroup = (CstGroup)((Object)element);
                TableItem[] items = CstThemenblockEditor.this.tableCstGroup.getItems();
                int x = 0;
                while (x < items.length) {
                    TableItem item = items[x];
                    item.setChecked(true);
                    ++x;
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class CategorySortListener
    extends SelectionAdapter {
        CategorySortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstThemenblockEditor.this.sortColumn) {
                    CstThemenblockEditor.this.sortReverse = !CstThemenblockEditor.this.sortReverse;
                } else {
                    CstThemenblockEditor.this.sortReverse = false;
                    CstThemenblockEditor.this.sortColumn = colNo;
                }
                CstThemenblockEditor.this.tableViewerCstGroup.refresh();
            }
        }
    }

    class CategorySorter
    extends ViewerSorter {
        CategorySorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CstGroup && e2 instanceof CstGroup) {
                CstGroup d1 = (CstGroup)((Object)e1);
                CstGroup d2 = (CstGroup)((Object)e2);
                String c1 = "";
                String c2 = "";
                switch (CstThemenblockEditor.this.sortColumn) {
                    case 0: {
                        c1 = d1.getName();
                        c2 = d2.getName();
                        break;
                    }
                    case 1: {
                        c1 = d1.getDescription();
                        c2 = d2.getDescription();
                    }
                }
                if (CstThemenblockEditor.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class LabItemContentProvider
    implements IStructuredContentProvider {
        LabItemContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return CstThemenblockEditor.this.labItems.toArray();
        }
    }

    class LabItemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        LabItemLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            LabItemWrapper labItem = (LabItemWrapper)obj;
            switch (index) {
                case 0: {
                    return labItem.getLabItem().getName();
                }
                case 1: {
                    return labItem.getLabItem().getKuerzel();
                }
                case 2: {
                    if (CstThemenblockEditor.this.itemRanking.get(labItem.getLabItem().getId()) == null) {
                        IStructuredSelection selection = (IStructuredSelection)CstThemenblockEditor.this.tableViewerCstGroup.getSelection();
                        Object o = selection.getFirstElement();
                        CstGroup profile = (CstGroup)((Object)o);
                        CstThemenblockEditor.this.reinitRanking(profile);
                    }
                    return String.valueOf(CstThemenblockEditor.this.itemRanking.get(labItem.getLabItem().getId()));
                }
                case 3: {
                    return labItem.getLabItem().getRefM();
                }
                case 4: {
                    return labItem.getLabItem().getRefW();
                }
                case 5: {
                    if (labItem.getDisplayOnce() == null) {
                        return "null";
                    }
                    return labItem.getDisplayOnce().equals("1") ? "Ja" : "Nein";
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            boolean cfr_ignored_0 = element instanceof LabItemWrapper;
            return font;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class LabItemSortListener
    extends SelectionAdapter {
        LabItemSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstThemenblockEditor.this.sortColumn) {
                    CstThemenblockEditor.this.sortReverse = !CstThemenblockEditor.this.sortReverse;
                } else {
                    CstThemenblockEditor.this.sortReverse = false;
                    CstThemenblockEditor.this.sortColumn = colNo;
                }
                CstThemenblockEditor.this.tableViewerLabItem.refresh();
            }
        }
    }

    class LabItemSorter
    extends ViewerSorter {
        LabItemSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof LabItemWrapper && e2 instanceof LabItemWrapper) {
                LabItemWrapper d1 = (LabItemWrapper)e1;
                LabItemWrapper d2 = (LabItemWrapper)e2;
                Integer r1 = (Integer)CstThemenblockEditor.this.itemRanking.get(d1.getLabItem().getId());
                Integer r2 = (Integer)CstThemenblockEditor.this.itemRanking.get(d2.getLabItem().getId());
                if (r1 == null || r2 == null) {
                    return 0;
                }
                return r1.compareTo(r2);
            }
            return 0;
        }
    }
}

