/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view;

import ch.elexis.befunde.Messwert;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.gpb.elexis.cst.Activator;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstGastroColo;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.CstProimmun;
import ch.gpb.elexis.cst.data.LabItemWrapper;
import ch.gpb.elexis.cst.data.ValuePairTimeline;
import ch.gpb.elexis.cst.data.ValueSingleTimeline;
import ch.gpb.elexis.cst.dialog.PdfOptionsDialog;
import ch.gpb.elexis.cst.preferences.CstPreference;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.util.ImageUtils;
import ch.gpb.elexis.cst.widget.GastroColoCanvas;
import ch.gpb.elexis.cst.widget.ValuePairTimelineCanvas;
import ch.gpb.elexis.cst.widget.ValueSingleTimelineCanvas;
import ch.rgw.tools.TimeTool;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CstResultPart
extends ViewPart
implements IActivationListener {
    protected Logger log = LoggerFactory.getLogger((String)CstResultPart.class.getName());
    Patient patient;
    CstProfile profile;
    Composite baseComposite;
    Font fontSmall;
    Font fontBig;
    Font fontMedium;
    org.eclipse.swt.graphics.Color RED;
    org.eclipse.swt.graphics.Color YELLOW;
    org.eclipse.swt.graphics.Color WHITE;
    org.eclipse.swt.graphics.Color BROWN;
    org.eclipse.swt.graphics.Color ORANGE;
    org.eclipse.swt.graphics.Color GRAY;
    org.eclipse.swt.graphics.Color LIGHTGRAY;
    String[] flds = null;
    private Action actionScreenshot;
    private Action actionPdf;
    public static int OUTPUTWIDTH = 794;
    public static int OUTPUTHEIGTH = 1123;
    boolean a4Quer = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        Font initialFont = site.getShell().getFont();
        FontData[] fontDataSmall = initialFont.getFontData();
        int i = 0;
        while (i < fontDataSmall.length) {
            fontDataSmall[i].setHeight(7);
            ++i;
        }
        this.fontSmall = new Font((Device)site.getShell().getDisplay(), fontDataSmall);
        FontData[] fontDataBig = initialFont.getFontData();
        int i2 = 0;
        while (i2 < fontDataBig.length) {
            fontDataBig[i2].setHeight(12);
            ++i2;
        }
        this.fontBig = new Font((Device)site.getShell().getDisplay(), fontDataBig);
        FontData[] fontDataMedium = initialFont.getFontData();
        int i3 = 0;
        while (i3 < fontDataMedium.length) {
            fontDataMedium[i3].setHeight(10);
            ++i3;
        }
        this.fontMedium = new Font((Device)site.getShell().getDisplay(), fontDataMedium);
        this.RED = UiDesk.getColorFromRGB((String)"FF2222");
        this.YELLOW = UiDesk.getColorFromRGB((String)"FFEF46");
        this.WHITE = UiDesk.getColorFromRGB((String)"FFFFFF");
        this.BROWN = UiDesk.getColorFromRGB((String)"CC9900");
        this.ORANGE = UiDesk.getColorFromRGB((String)"FFCC66");
        this.GRAY = UiDesk.getColorFromRGB((String)"888888");
        this.LIGHTGRAY = UiDesk.getColorFromRGB((String)"DDDDDD");
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.fontSmall.dispose();
        this.fontBig.dispose();
        this.fontMedium.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        FillLayout parentLayout = new FillLayout(512);
        parent.setLayout((Layout)parentLayout);
        parent.setBackground(this.WHITE);
        GridLayout baseLayout = new GridLayout(1, false);
        baseLayout.numColumns = 1;
        final ScrolledComposite sc1 = new ScrolledComposite(parent, 2816);
        this.baseComposite = new Composite((Composite)sc1, 0);
        this.baseComposite.setLayout((Layout)baseLayout);
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        this.baseComposite.setLayoutData((Object)gd);
        this.baseComposite.setBackground(this.RED);
        sc1.setContent((Control)this.baseComposite);
        sc1.setMinSize(OUTPUTWIDTH, 800);
        sc1.setSize(OUTPUTWIDTH, 800);
        sc1.setExpandHorizontal(true);
        sc1.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                int wheelCount = event.count;
                wheelCount = (int)Math.ceil((float)wheelCount / 3.0f);
                while (wheelCount < 0) {
                    sc1.getVerticalBar().setIncrement(50);
                    ++wheelCount;
                }
                while (wheelCount > 0) {
                    sc1.getVerticalBar().setIncrement(-50);
                    --wheelCount;
                }
            }
        });
        sc1.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                sc1.setFocus();
                sc1.getVerticalBar().setIncrement(40);
            }
        });
        Point pBaseComp = this.baseComposite.computeSize(-1, -1);
        this.baseComposite.setSize(pBaseComp);
        this.makeActions((Control)this.baseComposite);
        this.contributeToActionBars();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void setFocus() {
    }

    public void activation(boolean mode) {
    }

    public abstract void layoutDisplay(CstProfile var1);

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionScreenshot);
        manager.add((IAction)this.actionPdf);
        manager.add((IContributionItem)new Separator());
    }

    protected String getHeader(Patient patient) {
        String title = String.valueOf(Messages.Cst_Text_Interpretation_Mitochondrienlabor) + " (" + this.profile.getName() + ") " + Messages.Cst_Text_fuer + " " + patient.getName() + " " + patient.getVorname() + " " + patient.getGeburtsdatum();
        return title;
    }

    protected String getSubTitle(Patient patient, CstProfile aProfile) {
        String title = String.valueOf(Messages.CstProfileEditor_Datum) + ": " + CstService.getReadableDateAndTime() + "    (" + Messages.Cst_Text_Auswertungstyp_effektiv + " " + Messages.Cst_Text_startdatum + " " + CstService.getGermanFromCompact(aProfile.getValidFrom()) + " " + Messages.CstProfileEditor_Crawlback + " " + aProfile.getCrawlBack() + ")";
        return title;
    }

    protected void addLine(Composite comp, int indent) {
        comp.pack();
        Label labelLine = new Label(comp, 0);
        GridData gdLine = new GridData(0);
        gdLine.verticalIndent = indent;
        labelLine.setLayoutData((Object)gdLine);
        comp.pack();
    }

    protected void checkPageBreak(Composite comp) {
        comp.pack();
        int currentHeigth = comp.getSize().y;
        int printHeigth = this.profile.getAusgabeRichtung() ? 794 : 1123;
        int pageCnt = currentHeigth / printHeigth;
        int rmn = (pageCnt + 1) * printHeigth - currentHeigth;
        if (rmn < 250) {
            this.addLine(comp, rmn);
        }
    }

    protected void addNoValuesLabel(Composite composite) {
        StringBuffer lblText = new StringBuffer(Messages.CstResultEffektiv_hinweis_keine_werte);
        Label lblNoValues = new Label(composite, 0);
        GridData gdNoValues = new GridData(4, 4, true, true, 1, 1);
        gdNoValues.grabExcessHorizontalSpace = true;
        gdNoValues.horizontalAlignment = 4;
        gdNoValues.widthHint = this.profile.getAusgabeRichtung() ? 858 : 530;
        lblNoValues.setLayoutData((Object)gdNoValues);
        lblNoValues.setText(lblText.toString());
        lblNoValues.setForeground(this.RED);
        lblNoValues.setBackground(this.WHITE);
    }

    protected void addBefunde(Composite baseComposite) {
        GridData gdReaktion2;
        baseComposite.pack();
        this.checkPageBreak(baseComposite);
        Composite compoDarmfunktion = new Composite(baseComposite, 2052);
        compoDarmfunktion.setBackground(this.WHITE);
        compoDarmfunktion.setSize(780, 400);
        GridLayout dlDarmfunktion = new GridLayout(2, false);
        compoDarmfunktion.setLayout((Layout)dlDarmfunktion);
        GridData gdDarmfunktion = new GridData();
        gdDarmfunktion.verticalAlignment = 4;
        gdDarmfunktion.grabExcessHorizontalSpace = false;
        gdDarmfunktion.widthHint = 780;
        compoDarmfunktion.setLayoutData((Object)gdDarmfunktion);
        CstProimmun cstProimmun = CstProimmun.getByProfileId(this.profile.getId());
        if (cstProimmun != null) {
            String sLabeltxt = String.valueOf(Messages.Cst_Text_Proimmun) + "\r\n" + Messages.Cst_Text_IggAntikoerper + "\r\n" + "\r\n" + cstProimmun.getTested() + "\r\n" + "\r\n" + " von " + cstProimmun.getToBeTested() + " " + Messages.Cst_Text_getesteten + "\r\n" + Messages.Cst_Text_Lebensmittel + "\r\n\r\n" + CstService.getGermanFromCompact(cstProimmun.getDatum());
            Label lblDarmfunktion = new Label(compoDarmfunktion, 0);
            lblDarmfunktion.setLayoutData((Object)new GridData(1040));
            lblDarmfunktion.setText(sLabeltxt);
            lblDarmfunktion.setFont(this.fontSmall);
            Composite compoRightHalf = new Composite(compoDarmfunktion, 4);
            compoRightHalf.setLayout((Layout)new GridLayout(2, false));
            Label lblReaktion4 = new Label(compoRightHalf, 0);
            lblReaktion4.setForeground(this.BROWN);
            lblReaktion4.setText(Messages.CstProfileEditor_Reaktionsstaerke4);
            lblReaktion4.setLayoutData((Object)new GridData(0));
            lblReaktion4.setFont(this.fontSmall);
            Text txtReaktion4 = new Text(compoRightHalf, 578);
            GridData gdReaktion4 = new GridData(4, 0x1000000, true, false);
            gdReaktion4.widthHint = 540;
            gdReaktion4.heightHint = 55;
            txtReaktion4.setLayoutData((Object)gdReaktion4);
            txtReaktion4.setText(cstProimmun.getText4());
            txtReaktion4.setFont(this.fontSmall);
            txtReaktion4.setEditable(false);
            txtReaktion4.setBackground(this.WHITE);
            Label lblReaktion3 = new Label(compoRightHalf, 0);
            lblReaktion3.setText(Messages.CstProfileEditor_Reaktionsstaerke3);
            lblReaktion3.setForeground(this.RED);
            lblReaktion3.setLayoutData((Object)new GridData(0));
            lblReaktion3.setFont(this.fontSmall);
            Text txtReaktion3 = new Text(compoRightHalf, 578);
            GridData gdReaktion3 = new GridData(4, 0x1000000, true, false);
            gdReaktion3.widthHint = 540;
            gdReaktion3.heightHint = 55;
            txtReaktion3.setLayoutData((Object)gdReaktion3);
            txtReaktion3.setText(cstProimmun.getText3());
            txtReaktion3.setFont(this.fontSmall);
            txtReaktion3.setEditable(false);
            txtReaktion3.setBackground(this.WHITE);
            Label lblReaktion2 = new Label(compoRightHalf, 0);
            lblReaktion2.setText(Messages.CstProfileEditor_Reaktionsstaerke2);
            lblReaktion2.setForeground(this.ORANGE);
            lblReaktion2.setLayoutData((Object)new GridData(0));
            lblReaktion2.setFont(this.fontSmall);
            Text txtReaktion2 = new Text(compoRightHalf, 578);
            gdReaktion2 = new GridData(4, 0x1000000, true, false);
            gdReaktion2.heightHint = 55;
            gdReaktion2.widthHint = 540;
            txtReaktion2.setLayoutData((Object)gdReaktion2);
            txtReaktion2.setText(cstProimmun.getText2());
            txtReaktion2.setFont(this.fontSmall);
            txtReaktion2.setEditable(false);
            txtReaktion2.setBackground(this.WHITE);
            Label lblReaktion1 = new Label(compoRightHalf, 0);
            lblReaktion1.setText(Messages.CstProfileEditor_Reaktionsstaerke1);
            lblReaktion1.setForeground(this.YELLOW);
            lblReaktion1.setLayoutData((Object)new GridData(0));
            lblReaktion1.setFont(this.fontSmall);
            Text txtReaktion1 = new Text(compoRightHalf, 578);
            GridData gdReaktion1 = new GridData(4, 0x1000000, true, false);
            gdReaktion1.widthHint = 540;
            gdReaktion1.heightHint = 55;
            txtReaktion1.setLayoutData((Object)gdReaktion1);
            txtReaktion1.setText(cstProimmun.getText1());
            txtReaktion1.setFont(this.fontSmall);
            txtReaktion1.setEditable(false);
            txtReaktion1.setBackground(this.WHITE);
            cstProimmun.getDatum();
        }
        baseComposite.pack();
        this.checkPageBreak(baseComposite);
        if (this.patient.getFixmedikation().length > 0) {
            Composite compoFixmedi = new Composite(baseComposite, 2052);
            compoFixmedi.setBackground(this.WHITE);
            compoFixmedi.setLayout((Layout)new GridLayout(1, false));
            GridData gdFixmedi = new GridData();
            gdFixmedi.grabExcessHorizontalSpace = false;
            gdFixmedi.horizontalAlignment = 1;
            gdFixmedi.widthHint = 780;
            compoFixmedi.setLayoutData((Object)gdFixmedi);
            Label lFixmediTitel = new Label(compoFixmedi, 4);
            GridData gdFixmediTitel = new GridData();
            lFixmediTitel.setLayoutData((Object)gdFixmediTitel);
            lFixmediTitel.setText(this.profile.getTherapievorschlag());
            lFixmediTitel.setSize(200, 40);
            lFixmediTitel.setText(Messages.Cst_Text_Fixmedikation);
            lFixmediTitel.setFont(this.fontBig);
            lFixmediTitel.setBackground(this.WHITE);
            Label lblFixmedi = new Label(compoFixmedi, 4);
            GridData gdFixText = new GridData(4);
            gdFixText.grabExcessHorizontalSpace = true;
            lblFixmedi.setLayoutData((Object)gdFixText);
            GridData prescriptions = this.patient.getFixmedikation();
            StringBuffer sb = new StringBuffer();
            gdReaktion2 = prescriptions;
            int txtReaktion2 = ((Prescription[])gdReaktion2).length;
            int lblReaktion2 = 0;
            while (lblReaktion2 < txtReaktion2) {
                Prescription prescription = gdReaktion2[lblReaktion2];
                this.log.info("Prescription: " + prescription.getLabel() + "/" + prescription.getDosis());
                sb.append(prescription.getLabel());
                sb.append("\r\n");
                ++lblReaktion2;
            }
            lblFixmedi.setText(sb.toString());
            lblFixmedi.setFont(this.fontSmall);
            lblFixmedi.setBackground(this.WHITE);
        }
        baseComposite.pack();
        this.checkPageBreak(baseComposite);
        Map mAuswahl = this.profile.getMap("Auswahlbefunde");
        List<String> befundFelder = CstService.getBefundArtenFields();
        for (String befundFeld : befundFelder) {
            if (!CstService.isBefundSelected(mAuswahl, befundFeld)) continue;
            Composite compoBefunde = new Composite(baseComposite, 2052);
            compoBefunde.setBackground(this.WHITE);
            compoBefunde.setLayout((Layout)new GridLayout(1, false));
            GridData gdBefunde = new GridData();
            gdBefunde.horizontalAlignment = 1;
            gdBefunde.grabExcessHorizontalSpace = false;
            gdBefunde.widthHint = 780;
            compoBefunde.setLayoutData((Object)gdBefunde);
            String befundParameter = CstService.getBefundArtOfField(this.profile, befundFeld);
            String separator = CstService.getBefundArtSeparator(mAuswahl, befundFeld);
            if (separator != null) {
                values = this.getValuesForValuePairTimeline(this.patient, befundParameter, befundFeld, separator);
                Composite compoValuePair = new Composite(compoBefunde, 4);
                gridLayoutBase = new GridLayout();
                gridLayoutBase.numColumns = 1;
                compoValuePair.setLayout((Layout)gridLayoutBase);
                compoValuePair.setSize(490, 300);
                gdBlutdruck = new GridData();
                gdBlutdruck.horizontalAlignment = 0x1000000;
                compoValuePair.setLayoutData((Object)gdBlutdruck);
                splits = befundFeld.split(":/:");
                ValuePairTimelineCanvas bdCanvas = new ValuePairTimelineCanvas(compoValuePair, 4, String.valueOf(befundParameter) + " (" + splits[0] + ")", splits[0]);
                bdCanvas.setLayoutData(new GridData(1));
                bdCanvas.setFindings(values);
            } else {
                values = this.getValuesForSingleValueTimeline(this.patient, befundParameter, befundFeld);
                Composite compoValueSingle = new Composite(compoBefunde, 4);
                gridLayoutBase = new GridLayout();
                gridLayoutBase.numColumns = 1;
                compoValueSingle.setLayout((Layout)gridLayoutBase);
                compoValueSingle.setSize(490, 300);
                gdBlutdruck = new GridData();
                gdBlutdruck.horizontalAlignment = 0x1000000;
                compoValueSingle.setLayoutData((Object)gdBlutdruck);
                splits = befundFeld.split(":/:");
                ValueSingleTimelineCanvas bdGewicht = new ValueSingleTimelineCanvas(compoValueSingle, 4, String.valueOf(befundParameter) + " (" + splits[0] + ")", splits[0]);
                bdGewicht.setLayoutData(new GridData(1));
                bdGewicht.setFindings(values);
            }
            baseComposite.pack();
            this.checkPageBreak(baseComposite);
        }
        CstGastroColo cstGastroColo = CstGastroColo.getByProfileId(this.profile.getId());
        Composite compoDarm = new Composite(baseComposite, 2052);
        compoDarm.setBackground(this.WHITE);
        compoDarm.setLayout((Layout)new GridLayout());
        GridData gdDarm = new GridData();
        gdDarm.horizontalAlignment = 1;
        gdDarm.grabExcessHorizontalSpace = false;
        gdDarm.widthHint = 780;
        compoDarm.setLayoutData((Object)gdDarm);
        Label lDarm = new Label(compoDarm, 4);
        GridData gdDarm2 = new GridData();
        lDarm.setLayoutData((Object)gdDarm2);
        lDarm.setSize(200, 40);
        lDarm.setText(Messages.Cst_Text_Darmuntersuchungen);
        lDarm.setFont(this.fontBig);
        lDarm.setBackground(this.WHITE);
        GastroColoCanvas gcCanvas = new GastroColoCanvas(compoDarm, 0, cstGastroColo);
        gcCanvas.setLayoutData(new GridData(4));
        this.checkPageBreak(baseComposite);
        Composite compoTherapie = new Composite(baseComposite, 2052);
        compoTherapie.setBackground(this.WHITE);
        compoTherapie.setLayout((Layout)new GridLayout());
        GridData gdTherapie = new GridData();
        gdTherapie.horizontalAlignment = 1;
        gdTherapie.grabExcessHorizontalSpace = false;
        gdTherapie.widthHint = 780;
        compoTherapie.setLayoutData((Object)gdTherapie);
        Label lTherapie = new Label(compoTherapie, 4);
        GridData gdTherapie1 = new GridData();
        lTherapie.setLayoutData((Object)gdTherapie1);
        lTherapie.setSize(200, 40);
        lTherapie.setText(Messages.Cst_Text_Therapievorschlag);
        lTherapie.setFont(this.fontBig);
        lTherapie.setBackground(this.WHITE);
        Text txtTherapie = new Text(compoTherapie, 72);
        txtTherapie.setFont(this.fontSmall);
        GridData gdTherapie2 = new GridData(1040);
        gdTherapie2.verticalAlignment = 128;
        gdTherapie2.grabExcessVerticalSpace = true;
        txtTherapie.setLayoutData((Object)gdTherapie2);
        txtTherapie.setBackground(this.WHITE);
        txtTherapie.setText(this.profile.getTherapievorschlag());
        this.checkPageBreak(baseComposite);
        Composite compoDiagnose = new Composite(baseComposite, 2052);
        compoDiagnose.setBackground(this.WHITE);
        compoDiagnose.setLayout((Layout)new GridLayout());
        GridData gdDiagnose = new GridData();
        gdDiagnose.horizontalAlignment = 1;
        gdDiagnose.grabExcessHorizontalSpace = false;
        gdDiagnose.widthHint = 780;
        compoDiagnose.setLayoutData((Object)gdDiagnose);
        Label lDiagnose = new Label(compoDiagnose, 4);
        GridData gdDiagnose1 = new GridData();
        lDiagnose.setLayoutData((Object)gdDiagnose1);
        lDiagnose.setText(this.profile.getTherapievorschlag());
        lDiagnose.setSize(200, 40);
        lDiagnose.setText(Messages.CstProfileEditor_Diagnose);
        lDiagnose.setFont(this.fontBig);
        lDiagnose.setBackground(this.WHITE);
        Text txtDiagnose = new Text(compoDiagnose, 72);
        txtDiagnose.setFont(this.fontSmall);
        GridData gdDiagnose2 = new GridData(1040);
        gdDiagnose2.verticalAlignment = 128;
        gdDiagnose2.grabExcessVerticalSpace = true;
        txtDiagnose.setLayoutData((Object)gdDiagnose2);
        txtDiagnose.setBackground(this.WHITE);
        txtDiagnose.setText(this.profile.getDiagnose());
        this.checkPageBreak(baseComposite);
    }

    private void makeActions(final Control viewer) {
        this.actionScreenshot = new Action(){

            public void run() {
                if (CstResultPart.this.profile == null) {
                    SWTHelper.alert((String)"No profile", (String)"Ohne Profil kann kein Resultat erzeugt werden");
                    return;
                }
                GC gc = null;
                org.eclipse.swt.graphics.Image image = null;
                try {
                    String latestPath = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_LATESTPATH, null);
                    if (latestPath == null) {
                        latestPath = System.getProperty("user.home");
                    }
                    FileDialog fd = new FileDialog(CstResultPart.this.baseComposite.getShell(), 8192);
                    fd.setText("Save");
                    fd.setFilterPath(latestPath);
                    String[] filterExt = new String[]{"*.png", "*.*"};
                    fd.setFilterExtensions(filterExt);
                    fd.setFileName(CstService.generateFilename(CstResultPart.this.patient));
                    String selected = fd.open();
                    if (selected == null) {
                        return;
                    }
                    try {
                        File selFile = new File(selected);
                        ConfigServiceHolder.setUser((String)CstPreference.CST_IDENTIFIER_LATESTPATH, (String)selFile.getParentFile().getAbsolutePath());
                        image = CstResultPart.this.profile.getAnzeigeTyp().toLowerCase().equals("Effektiv") ? (CstResultPart.this.profile.getAusgabeRichtung() ? new org.eclipse.swt.graphics.Image((Device)viewer.getDisplay(), 1123, viewer.getBounds().height) : new org.eclipse.swt.graphics.Image((Device)viewer.getDisplay(), 794, viewer.getBounds().height)) : new org.eclipse.swt.graphics.Image((Device)viewer.getDisplay(), 794, viewer.getBounds().height);
                        ImageLoader loader = new ImageLoader();
                        gc = new GC((Drawable)image);
                        viewer.print(gc);
                        gc.dispose();
                        loader.data = new ImageData[]{image.getImageData()};
                        loader.save(selected, 5);
                    }
                    catch (Exception e) {
                        CstResultPart.this.log.error("Error saving png: " + e.toString());
                        CstResultPart.this.showMessage("Error while saving PNG", e.getMessage());
                    }
                }
                finally {
                    if (image != null) {
                        image.dispose();
                    }
                    if (gc != null) {
                        gc.dispose();
                    }
                }
            }
        };
        this.actionScreenshot.setText(Messages.Cst_Text_Save_as_png);
        this.actionScreenshot.setToolTipText(Messages.Cst_Text_Save_as_png);
        this.actionScreenshot.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS"));
        this.actionScreenshot.setImageDescriptor(Activator.getImageDescriptor("icons/png-icon-32.png"));
        this.actionPdf = new Action(){

            public void run() {
                if (CstResultPart.this.profile == null) {
                    SWTHelper.alert((String)"No profile", (String)"Ohne Profil kann kein Resultat erzeugt werden");
                    return;
                }
                GC gc = null;
                org.eclipse.swt.graphics.Image image = null;
                try {
                    Document document;
                    String sTitle;
                    String latestPath = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_LATESTPATH, null);
                    if (latestPath == null) {
                        latestPath = System.getProperty("user.home");
                    }
                    FileDialog fd = new FileDialog(CstResultPart.this.baseComposite.getShell(), 8192);
                    fd.setText("Save");
                    fd.setFilterPath(latestPath);
                    String[] filterExt = new String[]{"*.pdf", "*.*"};
                    fd.setFilterExtensions(filterExt);
                    fd.setFileName(CstService.generateFilename(CstResultPart.this.patient));
                    String selected = fd.open();
                    if (selected == null) {
                        return;
                    }
                    File selFile = new File(selected);
                    ConfigServiceHolder.setUser((String)CstPreference.CST_IDENTIFIER_LATESTPATH, (String)selFile.getParentFile().getAbsolutePath());
                    int printHeigth = 1123;
                    int printWidth = 794;
                    if (CstResultPart.this.profile.getAusgabeRichtung()) {
                        printHeigth = 794;
                        printWidth = 1123;
                    }
                    image = new org.eclipse.swt.graphics.Image((Device)viewer.getDisplay(), printWidth, viewer.getBounds().height);
                    ImageLoader loader = new ImageLoader();
                    gc = new GC((Drawable)image);
                    viewer.print(gc);
                    gc.dispose();
                    Patient patient = Patient.load((String)CstResultPart.this.profile.getKontaktId());
                    String string = sTitle = CstResultPart.this.profile.getOutputHeader() == null ? "No header configured!" : CstResultPart.this.profile.getOutputHeader();
                    if (sTitle == null || sTitle.length() == 0) {
                        sTitle = "No header configured!";
                    }
                    sTitle = String.valueOf(sTitle) + " Datum: " + CstService.getReadableDateAndTime();
                    int pdfOutputOption = 0;
                    boolean onePage = true;
                    PdfOptionsDialog dialog = new PdfOptionsDialog(CstResultPart.this.baseComposite.getShell());
                    dialog.create();
                    if (dialog.open() == 0) {
                        pdfOutputOption = dialog.getPdfOutputOption();
                        onePage = pdfOutputOption == PdfOptionsDialog.OPTION_ONE_PAGE;
                    }
                    float docHeight = viewer.getBounds().height;
                    docHeight /= 7.5f;
                    float fontSize = 12.0f;
                    if (docHeight < 360.0f) {
                        docHeight = 360.0f;
                    }
                    BufferedImage bimage = ImageUtils.convertToAWT(image.getImageData());
                    Image itextImage = null;
                    java.awt.Image awtImage = null;
                    try {
                        awtImage = Toolkit.getDefaultToolkit().createImage(bimage.getSource());
                        itextImage = Image.getInstance((java.awt.Image)awtImage, null);
                    }
                    catch (Exception e) {
                        CstResultPart.this.log.error("Error on image loading: " + e.toString());
                        e.printStackTrace();
                        if (image != null) {
                            image.dispose();
                        }
                        if (gc != null) {
                            gc.dispose();
                        }
                        return;
                    }
                    Rectangle pagesize = new Rectangle(595.0f, itextImage.getHeight() * 0.75f);
                    if (CstResultPart.this.profile.getAusgabeRichtung()) {
                        pagesize = new Rectangle(842.0f, itextImage.getHeight() * 0.75f);
                    }
                    if (onePage) {
                        document = new Document(pagesize);
                    } else {
                        document = new Document(PageSize.A4);
                        if (CstResultPart.this.profile.getAusgabeRichtung()) {
                            document = new Document(PageSize.A4.rotate());
                        }
                    }
                    document.addCreationDate();
                    try {
                        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(selected));
                        BaseFont bf_helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
                        BaseFont bf_times = BaseFont.createFont((String)"Times-Roman", (String)"Cp1252", (boolean)true);
                        BaseFont bf_courier = BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)true);
                        com.lowagie.text.Font fontHelv12 = new com.lowagie.text.Font(bf_helv, fontSize);
                        com.lowagie.text.Font fontTimes = new com.lowagie.text.Font(bf_times, fontSize);
                        fontTimes.setSize(fontSize);
                        fontTimes.setStyle(2);
                        Chunk chunkHeader = new Chunk(sTitle, FontFactory.getFont((String)"Helvetica", (float)fontSize, (int)0, (Color)new Color(255, 0, 0)));
                        Phrase phraseHeader = new Phrase(chunkHeader);
                        Chunk chunkFooter = new Chunk("Seite: ", FontFactory.getFont((String)"Helvetica", (float)fontSize, (int)1, (Color)new Color(0, 0, 0)));
                        Phrase phraseFooter = new Phrase(chunkFooter);
                        phraseFooter.setFont(fontHelv12);
                        HeaderFooter footer = new HeaderFooter(phraseFooter, true);
                        footer.setBorder(0);
                        footer.setAlignment(1);
                        document.setFooter(footer);
                        Phrase headerPhrase = new Phrase(sTitle);
                        headerPhrase.setFont(fontTimes);
                        HeaderFooter header = new HeaderFooter(phraseHeader, false);
                        header.setBorder(2);
                        header.setBorderWidth(0.5f);
                        header.setAlignment(0);
                        document.setHeader(header);
                        document.open();
                        if (onePage) {
                            int scale = 66;
                            itextImage.scalePercent((float)scale);
                            document.add((Element)itextImage);
                        } else {
                            BufferedImage[] imageChunks = ImageUtils.splitImageByHeigth(bimage, printHeigth);
                            int i = 0;
                            while (i < imageChunks.length) {
                                Image itextImage2 = Image.getInstance((java.awt.Image)Toolkit.getDefaultToolkit().createImage(imageChunks[i].getSource()), null);
                                float imgWidth = document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin();
                                float imgHeigth = itextImage.getHeight() * 0.75f;
                                itextImage2.setAbsolutePosition(30.0f, 20.0f);
                                int scale = 66;
                                itextImage2.scalePercent((float)scale);
                                document.add((Element)itextImage2);
                                document.newPage();
                                ++i;
                            }
                        }
                        document.close();
                    }
                    catch (Exception ex) {
                        CstResultPart.this.log.error(ex.getMessage());
                        CstResultPart.this.showMessage("Error while generating PDF", ex.getMessage());
                    }
                }
                finally {
                    if (image != null) {
                        image.dispose();
                    }
                    if (gc != null) {
                        gc.dispose();
                    }
                }
            }
        };
        this.actionPdf.setText(Messages.Cst_Text_Save_as_pdf);
        this.actionPdf.setToolTipText(Messages.Cst_Text_Save_as_pdf);
        this.actionPdf.setImageDescriptor(Activator.getImageDescriptor("icons/pdficon_large-32.png"));
    }

    protected double[] extractRefValues(LabItem labItem) {
        double[] result = new double[2];
        String sRangeStart = "0";
        if (this.patient.getGeschlecht().toLowerCase().equals("m")) {
            if (labItem.getRefM() != null) {
                sRangeStart = labItem.getRefM();
            } else if (labItem.getRefW() != null) {
                sRangeStart = labItem.getRefW();
            }
        } else if (labItem.getRefW() != null) {
            sRangeStart = labItem.getRefW();
        } else if (labItem.getRefM() != null) {
            sRangeStart = labItem.getRefM();
        }
        sRangeStart = sRangeStart.trim();
        double dRangeStart = 0.0;
        double dRangeEnd = 0.0;
        try {
            if (sRangeStart.startsWith("-")) {
                sRangeStart = sRangeStart.replace("-", "");
                dRangeEnd = Double.parseDouble(sRangeStart);
                dRangeStart = 0.0;
            } else if (sRangeStart.startsWith("<")) {
                sRangeStart = sRangeStart.replace("<", "");
                dRangeEnd = Double.parseDouble(sRangeStart);
                dRangeStart = 0.0;
            } else if (sRangeStart.startsWith(">")) {
                sRangeStart = sRangeStart.replace(">", "");
                dRangeStart = Double.parseDouble(sRangeStart);
                dRangeEnd = 0.0;
            } else if (sRangeStart.matches("\\d*")) {
                dRangeEnd = Double.parseDouble(sRangeStart);
                dRangeStart = 0.0;
            } else {
                String[] values = sRangeStart.split("-");
                dRangeStart = Double.parseDouble(values[0]);
                dRangeEnd = Double.parseDouble(values[1]);
            }
        }
        catch (NumberFormatException e) {
            this.log.error("NumberFormatException for start range of  Pat ID::" + labItem.getName() + ":" + "/" + sRangeStart + e.getMessage(), (Object)2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.error("ArrayIndexOutOfBoundsException for start range of " + labItem.getName() + ":" + "/" + sRangeStart + e.getMessage(), (Object)2);
        }
        this.log.debug("Formatting Reference Values of Labitem: " + labItem.getName() + ":\t" + sRangeStart + " => " + dRangeStart + "/" + dRangeEnd);
        result[0] = dRangeStart;
        result[1] = dRangeEnd;
        return result;
    }

    private void showMessage(String title, String msg) {
        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)title, (String)msg);
    }

    List<ValuePairTimeline> getValuesForValuePairTimeline(Patient pat, String parm, String fieldName, String separator) {
        ArrayList<ValuePairTimeline> resultList = new ArrayList<ValuePairTimeline>();
        String myparm = parm;
        if (pat != null) {
            Query qbe = new Query(Messwert.class);
            qbe.add("PatientID", "=", pat.getId());
            qbe.add("Name", "=", myparm);
            List list = qbe.execute();
            Collections.sort(list, new Comparator<Messwert>(){

                @Override
                public int compare(Messwert o1, Messwert o2) {
                    TimeTool t1 = new TimeTool(o1.get("Datum"));
                    TimeTool t2 = new TimeTool(o2.get("Datum"));
                    return t1.compareTo((Calendar)t2);
                }
            });
            StringBuffer result = new StringBuffer();
            for (Messwert m : list) {
                result.append(m.get("Datum"));
                result.append(m.toString());
                Map hash = m.getMap("Befunde");
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                Date date1 = null;
                DateFormat shortDf = DateFormat.getDateInstance(3);
                String da = new String();
                try {
                    date1 = formatter.parse(m.get("Datum"));
                    da = shortDf.format(date1);
                }
                catch (ParseException e) {
                    this.log.error(String.valueOf(e.toString()) + " " + m.get("Datum"));
                }
                Set keys = hash.keySet();
                for (Object key : keys) {
                    String diastol;
                    if (!fieldName.startsWith(key.toString())) continue;
                    String bd = hash.get(key).toString();
                    String[] sysdia = bd.split(separator);
                    if (sysdia.length < 2) {
                        sysdia[1] = hash.get(key).toString();
                    }
                    if ((diastol = sysdia[1]).contains(" ")) {
                        String[] korrD = diastol.split(" ");
                        sysdia[1] = korrD[0];
                    }
                    Double dSys = new Double(sysdia[0]);
                    Double dDia = new Double(sysdia[1]);
                    ValuePairTimeline bdValue = new ValuePairTimeline(CstService.getCompactFromDate(date1), dSys.intValue(), dDia.intValue());
                    resultList.add(bdValue);
                }
            }
        }
        return resultList;
    }

    List<ValueSingleTimeline> getValuesForSingleValueTimeline(Patient pat, String parm, String fieldName) {
        ArrayList<ValueSingleTimeline> resultList = new ArrayList<ValueSingleTimeline>();
        String myparm = parm;
        if (pat != null) {
            Query qbe = new Query(Messwert.class);
            qbe.add("PatientID", "=", pat.getId());
            qbe.add("Name", "=", myparm);
            List list = qbe.execute();
            Collections.sort(list, new Comparator<Messwert>(){

                @Override
                public int compare(Messwert o1, Messwert o2) {
                    TimeTool t1 = new TimeTool(o1.get("Datum"));
                    TimeTool t2 = new TimeTool(o2.get("Datum"));
                    return t1.compareTo((Calendar)t2);
                }
            });
            StringBuffer result = new StringBuffer();
            for (Messwert messwert : list) {
                result.append(messwert.get("Datum"));
                result.append(messwert.toString());
                Map hash = messwert.getMap("Befunde");
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                Date date1 = null;
                DateFormat shortDf = DateFormat.getDateInstance(3);
                String da = "";
                try {
                    date1 = formatter.parse(messwert.get("Datum"));
                    da = shortDf.format(date1);
                }
                catch (ParseException e) {
                    this.log.error(String.valueOf(e.toString()) + "/" + messwert.get("Datum"));
                }
                Set keys = hash.keySet();
                for (Object key : keys) {
                    if (!fieldName.startsWith(key.toString())) continue;
                    String bd = hash.get(key).toString();
                    String maxValue = CstService.getMaximumOfNumbersInString(bd);
                    ValueSingleTimeline wv = new ValueSingleTimeline(CstService.getCompactFromDate(date1), new Double(maxValue));
                    resultList.add(wv);
                }
            }
        }
        return resultList;
    }

    public void visible(boolean mode) {
    }

    public void setProfile(CstProfile profile) {
        this.profile = profile;
        this.patient = Patient.load((String)profile.getKontaktId());
        this.log.info("Result for patient: " + this.patient.getId() + "/" + this.patient.getName());
        this.layoutDisplay(profile);
    }

    public boolean isA4Quer() {
        return this.a4Quer;
    }

    public void setA4Quer(boolean a4Quer) {
        this.a4Quer = a4Quer;
    }

    class GroupSorter
    implements Comparator<CstGroup> {
        Map<String, Integer> itemRanking;

        public GroupSorter(Map<String, Integer> itemRanking) {
            this.itemRanking = itemRanking;
        }

        @Override
        public int compare(CstGroup o1, CstGroup o2) {
            Integer r1 = this.itemRanking.get(o1.getId());
            Integer r2 = this.itemRanking.get(o2.getId());
            if (r1 == null || r2 == null) {
                return 0;
            }
            return r1.compareTo(r2);
        }
    }

    class LabItemSorter
    implements Comparator<LabItemWrapper> {
        Map<String, Integer> itemRanking;

        public LabItemSorter(Map<String, Integer> itemRanking) {
            this.itemRanking = itemRanking;
        }

        @Override
        public int compare(LabItemWrapper o1, LabItemWrapper o2) {
            Integer r1 = this.itemRanking.get(o1.getLabItem().getId());
            Integer r2 = this.itemRanking.get(o2.getLabItem().getId());
            if (r1 == null || r2 == null) {
                return 0;
            }
            return r1.compareTo(r2);
        }
    }
}

