/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills.print;

import ch.elexis.core.utils.CoreUtil;
import ch.elexis.pdfBills.print.ScriptInitializer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintProcess {
    private static Logger logger = LoggerFactory.getLogger(PrintProcess.class);
    private static final String PATTERN_STRING = "\\[.*?\\]";
    private String command;
    private Pattern pattern;
    private HashMap<String, String> contextVariables;
    private static String[] variables = new String[]{"printer", "filename", "scriptdirectory", "tray"};

    public PrintProcess(String command) {
        this.command = command;
        this.contextVariables = new HashMap();
        this.pattern = Pattern.compile(PATTERN_STRING);
        this.contextVariables.put(variables[2], String.valueOf(ScriptInitializer.getOrCreateScriptFolder().getAbsolutePath()) + File.separator);
    }

    public boolean execute() {
        try {
            String preparedCommand = this.getPreparedCommand(this.command);
            if (CoreUtil.isWindows()) {
                preparedCommand = "cmd /C " + preparedCommand;
            }
            logger.info("Executing print command [" + preparedCommand + "]");
            Process process = Runtime.getRuntime().exec(preparedCommand);
            if (process.waitFor(30L, TimeUnit.SECONDS)) {
                return process.exitValue() == 0;
            }
            logger.error("Error executing print command [" + preparedCommand + "] process terminated.");
            process.destroy();
            return false;
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error executing print command", (Throwable)e);
            return false;
        }
    }

    private String getPreparedCommand(String command) {
        String preparedCommand = command;
        Matcher matcher = this.pattern.matcher(command);
        while (matcher.find()) {
            String replacement = this.contextVariables.get(preparedCommand.substring(matcher.start() + 1, matcher.end() - 1));
            if (replacement != null) {
                if (replacement.contains("\\")) {
                    replacement = replacement.replaceAll("\\\\", "\\\\\\\\");
                }
                preparedCommand = matcher.replaceFirst(replacement);
            } else {
                preparedCommand = matcher.replaceFirst("");
            }
            matcher = this.pattern.matcher(preparedCommand);
        }
        return preparedCommand;
    }

    public void setPrinter(String printer) {
        this.contextVariables.put(variables[0], printer);
    }

    public void setTray(String tray) {
        this.contextVariables.put(variables[3], tray);
    }

    public void setFilename(String filename) {
        this.contextVariables.put(variables[1], filename);
    }

    public static String getVariablesAsString() {
        StringJoiner sj = new StringJoiner(", ");
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            sj.add(variable);
            ++n2;
        }
        return sj.toString();
    }
}

