/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed45Exporter;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.PlatformHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Rechnung;
import ch.elexis.pdfBills.ElexisPDFGenerator;
import ch.elexis.pdfBills.OutputterUtil;
import ch.elexis.pdfBills.TarmedXmlUtil;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressService;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.LoggerFactory;

public class RnOutputter
implements IRnOutputter {
    public static final String PDFDIR = "pdfdir";
    public static final String PLUGIN_ID = "ch.elexis.pdfBills";
    public static final String XMLDIR = "xmldir";
    public static final String CFG_ROOT = "pdf-output/";
    public static final String CFG_MARGINLEFT = "margin.left";
    public static final String CFG_MARGINRIGHT = "margin.right";
    public static final String CFG_MARGINTOP = "margin.top";
    public static final String CFG_MARGINBOTTOM = "margin.bottom";
    public static final String CFG_BESR_MARGIN_VERTICAL = "margin.besr.vertical";
    public static final String CFG_BESR_MARGIN_HORIZONTAL = "margin.besr.horizontal";
    public static final String CFG_ESR_HEADER_1 = "pdf-output/esr.header.line1";
    public static final String CFG_ESR_HEADER_2 = "pdf-output/esr.header.line2";
    public static final String CFG_ESR_COUVERT_LEFT = "pdf-output/esr.couvert.left";
    public static final String CFG_PRINT_DIRECT = "pdf-output/print.direct";
    public static final String CFG_PRINT_PRINTER = "pdf-output/print.printer";
    public static final String CFG_PRINT_TRAY = "pdf-output/print.tray";
    public static final String CFG_ESR_PRINT_PRINTER = "pdf-output/esr.print.printer";
    public static final String CFG_ESR_PRINT_TRAY = "pdf-output/esr.print.tray";
    public static final String CFG_PRINT_COMMAND = "pdf-output/print.command";
    public static final String CFG_PRINT_USE_SCRIPT = "pdf-output/print.usescript";
    public static final String CFG_PRINT_BESR = "print.besr";
    public static final String CFG_PRINT_RF = "print.rf";
    protected static final String CFG_MAIL_CPY = "mail.copy";
    protected static final String CFG_MAIL_MANDANT_ACCOUNT = "mail.mandant.account";
    public static final String CFG_PRINT_USEGUARANTORPOSTAL = "pdf-output/guarantor.postaladdress";
    public static final String CFG_MSGTEXT_TP_M0 = "pdf-output/pdf.txt.tp";
    public static final String CFG_MSGTEXT_TG_M0 = "pdf-output/pdf.txt.tg";
    public static final String CFG_MSGTEXT_TP_M1 = "pdf-output/pdf.txt.M1tp";
    public static final String CFG_MSGTEXT_TP_M2 = "pdf-output/pdf.txt.M2tp";
    public static final String CFG_MSGTEXT_TP_M3 = "pdf-output/pdf.txt.M3tp";
    public static final String CFG_MSGTEXT_TG_M1 = "pdf-output/pdf.txt.M1tg";
    public static final String CFG_MSGTEXT_TG_M2 = "pdf-output/pdf.txt.M2tg";
    public static final String CFG_MSGTEXT_TG_M3 = "pdf-output/pdf.txt.M3tg";
    private Text tXml;
    private Text tPdf;
    private Button bWithEsr;
    private Button bWithRf;
    private boolean modifyInvoiceState;

    public String getDescription() {
        return "PDF Output";
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        if (!props.isEmpty()) {
            this.initSelectedFromProperties(props);
        } else {
            this.modifyInvoiceState = true;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        Result res = new Result();
        final File rsc = new File(PlatformHelper.getBasePath((String)PLUGIN_ID), "rsc");
        final StringJoiner mailErrors = new StringJoiner("\n- ", "- ", "");
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Exportiere Rechnungen...", rnn.size() * 10);
                    int errors = 0;
                    for (Rechnung rn : rnn) {
                        block13: {
                            IInvoice invoice = (IInvoice)CoreModelServiceHolder.get().load(rn.getId(), IInvoice.class).orElseThrow(() -> new IllegalStateException("Could not load invoice [" + rn.getId() + "]"));
                            XMLExporter ex = new XMLExporter();
                            ex.setEsrType(Tarmed45Exporter.EsrType.esr9);
                            Document dRn = ex.doExport(rn, null, type, true);
                            dRn = TarmedXmlUtil.setPrintAtIntermediate(dRn, false);
                            monitor.worked(1);
                            if (invoice.getState() == InvoiceState.DEFECTIVE) {
                                ++errors;
                                continue;
                            }
                            String fname = String.valueOf(OutputterUtil.getXmlOutputDir(RnOutputter.CFG_ROOT)) + File.separator + invoice.getNumber() + ".xml";
                            try {
                                OutputStream fout = VirtualFilesystemServiceHolder.get().of(fname).openOutputStream();
                                OutputStreamWriter cout = new OutputStreamWriter(fout, "UTF-8");
                                XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                                xout.output(dRn, (Writer)cout);
                                cout.close();
                                fout.close();
                                ElexisPDFGenerator epdf = new ElexisPDFGenerator(fname, invoice.getNumber(), invoice.getState());
                                epdf.printBill(rsc);
                                if (RnOutputter.this.modifyInvoiceState) {
                                    int status_vorher = invoice.getState().numericValue();
                                    if (status_vorher == InvoiceState.OPEN.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_1.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_2.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_3.numericValue()) {
                                        invoice.setState(InvoiceState.fromState((int)(status_vorher + 1)));
                                    }
                                    invoice.addTrace("Ausgegeben", String.valueOf(RnOutputter.this.getDescription()) + ": " + invoice.getState().getLocaleText());
                                    CoreModelServiceHolder.get().save((Identifiable)invoice);
                                }
                                if (!LocalConfigService.get((String)"pdf-output/mail.copy", (boolean)false) || !RnOutputter.this.shouldSendCopyMail(rn)) break block13;
                                Kontakt guarantor = RnOutputter.this.getGuarantor(rn);
                                if (guarantor != null && StringUtils.isNotBlank((CharSequence)guarantor.getMailAddress())) {
                                    String resultString;
                                    List<File> printed = epdf.getPrintedBill();
                                    if (!printed.isEmpty() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resultString = RnOutputter.this.sendAsMail(guarantor, rn, printed)})) {
                                        mailErrors.add(resultString);
                                    }
                                } else if (guarantor != null) {
                                    mailErrors.add("Keine mail Addresse f\u00fcr " + guarantor.getLabel(false));
                                } else {
                                    mailErrors.add("Keine Garant f\u00fcr Rechnung " + invoice.getNumber());
                                }
                            }
                            catch (Exception e1) {
                                ExHandler.handle((Throwable)e1);
                                SWTHelper.showError((String)"Fehler beim Rechnungsdruck", (String)("Konnte Datei " + fname + " nicht schreiben"));
                                invoice.reject(InvoiceState.REJECTCODE.INTERNAL_ERROR, "write error: " + fname);
                                CoreModelServiceHolder.get().save((Identifiable)invoice);
                                continue;
                            }
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                    if (errors > 0) {
                        SWTHelper.alert((String)"Fehler bei der \u00dcbermittlung", (String)(String.valueOf(Integer.toString(errors)) + " Rechnungen waren fehlerhaft. Sie k\u00f6nnen diese unter Rechnungen mit dem Status fehlerhaft aufsuchen und korrigieren"));
                    } else {
                        SWTHelper.showInfo((String)"\u00dcbermittlung beendet", (String)"Es sind keine Fehler aufgetreten");
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            if (StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
            } else if (ex.getCause() != null && StringUtils.isNotBlank((CharSequence)ex.getCause().getMessage())) {
                res.add(Result.SEVERITY.ERROR, 2, ex.getCause().getMessage(), null, true);
            }
            ErrorDialog.openError(null, (String)"Fehler bei der Ausgabe", (String)"Konnte Rechnungsdruck nicht starten", (IStatus)ResultAdapter.getResultAsStatus((Result)res));
            return res;
        }
        if (mailErrors.length() > 2) {
            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Fehler beim Mail-Versand", null, "Beim Mail-Versand sind folgende Fehler aufgetreten:\n" + mailErrors.toString(), 1, 0, new String[]{IDialogConstants.OK_LABEL, "als Text \u00f6ffnen"}){

                protected void buttonPressed(int buttonId) {
                    if (buttonId == 1) {
                        try {
                            Path tmpFile = Files.createTempFile("error_", "rechnung.txt", new FileAttribute[0]);
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (FileWriter fo = new FileWriter(tmpFile.toFile());){
                                fo.write(mailErrors.toString());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            Program.launch((String)tmpFile.toString());
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error writing tmp file", (Throwable)e);
                        }
                    }
                    super.buttonPressed(buttonId);
                }
            };
            dialog.open();
        }
        return res;
    }

    private void initSelectedFromProperties(Properties props) {
        String value;
        LoggerFactory.getLogger(this.getClass()).warn("Initializing with properties " + props.toString());
        this.modifyInvoiceState = true;
        if (props.get("OutputModifyInvoiceState") instanceof String) {
            value = (String)props.get("OutputModifyInvoiceState");
            this.modifyInvoiceState = Boolean.parseBoolean(value);
        }
        if (props.get("OutputWithEsr") instanceof String) {
            value = (String)props.get("OutputWithEsr");
            LocalConfigService.set((String)"pdf-output/print.besr", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputWithReclaim") instanceof String) {
            value = (String)props.get("OutputWithReclaim");
            LocalConfigService.set((String)"pdf-output/print.rf", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputWithMail") instanceof String) {
            value = (String)props.get("OutputWithMail");
            LocalConfigService.set((String)"pdf-output/mail.copy", (boolean)Boolean.parseBoolean(value));
        }
    }

    private Kontakt getGuarantor(Rechnung rn) {
        IContact ret;
        IPatient patient;
        ICoverage coverage = CoreModelServiceHolder.get().load(rn.getFall().getId(), ICoverage.class).orElse(null);
        if (coverage != null && (patient = (IPatient)CoreModelServiceHolder.get().load(rn.getFall().getPatient().getId(), IPatient.class).orElse(null)) != null && (ret = XMLExporterUtil.getGuarantor((String)"TP", (IPatient)patient, (ICoverage)coverage)) != null) {
            return Kontakt.load((String)ret.getId());
        }
        return null;
    }

    private boolean shouldSendCopyMail(Rechnung rn) {
        Kontakt guarantor = this.getGuarantor(rn);
        if (guarantor != null) {
            Fall fall = rn.getFall();
            return !fall.getInvoiceRecipient().equals((Object)guarantor);
        }
        return false;
    }

    private String sendAsMail(Kontakt receiver, Rechnung rechnung, List<File> printed) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        try {
            String attachmentsString = this.getAttachmentsString(printed);
            Command sendMailCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMailNoUi");
            HashMap<String, String> params = new HashMap<String, String>();
            String accountid = ConfigServiceHolder.getGlobal((String)("pdf-output/mail.mandant.account/" + rechnung.getMandant().getId()), null);
            if (accountid != null) {
                params.put("ch.elexis.core.mail.ui.sendMailNoUi.accountid", accountid);
            }
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.mandant", rechnung.getMandant().getId());
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.to", receiver.getMailAddress());
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.attachments", attachmentsString);
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.subject", "Rechnungskopie vom " + rechnung.getDatumRn());
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.text", "Anbei finden Sie eine Kopie der Rechnung vom " + rechnung.getDatumRn() + " f\u00fcr Ihre Unterlagen.\n\nBeste Gr\u00fcsse\n" + rechnung.getMandant().get("Titel") + " " + rechnung.getMandant().getVorname() + " " + rechnung.getMandant().getName());
            ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
            return (String)((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
        }
        catch (Exception me) {
            throw new RuntimeException("ch.elexis.core.mail.ui.sendMailNoUi not found", me);
        }
    }

    private String getAttachmentsString(List<File> attachments) {
        StringBuilder sb = new StringBuilder();
        for (File file : attachments) {
            if (sb.length() > 0) {
                sb.append(":::");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public boolean canBill(Fall fall) {
        return true;
    }

    public Object createSettingsControl(Object parent) {
        final Composite compParent = (Composite)parent;
        Composite ret = new Composite(compParent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData());
        ret.setLayout((Layout)new GridLayout(2, false));
        this.bWithEsr = new Button(ret, 32);
        this.bWithEsr.setText("Mit Einzahlungsschein");
        this.bWithEsr.setSelection(LocalConfigService.get((String)"pdf-output/print.besr", (boolean)true));
        this.bWithEsr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalConfigService.set((String)"pdf-output/print.besr", (boolean)RnOutputter.this.bWithEsr.getSelection());
            }
        });
        this.bWithEsr.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bWithRf = new Button(ret, 32);
        this.bWithRf.setText("Mit Rechnungsformular");
        this.bWithRf.setSelection(LocalConfigService.get((String)"pdf-output/print.rf", (boolean)true));
        this.bWithRf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalConfigService.set((String)"pdf-output/print.rf", (boolean)RnOutputter.this.bWithRf.getSelection());
            }
        });
        this.bWithRf.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        LocalConfigService.set((String)"pdf-output/mail.copy", (boolean)false);
        if (OutputterUtil.useGlobalOutputDirs()) {
            Label lXML = new Label(ret, 0);
            lXML.setText("XML Verzeichnis: " + PreferencesUtil.getOsSpecificPreference((String)"pdf-outputter/global.output.xmldir", (IConfigService)ConfigServiceHolder.get()));
            lXML.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            Label lPDF = new Label(ret, 0);
            lPDF.setText("PDF Verzeichnis: " + PreferencesUtil.getOsSpecificPreference((String)"pdf-outputter/global.output.pdfdir", (IConfigService)ConfigServiceHolder.get()));
            lPDF.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        } else {
            Button bXML = new Button(ret, 8);
            bXML.setText("XML Verzeichnis");
            this.tXml = new Text(ret, 2056);
            this.tXml.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Button bPDF = new Button(ret, 8);
            bPDF.setText("PDF Verzeichnis");
            this.tPdf = new Text(ret, 2056);
            this.tPdf.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            bXML.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dd = new DirectoryDialog(compParent.getShell());
                    String dir = dd.open();
                    if (dir != null) {
                        RnOutputter.this.tXml.setText(dir);
                    }
                }
            });
            bPDF.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dd = new DirectoryDialog(compParent.getShell());
                    String dir = dd.open();
                    if (dir != null) {
                        RnOutputter.this.tPdf.setText(dir);
                    }
                }
            });
            this.tXml.setText(LocalConfigService.get((String)"pdf-output/xmldir", (String)""));
            this.tPdf.setText(LocalConfigService.get((String)"pdf-output/pdfdir", (String)""));
        }
        return ret;
    }

    public void saveComposite() {
        LocalConfigService.set((String)"pdf-output/print.besr", (boolean)this.bWithEsr.getSelection());
        LocalConfigService.set((String)"pdf-output/print.rf", (boolean)this.bWithRf.getSelection());
        if (!OutputterUtil.useGlobalOutputDirs()) {
            LocalConfigService.set((String)"pdf-output/xmldir", (String)this.tXml.getText());
            LocalConfigService.set((String)"pdf-output/pdfdir", (String)this.tPdf.getText());
        }
        LocalConfigService.flush();
    }

    public void openOutput(IInvoice invoice, LocalDateTime timestamp, InvoiceState invoiceState) {
        try {
            File esrFile = VirtualFilesystemServiceHolder.get().of(String.valueOf(OutputterUtil.getPdfOutputDir(CFG_ROOT)) + File.separator + invoice.getNumber() + "_esr.pdf").toFile().orElse(null);
            File rfFile = VirtualFilesystemServiceHolder.get().of(String.valueOf(OutputterUtil.getPdfOutputDir(CFG_ROOT)) + File.separator + invoice.getNumber() + "_rf.pdf").toFile().orElse(null);
            if (esrFile.exists()) {
                Program.launch((String)esrFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + esrFile.getAbsolutePath() + "] does not exist");
            }
            if (rfFile.exists()) {
                Program.launch((String)rfFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + rfFile.getAbsolutePath() + "] does not exist");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

