/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import org.apache.commons.lang3.StringUtils;

public class OutputterUtil {
    public static final String CFG_ROOT = "pdf-outputter/";
    public static final String CFG_PRINT_GLOBALOUTPUTDIRS = "pdf-outputter/global.output.dirs";
    public static final String CFG_PRINT_GLOBALPDFDIR = "pdf-outputter/global.output.pdfdir";
    public static final String CFG_PRINT_GLOBALXMLDIR = "pdf-outputter/global.output.xmldir";

    public static boolean useGlobalOutputDirs() {
        return OutputterUtil.hasGlobalDirectories() && CoreHub.localCfg.get(CFG_PRINT_GLOBALOUTPUTDIRS, true);
    }

    private static boolean hasGlobalDirectories() {
        return StringUtils.isNotBlank((CharSequence)PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALPDFDIR, (IConfigService)ConfigServiceHolder.get())) && StringUtils.isNotBlank((CharSequence)PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALXMLDIR, (IConfigService)ConfigServiceHolder.get()));
    }

    public static String getXmlOutputDir(String configRoot) {
        if (OutputterUtil.useGlobalOutputDirs()) {
            return PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALXMLDIR, (IConfigService)ConfigServiceHolder.get());
        }
        return CoreHub.localCfg.get(String.valueOf(configRoot) + "xmldir", "");
    }

    public static String getPdfOutputDir(String configRoot) {
        if (OutputterUtil.useGlobalOutputDirs()) {
            return PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALPDFDIR, (IConfigService)ConfigServiceHolder.get());
        }
        return CoreHub.localCfg.get(String.valueOf(configRoot) + "pdfdir", "");
    }
}

