/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.model.util;

import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.TransientCategory;
import ch.elexis.omnivore.model.service.OmnivoreModelServiceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class CategoryUtil {
    public static void addCategory(String name) {
        if (CategoryUtil.findCategoriesByName(name).isEmpty()) {
            IDocumentHandle docHandle = (IDocumentHandle)OmnivoreModelServiceHolder.get().create(IDocumentHandle.class);
            docHandle.setTitle(name);
            docHandle.setCategory(new TransientCategory(name));
            docHandle.setMimeType("text/category");
            OmnivoreModelServiceHolder.get().save((Identifiable)docHandle);
        }
    }

    public static List<ICategory> findCategoriesByName(String name) {
        List<IDocumentHandle> docs = CategoryUtil.getCategoriesByName(name);
        ArrayList<ICategory> iCategories = new ArrayList<ICategory>();
        for (IDocumentHandle docHandle : docs) {
            iCategories.add(docHandle.getCategory());
        }
        return iCategories;
    }

    public static List<IDocumentHandle> getCategoriesByName(String name) {
        IQuery query = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
        query.and("category", IQuery.COMPARATOR.EQUALS, (Object)name, true);
        query.and("mimetype", IQuery.COMPARATOR.EQUALS, (Object)"text/category");
        return query.execute();
    }

    public static List<String> getCategoriesNames() {
        INamedQuery findCategoriesQuery = OmnivoreModelServiceHolder.get().getNamedQueryByName(String.class, IDocumentHandle.class, "DocHandle.select.category.names");
        List result = findCategoriesQuery.executeWithParameters(Collections.emptyMap());
        return result;
    }

    public static ICategory getDefaultCategory() {
        IDocumentHandle existing = CategoryUtil.findDefaultCategory();
        if (existing == null) {
            CategoryUtil.addCategory("default");
            existing = CategoryUtil.findDefaultCategory();
        }
        return existing.getCategory();
    }

    private static IDocumentHandle findDefaultCategory() {
        IQuery query = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
        query.and("mimetype", IQuery.COMPARATOR.EQUALS, (Object)"text/category");
        query.and("category", IQuery.COMPARATOR.EQUALS, (Object)"default");
        List existing = query.execute();
        return existing.isEmpty() ? null : (IDocumentHandle)existing.get(0);
    }

    public static List<IDocumentHandle> getCategories() {
        INamedQuery findCategoriesQuery = OmnivoreModelServiceHolder.get().getNamedQueryByName(IDocumentHandle.class, IDocumentHandle.class, "DocHandle.select.categories");
        TreeMap uniqueMap = new TreeMap();
        findCategoriesQuery.executeWithParameters(Collections.emptyMap()).forEach(dh -> {
            if (uniqueMap.containsKey(dh.getTitle())) {
                if (StringUtils.isNotBlank((CharSequence)dh.getCategory().getName())) {
                    uniqueMap.put(dh.getTitle(), dh);
                }
            } else {
                uniqueMap.put(dh.getTitle(), dh);
            }
        });
        return new ArrayList<IDocumentHandle>(uniqueMap.values());
    }

    public static List<IDocumentHandle> getDocumentsWithCategoryByName(String name) {
        IQuery query = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
        query.and("mimetype", IQuery.COMPARATOR.NOT_EQUALS, (Object)"text/category");
        query.and("category", IQuery.COMPARATOR.EQUALS, (Object)name, true);
        return query.execute();
    }

    public static void renameCategory(String oldName, String newName) {
        String oldname = oldName.trim();
        String newname = newName.trim();
        if (!CategoryUtil.findCategoriesByName(newname).isEmpty()) {
            throw new IllegalStateException("Category [" + newname + "] already exists");
        }
        OmnivoreModelServiceHolder.get().executeNativeUpdate("UPDATE CH_ELEXIS_OMNIVORE_DATA SET category='" + newname + "' WHERE category='" + oldname + "'");
        OmnivoreModelServiceHolder.get().executeNativeUpdate("UPDATE CH_ELEXIS_OMNIVORE_DATA SET title='" + newname + "' WHERE title='" + oldname + "' AND mimetype='" + "text/category" + "'");
        LoggerFactory.getLogger(CategoryUtil.class).info("Renaming category [" + oldname + "], moving entries to category [" + newname + "]");
    }

    public static void removeCategory(String name, String destName) {
        OmnivoreModelServiceHolder.get().executeNativeUpdate("UPDATE CH_ELEXIS_OMNIVORE_DATA SET category='" + destName + "' WHERE category='" + name + "'");
        OmnivoreModelServiceHolder.get().executeNativeUpdate("UPDATE CH_ELEXIS_OMNIVORE_DATA SET deleted='1' WHERE title='" + name + "' AND mimetype='" + "text/category" + "'");
        LoggerFactory.getLogger(CategoryUtil.class).info("Removing category [" + name + "], moving entries to category [" + destName + "]");
    }

    public static void ensureCategoryAvailability(String category) {
        List<ICategory> existing = CategoryUtil.findCategoriesByName(category);
        if (existing.isEmpty()) {
            CategoryUtil.addCategory(category);
        }
    }
}

