/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.model.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.MimeTool;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ModelUtil {
    private static IModelService modelService;

    @Reference(target="(service.model.name=ch.elexis.core.model)")
    public void setModelService(IModelService modelService) {
        ModelUtil.modelService = modelService;
    }

    public static String evaluateFileExtension(String input) {
        String ext = MimeTool.getExtension((String)input);
        if (StringUtils.isEmpty((CharSequence)ext) && StringUtils.isEmpty((CharSequence)(ext = FilenameUtils.getExtension((String)input)))) {
            ext = input;
        }
        return ext;
    }

    public static <T> T loadCoreModel(EntityWithId entity, Class<T> clazz) {
        if (entity != null) {
            return modelService.load(entity.getId(), clazz).orElse(null);
        }
        return null;
    }
}

