/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views2;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.molemax.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MolemaxImagePrefs
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private List<Control> controlledWidgets = new ArrayList<Control>();
    public static final String CUSTOM_BASEDIR = "molemax/custom_imagebase";
    public static final String BASEDIR = "molemax/imagebase";
    private StringFieldEditor customBaseDirEditor;
    private Text dateFormatText;
    private Text timeFormatText;
    private String selectedSeparator = "_";
    private String selectedDateFormat = "yyyyMMdd";
    private String selectedTimeFormat = "hhmmss";
    private Spinner nameSpinner;
    private Spinner firstNameSpinner;
    private Button slashButton;
    private Button underLineButton;
    private Button clearButton;
    private Button patNumButton;
    private Button nameButton;
    private Button firstNameButton;
    private Button timeButton;
    private Button slotButton;
    private Button dateButton;

    public MolemaxImagePrefs() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new DirectoryFieldEditor(BASEDIR, Messages.MolemaxPrefs_basedir, this.getFieldEditorParent()));
        this.customBaseDirEditor = new StringFieldEditor(CUSTOM_BASEDIR, "Patienten Ordner Struktur", this.getFieldEditorParent());
        this.addField((FieldEditor)this.customBaseDirEditor);
        this.customBaseDirEditor.setStringValue(this.generateCustomBaseDir());
        Composite separatorButtonContainer = new Composite(this.getFieldEditorParent(), 0);
        separatorButtonContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        separatorButtonContainer.setLayout((Layout)new GridLayout(3, false));
        this.slashButton = new Button(separatorButtonContainer, 8);
        this.slashButton.setText("/");
        this.slashButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.selectedSeparator = "/";
            }
        });
        this.underLineButton = new Button(separatorButtonContainer, 8);
        this.underLineButton.setText("_");
        this.underLineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.selectedSeparator = "_";
            }
        });
        this.clearButton = new Button(separatorButtonContainer, 8);
        this.clearButton.setText("Clear");
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.customBaseDirEditor.setStringValue("");
            }
        });
        Composite buttonContainer = new Composite(this.getFieldEditorParent(), 0);
        buttonContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        buttonContainer.setLayout((Layout)new GridLayout(8, false));
        this.patNumButton = new Button(buttonContainer, 8);
        this.patNumButton.setText("Patienten Num.");
        this.patNumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.appendToGeneratedStructure("PatNum");
            }
        });
        Composite nameComposite = new Composite(buttonContainer, 0);
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        this.nameButton = new Button(nameComposite, 8);
        this.nameButton.setText("Name");
        this.nameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.appendToGeneratedStructure("Name", MolemaxImagePrefs.this.nameSpinner.getSelection());
            }
        });
        this.nameSpinner = new Spinner(nameComposite, 2048);
        this.nameSpinner.setMinimum(0);
        this.nameSpinner.setMaximum(10);
        this.nameSpinner.setSelection(0);
        Composite firstNameComposite = new Composite(buttonContainer, 0);
        firstNameComposite.setLayout((Layout)new GridLayout(2, false));
        this.firstNameButton = new Button(firstNameComposite, 8);
        this.firstNameButton.setText("Vorname");
        this.firstNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.appendToGeneratedStructure("Vorname", MolemaxImagePrefs.this.firstNameSpinner.getSelection());
            }
        });
        this.firstNameSpinner = new Spinner(firstNameComposite, 2048);
        this.firstNameSpinner.setMinimum(0);
        this.firstNameSpinner.setMaximum(10);
        this.firstNameSpinner.setSelection(0);
        this.timeButton = new Button(buttonContainer, 8);
        this.timeButton.setText("Uhrzeit");
        this.controlledWidgets.add((Control)this.timeButton);
        this.timeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.appendToGeneratedStructure("Uhrzeit-" + MolemaxImagePrefs.this.selectedTimeFormat);
            }
        });
        this.timeFormatText = new Text(buttonContainer, 2048);
        this.timeFormatText.setText(this.selectedDateFormat);
        this.timeFormatText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeFormatText.addModifyListener(e -> {
            String string = this.selectedTimeFormat = this.timeFormatText.getText();
        });
        this.dateButton = new Button(buttonContainer, 8);
        this.dateButton.setText("Datum");
        this.dateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.appendToGeneratedStructure("Datum-" + MolemaxImagePrefs.this.selectedDateFormat);
            }
        });
        this.dateFormatText = new Text(buttonContainer, 2048);
        this.dateFormatText.setText(this.selectedDateFormat);
        this.dateFormatText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dateFormatText.addModifyListener(e -> {
            String string = this.selectedDateFormat = this.dateFormatText.getText();
        });
        this.slotButton = new Button(buttonContainer, 8);
        this.slotButton.setText("Slot");
        this.slotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MolemaxImagePrefs.this.appendToGeneratedStructure("Slot");
            }
        });
    }

    private void appendToGeneratedStructure(String component) {
        this.appendToGeneratedStructure(component, 0);
    }

    private void appendToGeneratedStructure(String component, int charCount) {
        String currentText = this.customBaseDirEditor.getStringValue();
        if (charCount > 0 && (component.equals("Name") || component.equals("Vorname"))) {
            component = String.valueOf(component) + "-" + charCount;
        }
        if (!currentText.isEmpty()) {
            currentText = String.valueOf(currentText) + this.selectedSeparator;
        }
        this.customBaseDirEditor.setStringValue(String.valueOf(currentText) + component);
    }

    private String generateCustomBaseDir() {
        String customPath = this.getPreferenceStore().getString(CUSTOM_BASEDIR);
        return customPath;
    }

    public void init(IWorkbench workbench) {
    }
}

