/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views2;

import ch.elexis.data.Patient;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.data.Tracker;
import ch.elexis.molemax.handler.ThumbnailHandler;
import ch.elexis.molemax.views2.HoverListener;
import ch.elexis.molemax.views2.ImageOverview;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.nebula.animation.effects.MoveScrollBarEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.nebula.animation.movement.LinearInOut;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class ImageViewAll {
    private ImageOverview overviewInstance;
    private List<Image> createdImages = new ArrayList<Image>();
    private Patient aktuellerPatient;
    private static final int AUTO_SCROLL_MARGIN = 40;
    private static final int AUTO_SCROLL_SPEED = 75;
    private String groupName = null;
    private Gallery gallery;
    private GalleryItem lastClickedGroupItem = null;

    public void setOverviewInstance(ImageOverview overview) {
        this.overviewInstance = overview;
    }

    public ImageViewAll(Composite parent) {
        this.gallery = new Gallery(parent, 0x10000202);
        this.gallery.setLayoutData((Object)new GridData(1808));
        new HoverListener(this.gallery, Display.getCurrent().getSystemColor(1), Display.getCurrent().getSystemColor(15), 500, 500);
        DefaultGalleryGroupRenderer gr = new DefaultGalleryGroupRenderer();
        gr.setItemHeight(250);
        gr.setItemWidth(250);
        gr.setAutoMargin(true);
        gr.setAnimation(true);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        DefaultGalleryItemRenderer ir = new DefaultGalleryItemRenderer();
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        DragSource source = new DragSource((Control)this.gallery, 3);
        source.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                Point mouseCoords = Display.getCurrent().getCursorLocation();
                GalleryItem itemUnderMouse = ImageViewAll.this.gallery.getItem(mouseCoords = ImageViewAll.this.gallery.toControl(mouseCoords));
                if (itemUnderMouse == null) {
                    event.doit = false;
                    return;
                }
                GalleryItem[] allItems = ImageViewAll.this.gallery.getItems();
                if (allItems == null || allItems.length == 0) {
                    event.doit = false;
                    return;
                }
                GalleryItem[] selection = ImageViewAll.this.gallery.getSelection();
                if (selection.length > 0) {
                    File imgFile = new File((String)selection[0].getData(), selection[0].getText());
                    event.data = new String[]{imgFile.getAbsolutePath()};
                }
            }

            public void dragSetData(DragSourceEvent event) {
                GalleryItem[] selection = ImageViewAll.this.gallery.getSelection();
                if (selection.length > 0) {
                    File imgFile = new File((String)selection[0].getData(), selection[0].getText());
                    event.data = new String[]{imgFile.getAbsolutePath()};
                }
            }

            public void dragFinished(DragSourceEvent event) {
                Image img;
                GalleryItem[] selection;
                if (event.detail == 2 && (selection = ImageViewAll.this.gallery.getSelection()).length > 0 && (img = selection[0].getImage()) != null && !img.isDisposed()) {
                    img.dispose();
                    ImageViewAll.this.createdImages.remove(img);
                }
            }
        });
        this.gallery.addListener(8, event -> {
            GalleryItem[] selection;
            if (this.overviewInstance != null && (selection = this.gallery.getSelection()).length > 0) {
                String folderPath = (String)selection[0].getData();
                String thumbnailImagePath = String.valueOf(folderPath) + File.separator + selection[0].getText();
                File originalImageFile = new File(thumbnailImagePath);
                if (originalImageFile.exists()) {
                    Image originalImage = new Image((Device)Display.getDefault(), originalImageFile.getAbsolutePath());
                    this.overviewInstance.showFullImage(originalImage, folderPath, originalImageFile.getAbsolutePath(), thumbnailImagePath);
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Expected path to original image not found: " + originalImageFile.getAbsolutePath());
                }
            }
        });
        this.gallery.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block14: {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        GalleryItem[] selection;
                        if (ImageViewAll.this.overviewInstance != null && (selection = ImageViewAll.this.gallery.getSelection()) != null && selection.length > 0) {
                            String folderPath = (String)selection[0].getData();
                            String thumbnailImagePath = String.valueOf(folderPath) + File.separator + selection[0].getText();
                            File originalImageFile = new File(thumbnailImagePath);
                            if (originalImageFile.exists()) {
                                Image originalImage = null;
                                try {
                                    originalImage = new Image((Device)Display.getDefault(), originalImageFile.getAbsolutePath());
                                    ImageViewAll.this.overviewInstance.showFullImage(originalImage, folderPath, originalImageFile.getAbsolutePath(), thumbnailImagePath);
                                }
                                catch (SWTException swtEx) {
                                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Error loading the image: " + swtEx.getMessage());
                                    if (originalImage == null || originalImage.isDisposed()) break block14;
                                    originalImage.dispose();
                                }
                            } else {
                                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Expected path to original image not found: " + originalImageFile.getAbsolutePath());
                            }
                        }
                    } else if (e.keyCode == 27) {
                        if (ImageViewAll.this.aktuellerPatient != null) {
                            ImageViewAll.this.updateGalleryForPatient(ImageViewAll.this.aktuellerPatient);
                        }
                    } else if (e.keyCode == 127) {
                        boolean confirm;
                        GalleryItem[] selection = ImageViewAll.this.gallery.getSelection();
                        if (selection == null || selection.length == 0) {
                            return;
                        }
                        if (selection.length > 0 && (confirm = MessageDialog.openConfirm((Shell)ImageViewAll.this.gallery.getShell(), (String)Messages.ImageSlot_imageDel, (String)(selection.length > 1 ? String.valueOf(Messages.ImageSlot_these) + selection.length + " " + Messages.ImageSlot_imagesdelete : Messages.ImageSlot_reallydelete)))) {
                            GalleryItem[] galleryItemArray = selection;
                            int n = selection.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GalleryItem selectedItem = galleryItemArray[n2];
                                ImageViewAll.this.deleteSelectedItem(selectedItem);
                                ++n2;
                            }
                        }
                    }
                }
            }
        });
        final Menu contextMenu = new Menu((Control)this.gallery);
        MenuItem deleteItem = new MenuItem(contextMenu, 0);
        deleteItem.setText(Messages.ImageSlot_delete);
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean confirm;
                GalleryItem[] selection = ImageViewAll.this.gallery.getSelection();
                if (selection.length > 0 && (confirm = MessageDialog.openConfirm((Shell)ImageViewAll.this.gallery.getShell(), (String)Messages.ImageSlot_imageDel, (String)(selection.length > 1 ? String.valueOf(Messages.ImageSlot_these) + selection.length + " " + Messages.ImageSlot_imagesdelete : Messages.ImageSlot_reallydelete)))) {
                    GalleryItem[] galleryItemArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GalleryItem selectedItem = galleryItemArray[n2];
                        ImageViewAll.this.deleteSelectedItem(selectedItem);
                        ++n2;
                    }
                }
            }
        });
        this.gallery.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    GalleryItem clickedGroupItem = null;
                    GalleryItem[] galleryItemArray = ImageViewAll.this.gallery.getItems();
                    int n = galleryItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GalleryItem item = galleryItemArray[n2];
                        if (item.getBounds().contains(new Point(e.x, e.y))) {
                            clickedGroupItem = item;
                            break;
                        }
                        ++n2;
                    }
                    if (clickedGroupItem != null && clickedGroupItem.getParentItem() == null) {
                        ImageViewAll.this.lastClickedGroupItem = clickedGroupItem;
                        ImageViewAll.this.gallery.setMenu(contextMenu);
                    } else {
                        ImageViewAll.this.gallery.setMenu(null);
                    }
                }
            }
        });
        MenuItem renameItem = new MenuItem(contextMenu, 0);
        renameItem.setText(Messages.BriefAuswahlRenameButtonText);
        renameItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImageViewAll.this.lastClickedGroupItem != null) {
                    String newName;
                    String currentName = ImageViewAll.this.lastClickedGroupItem.getText();
                    InputDialog renameDialog = new InputDialog(ImageViewAll.this.gallery.getShell(), Messages.BefundePrefs_enterRenameCaption, Messages.Rename_Group_Text, currentName, null);
                    if (renameDialog.open() == 0 && (newName = renameDialog.getValue()) != null && !newName.trim().isEmpty() && !newName.equals(currentName)) {
                        boolean success = ImageViewAll.this.renameGroupDirectory(currentName, newName);
                        if (success) {
                            ImageViewAll.this.lastClickedGroupItem.setText(newName);
                            ImageViewAll.this.updateGalleryForPatient(ImageViewAll.this.aktuellerPatient);
                        } else {
                            MessageDialog.openError((Shell)ImageViewAll.this.gallery.getShell(), (String)Messages.Core_Error, (String)Messages.Rename_Folder_Error);
                        }
                    }
                }
            }
        });
        this.gallery.setMenu(contextMenu);
        DropTarget target = new DropTarget((Control)this.gallery, 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) != 0 ? 2 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                Point mouseCoords = Display.getCurrent().getCursorLocation();
                mouseCoords = ImageViewAll.this.gallery.toControl(mouseCoords);
                ScrollBar verticalScrollBar = ImageViewAll.this.gallery.getVerticalBar();
                int scrollPosition = verticalScrollBar.getSelection();
                if (mouseCoords.y < 40) {
                    int newScrollPosition = scrollPosition - 75;
                    ImageViewAll.this.animateScrollBar(verticalScrollBar, scrollPosition, newScrollPosition);
                } else if (mouseCoords.y > ImageViewAll.this.gallery.getBounds().height - 40) {
                    int newScrollPosition = scrollPosition + 75;
                    ImageViewAll.this.animateScrollBar(verticalScrollBar, scrollPosition, newScrollPosition);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                block24: {
                    block23: {
                        DropTarget dropTarget = (DropTarget)event.widget;
                        Control control = dropTarget.getControl();
                        Point coords = control.toControl(new Point(event.x, event.y));
                        ImageViewAll.this.groupName = null;
                        GalleryItem[] galleryItemArray = ImageViewAll.this.gallery.getItems();
                        int n = galleryItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            GalleryItem group = galleryItemArray[n2];
                            if (group.getBounds().contains(coords)) {
                                ImageViewAll.this.groupName = group.getText();
                                break;
                            }
                            ++n2;
                        }
                        if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) break block23;
                        if (!(event.data instanceof String[])) break block24;
                        String[] files = (String[])event.data;
                        GalleryItem lastAddedItem = null;
                        String[] stringArray = files;
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            block22: {
                                String file = stringArray[n4];
                                Image image = null;
                                try {
                                    String targetPath;
                                    block26: {
                                        File targetFile;
                                        block25: {
                                            File targetDir;
                                            image = new Image((Device)Display.getDefault(), file);
                                            Path filePath = Paths.get(file, new String[0]);
                                            BasicFileAttributes attrs = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                                            LocalDate fileModifiedDate = LocalDate.ofInstant(attrs.lastModifiedTime().toInstant(), ZoneId.systemDefault());
                                            LocalDate today = LocalDate.now();
                                            if (ImageViewAll.this.groupName == null) {
                                                ImageViewAll.this.groupName = fileModifiedDate.equals(today) ? today.format(DateTimeFormatter.ofPattern("yyyyMMdd")) : fileModifiedDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                                            }
                                            if (!(targetDir = new File(targetPath = String.valueOf(Tracker.makeDescriptorImage(ImageViewAll.this.aktuellerPatient)) + File.separator + ImageViewAll.this.groupName)).exists()) {
                                                targetDir.mkdirs();
                                            }
                                            if (!(targetFile = new File(targetPath, new File(file).getName())).exists()) break block25;
                                            CustomFileDialog dialog = new CustomFileDialog(ImageViewAll.this.gallery.getShell());
                                            int result = dialog.open();
                                            switch (result) {
                                                case 0: {
                                                    try {
                                                        ImageViewAll.this.copyFile(new File(file), targetFile);
                                                        File thumbnailDirectory = new File(targetFile.getParent(), "thumbnails");
                                                        if (!thumbnailDirectory.exists()) {
                                                            thumbnailDirectory.mkdirs();
                                                        }
                                                        File thumbnailFile = new File(thumbnailDirectory, targetFile.getName());
                                                        ImageViewAll.this.createOrUpdateThumbnail(targetFile, thumbnailFile);
                                                        ImageViewAll.this.updateThumbnailInUI(thumbnailFile);
                                                    }
                                                    catch (IOException e) {
                                                        LoggerFactory.getLogger(this.getClass()).warn("File no copy ", (Throwable)e);
                                                    }
                                                    break block26;
                                                }
                                                case 1: {
                                                    String newName;
                                                    InputDialog renameDialog = new InputDialog(ImageViewAll.this.gallery.getShell(), "Neuen Dateinamen eingeben", "Bitte geben Sie den neuen Dateinamen ein:", targetFile.getName(), null);
                                                    if (renameDialog.open() == 0 && (newName = renameDialog.getValue()) != null && !newName.trim().isEmpty()) {
                                                        targetFile = new File(targetPath, newName);
                                                        try {
                                                            ImageViewAll.this.copyFile(new File(file), targetFile);
                                                        }
                                                        catch (IOException e) {
                                                            LoggerFactory.getLogger(this.getClass()).warn("File no copy ", (Throwable)e);
                                                        }
                                                    }
                                                    break block26;
                                                }
                                                case 2: {
                                                    break block22;
                                                }
                                            }
                                            break block26;
                                        }
                                        try {
                                            ImageViewAll.this.copyFile(new File(file), targetFile);
                                        }
                                        catch (IOException e) {
                                            LoggerFactory.getLogger(this.getClass()).warn("File no copy ", (Throwable)e);
                                        }
                                    }
                                    GalleryItem parentGroup = ImageViewAll.this.gallery.getItem(new Point(event.x, event.y));
                                    GalleryItem newItem = parentGroup != null && parentGroup.getParentItem() == null ? new GalleryItem(parentGroup, 0) : new GalleryItem(ImageViewAll.this.gallery, 0);
                                    newItem.setImage(image);
                                    newItem.setData((Object)targetPath);
                                    ImageViewAll.this.createdImages.add(image);
                                    lastAddedItem = newItem;
                                }
                                catch (Exception e) {
                                    LoggerFactory.getLogger(this.getClass()).warn("Error processing image file", (Throwable)e);
                                    if (image == null || image.isDisposed()) break block22;
                                    image.dispose();
                                }
                            }
                            ++n4;
                        }
                        ImageViewAll.this.updateGalleryForPatient(ImageViewAll.this.aktuellerPatient);
                        stringArray = ImageViewAll.this.gallery.getItems();
                        n3 = stringArray.length;
                        n4 = 0;
                        while (n4 < n3) {
                            String group = stringArray[n4];
                            group.setExpanded(group.getText().equals(ImageViewAll.this.groupName));
                            ++n4;
                        }
                        if (lastAddedItem != null && Arrays.asList(ImageViewAll.this.gallery.getItems()).contains(lastAddedItem)) {
                            ImageViewAll.this.gallery.setSelection(new GalleryItem[]{lastAddedItem});
                        }
                        break block24;
                    }
                    String sourcePath = (String)event.data;
                    GalleryItem galleryItem = ImageViewAll.this.gallery.getItem(new Point(event.x, event.y));
                }
            }
        });
    }

    private void deleteSelectedItem(GalleryItem selectedItem) {
        String filePath = String.valueOf((String)selectedItem.getData()) + File.separator + selectedItem.getText();
        File fileToDelete = new File(filePath);
        File thumbnailToDelete = new File(fileToDelete.getParentFile(), "thumbnails/" + fileToDelete.getName());
        if (fileToDelete.exists() && fileToDelete.delete()) {
            Image img;
            if (thumbnailToDelete.exists()) {
                thumbnailToDelete.delete();
            }
            if ((img = selectedItem.getImage()) != null && !img.isDisposed()) {
                img.dispose();
                this.createdImages.remove(img);
            }
            selectedItem.getParentItem().remove(selectedItem);
            File parentDir = fileToDelete.getParentFile();
            if (this.isEmptyDirectory(parentDir)) {
                parentDir.delete();
                this.updateGalleryForPatient(this.aktuellerPatient);
            }
        }
    }

    public void updateGalleryForPatient(Patient aktuellerPatient) {
        this.aktuellerPatient = aktuellerPatient;
        this.initializeGallery();
        this.processDirectories();
        this.updateUI();
    }

    private void initializeGallery() {
        this.disposeAllImages();
        this.gallery.removeAll();
    }

    private void processDirectories() {
        File[] groupDirectories;
        String mainDirectoryPath = Tracker.makeDescriptorImage(this.aktuellerPatient);
        File mainDirectory = new File(mainDirectoryPath);
        if (mainDirectory.exists() && mainDirectory.isDirectory() && (groupDirectories = mainDirectory.listFiles(File::isDirectory)) != null) {
            Arrays.sort(groupDirectories, (file1, file2) -> file2.getName().compareTo(file1.getName()));
            File[] fileArray = groupDirectories;
            int n = groupDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File groupDir = fileArray[n2];
                this.processGroupDirectory(groupDir);
                ++n2;
            }
        }
    }

    private void processGroupDirectory(File groupDir) {
        GalleryItem group = new GalleryItem(this.gallery, 0);
        group.setText(groupDir.getName());
        group.setData((Object)groupDir.getAbsolutePath());
        this.addImagesToGalleryFromDirectory(groupDir, group);
        File[] imageDirectories = groupDir.listFiles(File::isDirectory);
        if (imageDirectories != null && imageDirectories.length > 0) {
            File[] fileArray = imageDirectories;
            int n = imageDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File imgDir = fileArray[n2];
                this.addImagesToGalleryFromDirectory(imgDir, group);
                ++n2;
            }
        }
        new HoverListener(group, Display.getCurrent().getSystemColor(1), Display.getCurrent().getSystemColor(15), 500, 500);
    }

    private void updateUI() {
        Display.getDefault().asyncExec(() -> {
            if (this.gallery.getItemCount() > 0) {
                GalleryItem firstGroup = this.gallery.getItem(0);
                firstGroup.setExpanded(true);
                if (firstGroup.getItemCount() > 0) {
                    this.gallery.setSelection(new GalleryItem[]{firstGroup.getItem(0)});
                }
            }
        });
        this.gallery.redraw();
    }

    private void addImagesToGalleryFromDirectory(File dir, GalleryItem parentGroup) {
        File[] imageFiles = this.getImageFiles(dir);
        if (imageFiles == null || imageFiles.length == 0) {
            return;
        }
        List<File> imagesToProcess = this.processImageFiles(imageFiles, parentGroup);
        this.createThumbnails(imagesToProcess, parentGroup);
    }

    private File[] getImageFiles(File dir) {
        return dir.listFiles(file -> ThumbnailHandler.isSupportedImageFormat(file.getName()));
    }

    private List<File> processImageFiles(File[] imageFiles, GalleryItem parentGroup) {
        ArrayList<File> imagesToProcess = new ArrayList<File>();
        File[] fileArray = imageFiles;
        int n = imageFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File imgFile = fileArray[n2];
            File parentDir = imgFile.getParentFile();
            if (!"thumbnails".equals(parentDir.getName())) {
                File thumbnailDirectory = new File(parentDir, "thumbnails");
                File thumbnailFile = new File(thumbnailDirectory, imgFile.getName());
                if (!thumbnailFile.exists()) {
                    imagesToProcess.add(imgFile);
                } else {
                    this.addImageToGallery(imgFile, parentGroup, thumbnailFile);
                }
            }
            ++n2;
        }
        return imagesToProcess;
    }

    private void createThumbnails(List<File> imagesToProcess, GalleryItem parentGroup) {
        if (imagesToProcess.isEmpty()) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.gallery.getShell());
        try {
            dialog.run(true, true, monitor -> {
                monitor.beginTask("Thumbnails erstellen", imagesToProcess.size());
                for (File imgFile : imagesToProcess) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.subTask("Erstelle Thumbnail f\u00fcr " + imgFile.getName());
                    this.addImageToGallery(imgFile, parentGroup, null);
                    monitor.worked(1);
                }
                monitor.done();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error when creating thumbnails", (Throwable)e);
        }
    }

    private void addImageToGallery(File imgFile, GalleryItem parentGroup, File thumbnailFile) {
        Display.getDefault().asyncExec(() -> {
            GalleryItem item = new GalleryItem(parentGroup, 0);
            item.setText(imgFile.getName());
            item.setData((Object)imgFile.getParentFile().getAbsolutePath());
            File finalThumbnailFile = thumbnailFile;
            if (finalThumbnailFile == null) {
                try {
                    File originalImage = imgFile.getCanonicalFile();
                    File thumbnailDirectory = new File(originalImage.getParentFile(), "thumbnails");
                    if (!thumbnailDirectory.exists() && !thumbnailDirectory.mkdirs()) {
                        return;
                    }
                    finalThumbnailFile = ThumbnailHandler.createThumbnail(originalImage);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Thumbnail could not be created", (Throwable)e);
                }
            }
            if (finalThumbnailFile != null) {
                Image thumbnailImage = new Image((Device)Display.getDefault(), finalThumbnailFile.getAbsolutePath());
                item.setImage(thumbnailImage);
                this.createdImages.add(thumbnailImage);
            }
            this.gallery.redraw();
        });
    }

    public void removeAll() {
        this.gallery.removeAll();
    }

    private void disposeAllImages() {
        for (Image image : this.createdImages) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        this.createdImages.clear();
    }

    public void redraw() {
        this.gallery.redraw();
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    public void copyFile(File source, File target) throws IOException {
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private boolean isEmptyDirectory(File directory) {
        String[] contents = directory.list();
        return contents == null || contents.length == 0;
    }

    private void animateScrollBar(ScrollBar scrollBar, int start, int end) {
        AnimationRunner runner = new AnimationRunner();
        LinearInOut movement = new LinearInOut();
        int duration = 500;
        MoveScrollBarEffect effect = new MoveScrollBarEffect(scrollBar, start, end, (long)duration, (IMovement)movement, null, null);
        runner.runEffect((IEffect)effect);
    }

    public void createOrUpdateThumbnail(File originalImageFile, File thumbnailFile) throws IOException {
        ThumbnailHandler.createThumbnail(originalImageFile);
    }

    public void updateThumbnailInUI(File thumbnailFile) {
        Display.getDefault().asyncExec(() -> {
            GalleryItem[] galleryItemArray = this.gallery.getItems();
            int n = galleryItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                GalleryItem item = galleryItemArray[n2];
                if (item.getData().equals(thumbnailFile.getParent()) && item.getText().equals(thumbnailFile.getName())) {
                    Image newThumbnailImage = new Image((Device)Display.getDefault(), thumbnailFile.getAbsolutePath());
                    item.setImage(newThumbnailImage);
                    this.gallery.redraw();
                    break;
                }
                ++n2;
            }
        });
    }

    private boolean renameGroupDirectory(String oldName, String newName) {
        String basePath = Tracker.makeDescriptorImage(this.aktuellerPatient);
        File oldDir = new File(basePath, oldName);
        File newDir = new File(basePath, newName);
        if (!oldDir.exists() || newDir.exists()) {
            return false;
        }
        return oldDir.renameTo(newDir);
    }

    public class CustomFileDialog
    extends MessageDialog {
        public static final int OVERWRITE_ID = 0;
        public static final int RENAME_ID = 1;
        public static final int CANCEL_ID = 2;

        public CustomFileDialog(Shell parentShell) {
            super(parentShell, "Dateiaktion", null, "Die Datei existiert bereits. Was m\u00f6chten Sie tun?", 3, new String[]{"\u00dcberschreiben", "Umbenennen", "Abbrechen"}, 0);
        }

        public int open() {
            return super.open();
        }
    }
}

