/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views2;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.data.Tracker;
import ch.elexis.molemax.views2.ImageDetailWithGalleryView;
import ch.elexis.molemax.views2.ImageViewAll;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageOverview
extends ViewPart
implements IRefreshable {
    public static final String ID = "molemax.overview";
    Form form;
    FormToolkit tk;
    protected Tracker[][] trackers;
    private StackLayout stack;
    private Composite fullImageView;
    private Composite galleryComposite;
    private Label fullImageLabel;
    private ImageDetailWithGalleryView imageDetailWithGalleryView;
    private Composite stackComposite;
    Patient pat;
    String date;
    Composite outer;
    String pat2;
    ImageViewAll imageViewAll;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);
    protected Composite dispAll;

    private void createFullImageView(Composite parent) {
        this.fullImageView = new Composite(parent, 0);
        this.fullImageView.setLayout((Layout)new GridLayout());
        this.fullImageLabel = new Label(this.fullImageView, 0);
        this.fullImageLabel.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public ImageOverview() {
        this.tk = UiDesk.getToolkit();
        this.trackers = new Tracker[12][];
    }

    @Optional
    @Inject
    void activePatient(IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Patient newPatient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            if (newPatient != null) {
                if (!newPatient.equals((Object)this.getSelectedPatient())) {
                    this.switchToGalleryView(this.form.getBody());
                }
                this.setPatient(newPatient, null);
            }
        }, (Object)this.form);
    }

    public void createPartControl(final Composite parent) {
        this.form = this.tk.createForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        GridLayout layout = new GridLayout(4, false);
        body.setLayout((Layout)layout);
        Label patientLabel = new Label(body, 0);
        patientLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.stack = new StackLayout();
        this.stackComposite = new Composite(body, 0);
        this.stackComposite.setLayout((Layout)this.stack);
        this.stackComposite.setLayoutData((Object)new GridData(1808));
        this.galleryComposite = new Composite(this.stackComposite, 0);
        this.galleryComposite.setLayout((Layout)new GridLayout(1, false));
        this.imageViewAll = new ImageViewAll(this.galleryComposite);
        this.imageViewAll.setOverviewInstance(this);
        this.createFullImageView(this.stackComposite);
        this.stack.topControl = this.galleryComposite;
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        parent.getShell().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    parent.getShell().close();
                }
            }
        });
    }

    void setTopControl(Control imageViewAll) {
        this.stack.topControl = imageViewAll;
    }

    private void updateGalleryForPatient() {
        Patient aktuellerPatient = this.getSelectedPatient();
        this.imageViewAll.updateGalleryForPatient(aktuellerPatient);
    }

    public void setPatient(Patient p, String dat) {
        if (p == null) {
            this.form.setText(Messages.Overview_noPatient);
            return;
        }
        if (dat == null) {
            dat = Tracker.getLastSequenceDate(p);
        }
        if (p.equals((Object)this.pat) && dat.equals(this.date)) {
            return;
        }
        int i = 0;
        while (i < 12) {
            if (this.trackers[i] != null) {
                Tracker.dispose(this.trackers[i]);
            }
            ++i;
        }
        this.pat = p;
        this.date = dat;
        i = 0;
        while (i < 12) {
            Tracker base = Tracker.loadBase(p, this.date, i);
            this.trackers[i] = Tracker.getImageStack(base);
            ++i;
        }
        this.form.setText(p.getLabel());
        this.updateGalleryForPatient();
    }

    public void setFocus() {
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
        if (template.equals(Patient.class)) {
            this.setPatient(null, null);
        }
    }

    public void switchToGalleryView(Composite parent) {
        this.stack.topControl = this.galleryComposite;
        this.imageViewAll.getGallery().redraw();
        this.stackComposite.layout();
        this.stackComposite.redraw();
    }

    public void selectionEvent(PersistentObject obj) {
        boolean cfr_ignored_0 = obj instanceof Anwender;
        if (obj instanceof Patient) {
            this.setPatient((Patient)obj, null);
        }
    }

    public void showFullImage(Image image, String folderPath, String absoluteImagePath, String thumbnailImagePath) {
        if (this.imageDetailWithGalleryView != null) {
            this.imageDetailWithGalleryView = null;
        }
        this.imageDetailWithGalleryView = new ImageDetailWithGalleryView(this, this.stackComposite, folderPath);
        this.imageDetailWithGalleryView.updateGalleryForSelectedGroup(folderPath);
        this.imageDetailWithGalleryView.setSelectedImage(image, absoluteImagePath);
        this.imageDetailWithGalleryView.selectGalleryItemByImagePath(thumbnailImagePath);
        this.stack.topControl = this.imageDetailWithGalleryView.getControl();
        this.stackComposite.layout();
    }

    public Patient getSelectedPatient() {
        return this.pat;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.molemax", (String)path);
    }

    public void reloadGallery() {
        Patient aktuellerPatient = this.getSelectedPatient();
        this.imageViewAll.updateGalleryForPatient(aktuellerPatient);
        this.stackComposite.layout();
        this.stackComposite.redraw();
    }
}

