/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views2;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.handler.ThumbnailHandler;
import ch.elexis.molemax.views2.ImageOverview;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.nebula.animation.effects.MoveScrollBarEffect;
import org.eclipse.nebula.animation.movement.ExpoOut;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.slf4j.LoggerFactory;

public class ImageDetailWithGalleryView {
    private ImageOverview overviewInstance;
    private Gallery gallery;
    private Label fullImageLabel;
    private Composite mainComposite;
    private Composite contentComposite;
    private List<Image> createdImages = new ArrayList<Image>();
    private ScrolledComposite scrolledComposite;
    private Menu contextMenu;
    private Color blue = Display.getCurrent().getSystemColor(9);
    private Image originalImage = null;
    private Label label;

    public ImageDetailWithGalleryView(ImageOverview overview, final Composite parent, String folderPath) {
        this.overviewInstance = overview;
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.label = SWTHelper.createHyperlink((Composite)this.mainComposite, (String)"Zur\u00fcck zur Galerie", (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ImageDetailWithGalleryView.this.overviewInstance.switchToGalleryView(parent);
            }
        });
        this.label.setForeground(this.blue);
        FontData[] fontData = this.label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(14);
            fontData[i].setStyle(1);
            ++i;
        }
        final Font newFont = new Font((Device)this.mainComposite.getDisplay(), fontData);
        this.label.setFont(newFont);
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
        Label placeholder = new Label(this.mainComposite, 0);
        this.gallery = new Gallery(this.mainComposite, 0x10000202);
        GridData galleryGridData = new GridData();
        galleryGridData.widthHint = 310;
        galleryGridData.verticalAlignment = 4;
        this.gallery.setLayoutData((Object)galleryGridData);
        DefaultGalleryGroupRenderer gr = new DefaultGalleryGroupRenderer();
        gr.setItemHeight(300);
        gr.setItemWidth(300);
        gr.setAutoMargin(true);
        gr.setMinMargin(1);
        gr.setExpanded(true);
        gr.setAlwaysExpanded(true);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        DefaultGalleryItemRenderer ir = new DefaultGalleryItemRenderer();
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.scrolledComposite = new ScrolledComposite(this.mainComposite, 0x10000B00);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        this.scrolledComposite.setLayoutData((Object)gridData);
        this.contentComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.contentComposite.setLayout((Layout)new FillLayout());
        this.contentComposite.layout(true, true);
        this.scrolledComposite.setMinSize(this.contentComposite.computeSize(-1, -1));
        this.mainComposite.layout(true, true);
        this.fullImageLabel = new Label(this.contentComposite, 0);
        this.scrolledComposite.setContent((Control)this.contentComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.contentComposite.computeSize(-1, -1));
        this.gallery.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                GalleryItem[] selection = ImageDetailWithGalleryView.this.gallery.getSelection();
                if (selection.length > 0) {
                    String selectedThumbnailPath = (String)selection[0].getData();
                    File thumbnailFile = new File(selectedThumbnailPath);
                    File originalFile = new File(thumbnailFile.getParentFile().getParent(), thumbnailFile.getName());
                    if (originalFile.exists() && originalFile.isFile()) {
                        try {
                            Image originalImage = new Image((Device)Display.getDefault(), originalFile.getAbsolutePath());
                            ImageDetailWithGalleryView.this.createdImages.add(originalImage);
                            ImageDetailWithGalleryView.this.fullImageLabel.setImage(ImageDetailWithGalleryView.this.getScaledImageForLabel(originalImage));
                            ImageDetailWithGalleryView.this.fullImageLabel.setData("originalImage", (Object)originalFile.getAbsolutePath());
                            Display.getCurrent().asyncExec(() -> {
                                if (!(ImageDetailWithGalleryView.this.contentComposite.isDisposed() || ImageDetailWithGalleryView.this.scrolledComposite.isDisposed() || ImageDetailWithGalleryView.this.mainComposite.isDisposed())) {
                                    ImageDetailWithGalleryView.this.contentComposite.layout(true, true);
                                    ImageDetailWithGalleryView.this.scrolledComposite.setMinSize(ImageDetailWithGalleryView.this.contentComposite.computeSize(-1, -1));
                                    ImageDetailWithGalleryView.this.mainComposite.layout(true, true);
                                }
                            });
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(this.getClass()).warn("Error loading the original image: " + e.getMessage());
                        }
                    } else {
                        LoggerFactory.getLogger(this.getClass()).warn("Original image not found or is not a file: " + originalFile.getAbsolutePath());
                    }
                }
            }
        });
        this.fullImageLabel.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ImageDetailWithGalleryView.this.showMaximizedImage();
            }
        });
        this.gallery.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ImageDetailWithGalleryView.this.showMaximizedImage();
            }
        });
        this.gallery.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    Display.getCurrent().syncExec(() -> {
                        GalleryItem[] selection;
                        if (!ImageDetailWithGalleryView.this.gallery.isDisposed() && (selection = ImageDetailWithGalleryView.this.gallery.getSelection()).length > 0 && !selection[0].isDisposed()) {
                            String selectedThumbnailPath = (String)selection[0].getData();
                            File thumbnailFile = new File(selectedThumbnailPath);
                            File originalFile = new File(thumbnailFile.getParentFile().getParent(), thumbnailFile.getName());
                            if (originalFile.exists() && originalFile.isFile()) {
                                if (ImageDetailWithGalleryView.this.originalImage != null && !ImageDetailWithGalleryView.this.originalImage.isDisposed()) {
                                    ImageDetailWithGalleryView.this.originalImage.dispose();
                                }
                                ImageDetailWithGalleryView.this.originalImage = new Image((Device)Display.getDefault(), originalFile.getAbsolutePath());
                                if (!ImageDetailWithGalleryView.this.fullImageLabel.isDisposed()) {
                                    ImageDetailWithGalleryView.this.fullImageLabel.setImage(ImageDetailWithGalleryView.this.getScaledImageForLabel(ImageDetailWithGalleryView.this.originalImage));
                                    ImageDetailWithGalleryView.this.fullImageLabel.setData("originalImage", (Object)originalFile.getAbsolutePath());
                                    ImageDetailWithGalleryView.this.contentComposite.layout(true, true);
                                    ImageDetailWithGalleryView.this.scrolledComposite.setMinSize(ImageDetailWithGalleryView.this.contentComposite.computeSize(-1, -1));
                                    ImageDetailWithGalleryView.this.mainComposite.layout(true, true);
                                }
                            } else {
                                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Original image not found or is not a file: " + originalFile.getAbsolutePath());
                            }
                        }
                    });
                } else if (e.keyCode == 27) {
                    ImageDetailWithGalleryView.this.overviewInstance.switchToGalleryView(ImageDetailWithGalleryView.this.mainComposite.getParent());
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ImageDetailWithGalleryView.this.showMaximizedImage();
                } else if (e.keyCode == 127) {
                    ImageDetailWithGalleryView.this.deleteSelectedImages();
                }
            }
        });
        final Menu galleryContextMenu = this.createContextMenu((Control)this.gallery);
        final Menu fullImageLabelContextMenu = this.createContextMenu((Control)this.fullImageLabel);
        this.gallery.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    GalleryItem item = ImageDetailWithGalleryView.this.gallery.getItem(new Point(e.x, e.y));
                    ImageDetailWithGalleryView.this.gallery.setMenu(item != null ? galleryContextMenu : null);
                }
            }
        });
        this.fullImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    ImageDetailWithGalleryView.this.fullImageLabel.setMenu(fullImageLabelContextMenu);
                }
            }
        });
        this.gallery.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    GalleryItem item = ImageDetailWithGalleryView.this.gallery.getItem(new Point(e.x, e.y));
                    if (item != null) {
                        ImageDetailWithGalleryView.this.gallery.setMenu(ImageDetailWithGalleryView.this.contextMenu);
                    } else {
                        ImageDetailWithGalleryView.this.gallery.setMenu(null);
                    }
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.gallery, 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] files;
                    String[] stringArray = files = (String[])event.data;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File currentImageFile;
                        File targetDirectory;
                        String file = stringArray[n2];
                        String currentImagePath = (String)ImageDetailWithGalleryView.this.fullImageLabel.getData("originalImage");
                        if (currentImagePath != null && (targetDirectory = (currentImageFile = new File(currentImagePath)).getParentFile()) != null) {
                            File destinationFile = new File(targetDirectory, new File(file).getName());
                            try {
                                Files.copy(new File(file).toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                LoggerFactory.getLogger(this.getClass()).warn("Error while copying file: ", (Object)e, (Object)e.getMessage());
                            }
                            if (ImageDetailWithGalleryView.this.overviewInstance != null) {
                                ImageDetailWithGalleryView.this.overviewInstance.reloadGallery();
                            }
                            ImageDetailWithGalleryView.this.updateGalleryForSelectedGroup(targetDirectory.getAbsolutePath());
                            ImageDetailWithGalleryView.this.gallery.redraw();
                            ImageDetailWithGalleryView.this.gallery.update();
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void updateGalleryForSelectedGroup(String folderPath) {
        this.gallery.removeAll();
        File directory = new File(folderPath);
        if (directory.exists() && directory.isDirectory()) {
            GalleryItem group = new GalleryItem(this.gallery, 0);
            group.setText(directory.getName());
            group.setExpanded(true);
            this.addImagesToGalleryFromDirectory(directory, group);
            File[] imageDirectories = directory.listFiles(File::isDirectory);
            if (imageDirectories != null && imageDirectories.length > 0) {
                File[] fileArray = imageDirectories;
                int n = imageDirectories.length;
                int n2 = 0;
                while (n2 < n) {
                    File imgDir = fileArray[n2];
                    this.addImagesToGalleryFromDirectory(imgDir, group);
                    ++n2;
                }
            }
        }
    }

    public void selectAndShowFirstImage() {
        if (this.gallery.getItemCount() > 0) {
            GalleryItem firstItem = this.gallery.getItem(0);
            this.gallery.setSelection(new GalleryItem[]{firstItem});
        }
    }

    private void addImagesToGalleryFromDirectory(File dir, GalleryItem parentGroup) {
        File[] imageFiles;
        File thumbnailDirectory = new File(dir, "thumbnails");
        if (thumbnailDirectory.exists() && thumbnailDirectory.isDirectory() && (imageFiles = thumbnailDirectory.listFiles(file -> file.isFile() && ThumbnailHandler.isSupportedImageFormat(file.getName()))) != null) {
            File[] fileArray = imageFiles;
            int n = imageFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File imgFile = fileArray[n2];
                GalleryItem item = new GalleryItem(parentGroup, 0);
                Image image = new Image((Device)Display.getDefault(), imgFile.getAbsolutePath());
                this.createdImages.add(image);
                item.setImage(image);
                item.setText(imgFile.getName());
                item.setData((Object)imgFile.getAbsolutePath());
                ++n2;
            }
        }
    }

    public void selectImageInGallery(String imagePath) {
        GalleryItem[] items;
        GalleryItem[] galleryItemArray = items = this.gallery.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GalleryItem item = galleryItemArray[n2];
            String itemPath = (String)item.getData();
            if (itemPath != null && itemPath.equals(imagePath)) {
                this.gallery.setSelection(new GalleryItem[]{item});
                break;
            }
            ++n2;
        }
    }

    private void deleteSelectedItem(GalleryItem selectedItem) {
        String selectedItemPath = (String)selectedItem.getData();
        File fileToDelete = new File(selectedItemPath);
        if (fileToDelete.exists() && fileToDelete.delete()) {
            File originalFile = new File(fileToDelete.getParentFile().getParent(), fileToDelete.getName());
            if (originalFile.exists()) {
                originalFile.delete();
            }
            selectedItem.getImage().dispose();
            this.createdImages.remove(selectedItem.getImage());
            selectedItem.getParentItem().remove(selectedItem);
            this.fullImageLabel.redraw();
        }
        this.overviewInstance.reloadGallery();
    }

    private Menu createContextMenu(Control control) {
        Menu contextMenu = new Menu(control);
        MenuItem deleteItem = new MenuItem(contextMenu, 0);
        deleteItem.setText(Messages.ImageSlot_delete);
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDetailWithGalleryView.this.deleteSelectedImages();
            }
        });
        control.setMenu(contextMenu);
        return contextMenu;
    }

    private void deleteSelectedImages() {
        boolean confirm;
        GalleryItem[] selection = this.gallery.getSelection();
        if (selection.length > 0 && (confirm = MessageDialog.openConfirm((Shell)this.gallery.getShell(), (String)Messages.ImageSlot_imageDel, (String)(selection.length > 1 ? String.valueOf(Messages.ImageSlot_these) + selection.length + " " + Messages.ImageSlot_imagesdelete : Messages.ImageSlot_reallydelete)))) {
            GalleryItem[] galleryItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                GalleryItem selectedItem = galleryItemArray[n2];
                this.deleteSelectedItem(selectedItem);
                ++n2;
            }
            this.fullImageLabel.redraw();
        }
    }

    public void disposeAllImages() {
        for (Image image : this.createdImages) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this.createdImages.clear();
    }

    public void dispose() {
        this.disposeAllImages();
        this.mainComposite.dispose();
    }

    public Composite getControl() {
        return this.mainComposite;
    }

    public void setSelectedImage(Image image, String absoluteImagePath) {
        if (image == null || image.isDisposed()) {
            return;
        }
        Image previousScaledImage = (Image)this.fullImageLabel.getData("scaledImage");
        if (previousScaledImage != null && !previousScaledImage.isDisposed()) {
            previousScaledImage.dispose();
        }
        Image scaledImage = this.getScaledImageForLabel(image);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        if (scaledImage != null && !scaledImage.isDisposed()) {
            this.fullImageLabel.setImage(scaledImage);
            this.fullImageLabel.setData("scaledImage", (Object)scaledImage);
        } else {
            this.fullImageLabel.setImage(image);
            this.fullImageLabel.setData("scaledImage", null);
        }
        this.fullImageLabel.setLayoutData((Object)gd);
        Display.getCurrent().asyncExec(() -> {
            if (!(this.contentComposite.isDisposed() || this.scrolledComposite.isDisposed() || this.mainComposite.isDisposed())) {
                this.scrolledComposite.setMinSize(this.contentComposite.computeSize(-1, -1));
                this.contentComposite.layout(true, true);
                this.mainComposite.layout(true, true);
            }
        });
        if (!this.fullImageLabel.isDisposed()) {
            this.fullImageLabel.setData("originalImage", (Object)absoluteImagePath);
        }
    }

    public void selectGalleryItemByImagePath(String originalImagePath) {
        int itemHeight = 290;
        int headerHeight = 10;
        AnimationRunner runner = new AnimationRunner();
        String imagePath = this.convertToThumbnailPath(originalImagePath);
        GalleryItem[] galleryItemArray = this.gallery.getItems();
        int n = galleryItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GalleryItem group = galleryItemArray[n2];
            GalleryItem[] galleryItemArray2 = group.getItems();
            int n3 = galleryItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                GalleryItem item = galleryItemArray2[n4];
                String itemPath = (String)item.getData();
                if (itemPath != null && itemPath.equals(imagePath)) {
                    this.gallery.setSelection(new GalleryItem[]{item});
                    int groupIndex = this.gallery.indexOf(group);
                    int itemIndex = group.indexOf(item);
                    int totalHeightAbove = (group.getItemCount() * itemHeight + headerHeight) * groupIndex;
                    int itemPosition = totalHeightAbove + itemHeight * itemIndex;
                    int centerYPosition = itemPosition + itemHeight / 5 - this.gallery.getClientArea().height / 7;
                    ScrollBar vBar = this.gallery.getVerticalBar();
                    int currentSelection = vBar.getSelection();
                    MoveScrollBarEffect effect = new MoveScrollBarEffect(vBar, currentSelection, centerYPosition, 500L, (IMovement)new ExpoOut(), null, null);
                    runner.runEffect((IEffect)effect);
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void showMaximizedImage() {
        String imagePath = (String)this.fullImageLabel.getData("originalImage");
        if (imagePath != null && !imagePath.isEmpty()) {
            Program.launch((String)imagePath);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Image file does not exist or is empty.");
        }
    }

    private Image getScaledImageForLabel(Image original) {
        try {
            int originalWidth = original.getBounds().width;
            int originalHeight = original.getBounds().height;
            if (originalWidth <= 960 && originalHeight <= 810) {
                return original;
            }
            float scaleFactorX = 960.0f / (float)originalWidth;
            float scaleFactorY = 810.0f / (float)originalHeight;
            float scaleFactor = Math.min(scaleFactorX, scaleFactorY);
            int newWidth = Math.round((float)originalWidth * scaleFactor);
            int newHeight = Math.round((float)originalHeight * scaleFactor);
            BufferedImage bufferedImage = ImageDetailWithGalleryView.convertToAWT(original.getImageData());
            BufferedImage scaledBufferedImage = new BufferedImage(newWidth, newHeight, 1);
            Graphics2D graphics2D = scaledBufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
            Image scaledImage = new Image((Device)Display.getDefault(), ImageDetailWithGalleryView.convertToSWT(scaledBufferedImage));
            this.createdImages.add(scaledImage);
            original.dispose();
            return scaledImage;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Image ready to dispos ", (Throwable)e);
            original.dispose();
            return null;
        }
    }

    private static BufferedImage convertToAWT(ImageData data) {
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        BufferedImage bufferedImage = new BufferedImage(data.width, data.height, 1);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel = data.getPixel(x, y);
                RGB rgb = data.palette.getRGB(pixel);
                bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    private static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    private String convertToThumbnailPath(String originalImagePath) {
        File originalFile = new File(originalImagePath);
        File thumbnailDirectory = new File(originalFile.getParentFile(), "thumbnails");
        String fileName = originalFile.getName();
        if (fileName.toLowerCase().endsWith(".jpeg")) {
            fileName = String.valueOf(fileName.substring(0, fileName.length() - 5)) + ".jpg";
        }
        File thumbnailFile = new File(thumbnailDirectory, fileName);
        return thumbnailFile.getAbsolutePath();
    }
}

