/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.parts;

import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.DataHandler;
import ch.elexis.mednet.webapi.ui.handler.TableHelper;
import ch.elexis.mednet.webapi.ui.util.UIStyleTableHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormComposite {
    private Composite parent;
    private Integer customerId;
    private Integer providerId;
    private IFormSelectionListener formSelectionListener;

    public FormComposite(Composite parent, IFormSelectionListener formSelectionListener) {
        this.parent = parent;
        this.formSelectionListener = formSelectionListener;
    }

    public void show(Integer customerId, Integer providerId) {
        this.customerId = customerId;
        this.providerId = providerId;
        this.parent.setLayout((Layout)UIStyleTableHelper.createStyledGridLayout());
        Text searchBox = new Text(this.parent, 896);
        searchBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchBox.setMessage(Messages.Composite_searchBoxMessage);
        Table formTable = UIStyleTableHelper.createStyledTable(this.parent);
        String[] columnHeaders = new String[]{Messages.FormComposite_formId, Messages.FormComposite_formName};
        int[] nArray = new int[2];
        nArray[1] = 150;
        int[] columnWidths = nArray;
        TableColumn[] columns = new TableColumn[columnHeaders.length];
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(formTable, 0);
            column.setText(columnHeaders[i]);
            column.setWidth(columnWidths[i]);
            columns[i] = column;
            if (i == 0) {
                column.setResizable(false);
            }
            int columnIndex = i++;
            column.addListener(13, event -> TableHelper.sortTable(formTable, columnIndex));
        }
        DataHandler.fetchAndDisplayFormsForProvider(formTable, providerId, customerId);
        searchBox.addModifyListener(event -> {
            String searchText = searchBox.getText().toLowerCase();
            TableHelper.filterTable(formTable, searchText);
        });
        formTable.addListener(11, event -> {
            int tableWidth = table.getClientArea().width;
            int totalWidth = 0;
            int i = 0;
            while (i < formTable.getColumnCount() - 1) {
                totalWidth += formTable.getColumn(i).getWidth();
                ++i;
            }
            int remainingWidth = Math.max(100, tableWidth - totalWidth);
            columns[columns.length - 1].setWidth(remainingWidth);
        });
        formTable.addListener(8, event -> {
            TableItem[] selection = formTable.getSelection();
            if (selection.length > 0) {
                TableItem selectedItem = selection[0];
                try {
                    Integer formId = Integer.parseInt(selectedItem.getText(0));
                    String formName = selectedItem.getText(1);
                    if (formId != null) {
                        DataHandler.fillPatientData(customerId, providerId, formId);
                        if (this.formSelectionListener != null) {
                            this.formSelectionListener.onFormSelected(customerId, providerId, formId, formName);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
        this.parent.layout();
    }

    public static interface IFormSelectionListener {
        public void onFormSelected(Integer var1, Integer var2, Integer var3, String var4);
    }
}

