/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.handler;

import ch.elexis.mednet.webapi.ui.util.UIStyleTableHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableHelper {
    private static boolean ascending = true;

    public static void fillTableFromList(Table table, List<Map<String, Object>> list, Display display, String[] keys, String[] defaultValues) {
        for (Map<String, Object> map : list) {
            List files;
            String downloadUrl;
            String[] values = new String[keys.length];
            int j = 0;
            while (j < keys.length) {
                Object value = map.getOrDefault(keys[j], defaultValues[j]);
                if (keys[j].contains(".")) {
                    String[] keyParts = keys[j].split("\\.");
                    Map nestedObject = (Map)map.get(keyParts[0]);
                    values[j] = nestedObject != null ? TableHelper.convertToString(nestedObject.getOrDefault(keyParts[1], defaultValues[j])) : defaultValues[j];
                } else if (keys[j].equals("downloadUrl")) {
                    List files2;
                    values[j] = map.containsKey("files") ? ((files2 = (List)map.get("files")).size() > 0 ? ((downloadUrl = (String)((Map)files2.get(0)).get("downloadUrl")) != null ? TableHelper.extractDateFromUrl(downloadUrl) : defaultValues[j]) : defaultValues[j]) : defaultValues[j];
                } else if (keys[j].equals("patientDateOfBirth")) {
                    String birthDate = TableHelper.convertToString(map.getOrDefault(keys[j], defaultValues[j]));
                    values[j] = TableHelper.formatBirthDate(birthDate);
                } else if (keys[j].equals("patientLastName")) {
                    String firstName = TableHelper.convertToString(map.getOrDefault("patientFirstName", defaultValues[j]));
                    String lastName = TableHelper.convertToString(map.getOrDefault(keys[j], defaultValues[j]));
                    values[j] = String.valueOf(lastName) + " " + firstName;
                } else {
                    values[j] = TableHelper.convertToString(value);
                }
                ++j;
            }
            TableItem item = new TableItem(table, 0);
            item.setText(values);
            if (map.containsKey("files") && (files = (List)map.get("files")).size() > 0) {
                Map fileObject = (Map)files.get(0);
                downloadUrl = (String)fileObject.get("downloadUrl");
                if (downloadUrl != null) {
                    item.setData("downloadUrl", (Object)downloadUrl);
                }
                if (fileObject.containsKey("downloadHeaders")) {
                    List downloadHeadersList = (List)fileObject.get("downloadHeaders");
                    item.setData("downloadHeaders", (Object)downloadHeadersList);
                }
            }
            if (map.containsKey("packageId")) {
                String packageId = (String)map.get("packageId");
                item.setData("packageId", (Object)packageId);
            }
            UIStyleTableHelper.styleTableRows(item, table.indexOf(item), display);
        }
        UIStyleTableHelper.addTableLines(table);
    }

    private static String convertToString(Object value) {
        if (value instanceof Double) {
            return String.valueOf(((Double)value).longValue());
        }
        return value.toString();
    }

    private static String extractDateFromUrl(String url) {
        String pattern = "(\\d{14})";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(url);
        if (m.find()) {
            String dateString = m.group(0);
            String year = dateString.substring(0, 4);
            String month = dateString.substring(4, 6);
            String day = dateString.substring(6, 8);
            String hour = dateString.substring(8, 10);
            String minute = dateString.substring(10, 12);
            return String.valueOf(day) + "." + month + "." + year + " " + hour + ":" + minute;
        }
        return "Unknown Date";
    }

    private static String formatBirthDate(String birthDate) {
        if (birthDate == null || birthDate.isEmpty() || birthDate.equals("Unknown Birthdate")) {
            return "Unknown Birthdate";
        }
        try {
            if (birthDate.contains("T")) {
                birthDate = birthDate.split("T")[0];
            }
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate date = LocalDate.parse(birthDate, inputFormatter);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
            return date.format(outputFormatter);
        }
        catch (Exception e) {
            return "Invalid Date";
        }
    }

    public static void sortTable(Table table, int columnIndex) {
        if (table.isDisposed()) {
            return;
        }
        ArrayList<String[]> tableData = new ArrayList<String[]>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.isDisposed()) {
                String[] rowData = new String[table.getColumnCount()];
                int i = 0;
                while (i < table.getColumnCount()) {
                    rowData[i] = item.getText(i);
                    ++i;
                }
                tableData.add(rowData);
            }
            ++n2;
        }
        if (ascending) {
            tableData.sort(Comparator.comparing(row -> row[columnIndex].toLowerCase()));
        } else {
            tableData.sort((row1, row2) -> row2[columnIndex].toLowerCase().compareTo(row1[columnIndex].toLowerCase()));
        }
        ascending = !ascending;
        table.removeAll();
        Display display = table.getDisplay();
        int rowIndex = 0;
        for (String[] rowData : tableData) {
            TableItem newItem = new TableItem(table, 0);
            newItem.setText(rowData);
            UIStyleTableHelper.styleTableRows(newItem, rowIndex, display);
            ++rowIndex;
        }
    }

    public static void filterTable(Table table, String searchText) {
        List<String[]> originalData;
        if (table.getData("originalData") == null) {
            originalData = new ArrayList();
            TableItem[] tableItemArray = table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = tableItemArray[n2];
                String[] rowData = new String[table.getColumnCount()];
                int i = 0;
                while (i < table.getColumnCount()) {
                    rowData[i] = item.getText(i);
                    ++i;
                }
                originalData.add(rowData);
                ++n2;
            }
            table.setData("originalData", originalData);
        }
        table.removeAll();
        originalData = (List)table.getData("originalData");
        Display display = table.getDisplay();
        int rowIndex = 0;
        for (String[] rowData : originalData) {
            String name = rowData[1].toLowerCase();
            if (!name.contains(searchText)) continue;
            TableItem newItem = new TableItem(table, 0);
            newItem.setText(rowData);
            newItem.setData("rowData", (Object)rowData);
            UIStyleTableHelper.styleTableRows(newItem, rowIndex, display);
            ++rowIndex;
        }
    }
}

