/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.handler;

import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.mednet.webapi.core.IMednetAuthUi;
import ch.elexis.mednet.webapi.core.constants.ApiConstants;
import ch.elexis.mednet.webapi.core.fhir.resources.BundleResource;
import ch.elexis.mednet.webapi.core.fhir.resources.PatientResource;
import ch.elexis.mednet.webapi.core.fhir.resources.util.AdjustBundleIdentifiers;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientFetcher {
    @Inject
    private IMednetAuthUi authUi;
    @Inject
    private FhirResourceFactory resourceFactory;
    @Inject
    private IFindingsService findingsService;
    private IModelService coreModelService;
    private static final Logger logger = LoggerFactory.getLogger(PatientFetcher.class);
    private String token;
    private static final Gson gson = new Gson();
    public static final String DEBUG_MODE = "mednet.fhir.debug";

    public void setToken(String token) {
        this.token = token;
    }

    public PatientFetcher(String token) {
        this.token = token;
        CoreUiUtil.injectServices((Object)this);
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMednetAuthUi.class);
        this.authUi = (IMednetAuthUi)context.getService(serviceReference);
        this.coreModelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
    }

    public String fetchCustomerId() {
        String response = "";
        try {
            response = Request.Get((String)(String.valueOf(ApiConstants.getBaseApiUrl()) + "/customers?includeDetails=true")).addHeader("Authorization", "Bearer " + this.token).execute().returnContent().asString();
        }
        catch (IOException e) {
            logger.error("Error fetching customer ID: ", (Throwable)e);
        }
        return response;
    }

    public String fetchProvidersId(int customerID) {
        String apiUrl = String.format(String.valueOf(ApiConstants.getBaseApiUrl()) + "/providers?customerId=%d&includeDetails=true", customerID);
        String response = "";
        try {
            response = Request.Get((String)apiUrl).addHeader("Authorization", "Bearer " + this.token).execute().returnContent().asString();
        }
        catch (IOException e) {
            logger.error("Error fetching provider ID: ", (Throwable)e);
        }
        return response;
    }

    public String fetchFormsByProviderIdWithRetry(Integer customerId, Integer providerId) {
        String apiUrl = String.format(String.valueOf(ApiConstants.getBaseApiUrl()) + "/forms?customerId=%d&providerId=%d", customerId, providerId);
        String response = "";
        int retryCount = 0;
        boolean success = false;
        while (!success && retryCount < 5) {
            try {
                response = Request.Get((String)apiUrl).addHeader("Authorization", "Bearer " + this.token).execute().returnContent().asString();
                success = true;
                if (this.isValidJsonArray(response)) continue;
                if (this.isValidJsonObject(response)) {
                    JsonObject jsonResponse = JsonParser.parseString((String)response).getAsJsonObject();
                    return gson.toJson((JsonElement)jsonResponse);
                }
                throw new JsonSyntaxException("Expected a JSON array but got: " + response);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() != 429) continue;
                ++retryCount;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    logger.error("Thread interrupted during wait: ", (Throwable)ie);
                }
            }
            catch (JsonSyntaxException | IOException e) {
                break;
            }
        }
        return response;
    }

    private boolean isValidJsonObject(String response) {
        try {
            JsonParser.parseString((String)response).getAsJsonObject();
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    private boolean isValidJsonArray(String response) {
        block3: {
            try {
                if (response != null && !response.isEmpty() && response.trim().startsWith("[")) break block3;
                return false;
            }
            catch (JsonSyntaxException e) {
                return false;
            }
        }
        JsonParser.parseString((String)response).getAsJsonArray();
        return true;
    }

    public String fetchSubmitFormsId(int customerID) {
        String response;
        block8: {
            Content requestResponse;
            block7: {
                String apiUrl = String.format(String.valueOf(ApiConstants.getBaseApiUrl()) + "/submitted-forms?customerId=%d", customerID);
                response = "";
                requestResponse = Request.Get((String)apiUrl).addHeader("Authorization", "Bearer " + this.token).execute().returnContent();
                if (requestResponse != null) break block7;
                logger.error("Null response received from server for submitted forms.");
                return "Error: Null response from server";
            }
            response = requestResponse.asString();
            if (response != null && !response.isEmpty()) break block8;
            logger.error("Empty response received from server for submitted forms.");
            return "Error: Empty response from server";
        }
        try {
            if (!response.trim().startsWith("[")) {
                logger.error("Unexpected response format: Expected a JSON array, got something else.");
                return "Error: Expected a JSON array but got something else.";
            }
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 500) {
                logger.error("Server returned HTTP 500: Internal Server Error", (Throwable)e);
                return "Error 500: Internal Server Error";
            }
            logger.error("HTTP Error: " + e.getStatusCode() + " - " + e.getReasonPhrase(), (Throwable)e);
            return "Error: " + e.getStatusCode() + " - " + e.getReasonPhrase();
        }
        catch (IOException e) {
            logger.error("Error fetching submitted forms for customer ID: " + customerID, (Throwable)e);
            return "Error: " + e.getMessage();
        }
        return response;
    }

    public String fillPatientData(IPatient sourcePatient, JsonObject patientJson, List<IDocument> selectedDocuments, boolean isEpdSelected) {
        String apiUrl = String.valueOf(ApiConstants.getBaseApiUrl()) + "/patients";
        Bundle patientOverviewBundle = new Bundle();
        Patient fhirPatient = (Patient)this.resourceFactory.getResource((Object)sourcePatient, IPatient.class, Patient.class);
        fhirPatient.setId(UUID.nameUUIDFromBytes(sourcePatient.getId().getBytes()).toString());
        fhirPatient.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-patient");
        PatientFetcher.removeDuplicates(fhirPatient);
        PatientResource.addTelecomInformation((IPatient)sourcePatient, (Patient)fhirPatient);
        PatientResource.addContactInformation((IPatient)sourcePatient, (Patient)fhirPatient, (Bundle)patientOverviewBundle, (FhirResourceFactory)this.resourceFactory);
        patientOverviewBundle = BundleResource.createPatientOverviewBundle((Patient)fhirPatient, (IPatient)sourcePatient, selectedDocuments, (boolean)isEpdSelected, (FhirResourceFactory)this.resourceFactory, (IModelService)this.coreModelService, (IFindingsService)this.findingsService);
        AdjustBundleIdentifiers.adjustBundleIdentifiers((Bundle)patientOverviewBundle);
        String bundleJsonString = ModelUtil.getFhirJson((IBaseResource)patientOverviewBundle);
        JsonObject payload = new JsonObject();
        payload.addProperty("contentType", "FHIR");
        JsonObject contentJson = JsonParser.parseString((String)bundleJsonString).getAsJsonObject();
        payload.add("content", (JsonElement)contentJson);
        JsonObject urlConfig = new JsonObject();
        urlConfig.addProperty("customerId", patientJson.get("customerId").getAsString());
        urlConfig.addProperty("providerId", patientJson.get("providerId").getAsString());
        urlConfig.addProperty("formId", patientJson.get("formId").getAsString());
        urlConfig.addProperty("onlyOneTab", Boolean.valueOf(false));
        payload.add("urlConfig", (JsonElement)urlConfig);
        String payloadJson = gson.toJson((JsonElement)payload);
        if (System.getProperty(DEBUG_MODE) != null) {
            try {
                Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
                String prettyJson = prettyGson.toJson(JsonParser.parseString((String)payloadJson));
                System.out.println("FHIR JSON Payload:\n" + prettyJson);
            }
            catch (Exception ex) {
                System.out.println("FHIR JSON Payload (raw):\n" + payloadJson);
            }
        }
        try {
            String response = Request.Post((String)apiUrl).addHeader("Authorization", "Bearer " + this.token).bodyString(payloadJson, ContentType.APPLICATION_JSON).execute().returnContent().asString();
            logger.info("Response: " + response);
            this.authUi.openBrowser(response);
            return response;
        }
        catch (IOException e) {
            logger.error("Error sending patient data: ", (Throwable)e);
            return null;
        }
    }

    private static void removeDuplicates(Patient patient) {
        List uniqueProfiles = patient.getMeta().getProfile().stream().collect(Collectors.collectingAndThen(Collectors.toMap(PrimitiveType::getValue, c -> c, (c1, c2) -> c1), map -> new ArrayList(map.values())));
        patient.getMeta().setProfile(uniqueProfiles);
        List uniquePractitioners = patient.getGeneralPractitioner().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Reference::getReference, r -> r, (r1, r2) -> r1), map -> new ArrayList(map.values())));
        patient.getGeneralPractitioner().clear();
        patient.getGeneralPractitioner().addAll(uniquePractitioners);
    }
}

