/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.handler;

import ch.elexis.core.services.IConfigService;
import ch.elexis.mednet.webapi.core.IMednetAuthService;
import ch.elexis.mednet.webapi.core.constants.ApiConstants;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileDownloaderHandler {
    private static final Logger logger = LoggerFactory.getLogger(SingleFileDownloaderHandler.class);
    private IMednetAuthService authService;
    private String token;

    public void downloadSingleFile(String downloadUrl, String patientNr, String patientName, String exportType, String receiver, String sender, List<Map<String, String>> downloadHeadersList, String packageId, String createDate) {
        try {
            String downloadPath = this.getDownloadStore();
            if (downloadPath == null || downloadPath.trim().isEmpty()) {
                logger.error("Download path is not set. Please configure the download path in the settings.");
                return;
            }
            Path downloadDir = Paths.get(downloadPath, new String[0]);
            if (!Files.exists(downloadDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(downloadDir, new FileAttribute[0]);
                    logger.info("Download directory created: {}", (Object)downloadDir.toAbsolutePath());
                }
                catch (IOException e) {
                    logger.error("Error creating the download directory: {}", (Object)e.getMessage());
                    return;
                }
            }
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(downloadUrl)).GET();
            if (downloadHeadersList != null) {
                for (Map<String, String> header : downloadHeadersList) {
                    String key = header.get("key");
                    String value = header.get("value");
                    if (key == null || value == null) continue;
                    requestBuilder.header(key, value);
                }
            }
            HttpRequest request = requestBuilder.build();
            String sanitizedCreateDate = createDate.replaceAll("[\\\\/:*?\"<>|]", "_");
            Path filePath = downloadDir.resolve(String.valueOf(patientNr) + "_" + patientName + "_" + exportType + "_" + sender + "_" + receiver + "_" + sanitizedCreateDate + ".pdf");
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(filePath));
            if (response.statusCode() == 200) {
                logger.info("File downloaded successfully: {}", (Object)filePath.toAbsolutePath());
                this.acknowledgeDownloadSuccess(packageId);
            } else {
                logger.error("Error downloading the file. Status code: {}", (Object)response.statusCode());
                if (Files.exists(filePath, new LinkOption[0])) {
                    String responseBody = new String(Files.readAllBytes(filePath));
                    logger.error("Incorrect response body: {}", (Object)responseBody);
                } else {
                    logger.error("The file was not created.");
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            logger.error("An error occurred while downloading: {}", (Object)ex.getMessage());
        }
    }

    private String getDownloadStore() {
        try {
            IConfigService configService;
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IConfigService.class);
            if (serviceReference != null && (configService = (IConfigService)context.getService(serviceReference)) != null) {
                String downloadPath = configService.getActiveUserContact("MedNetDownloadpathPreference", "");
                if (downloadPath == null || downloadPath.trim().isEmpty()) {
                    logger.warn("No download path found in preferences.");
                } else {
                    logger.info("Download path retrieved: {}", (Object)downloadPath);
                }
                return downloadPath;
            }
            String pluginId = "ch.elexis.mednet.webapi.ui";
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode(pluginId);
            String downloadPath = node.get("MedNetDownloadpathPreference", "");
            if (downloadPath == null || downloadPath.trim().isEmpty()) {
                logger.warn("No download path found in preferences.");
            } else {
                logger.info("Download path retrieved: {}", (Object)downloadPath);
            }
            return downloadPath;
        }
        catch (Exception e) {
            logger.error("Error when retrieving the download path from the preferences: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void acknowledgeDownloadSuccess(String packageId) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMednetAuthService.class);
        if (serviceReference != null) {
            this.authService = (IMednetAuthService)context.getService(serviceReference);
            try {
                try {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("token_group", "mednet");
                    Optional<String> authToken = this.authService.getToken(parameters);
                    if (authToken.isPresent()) {
                        this.token = authToken.get();
                        try {
                            String successUrl = String.valueOf(ApiConstants.getBaseApiUrl()) + "/" + packageId + "/download-success?objectType=Form";
                            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(successUrl)).header("Authorization", "Bearer " + this.token).method("PATCH", HttpRequest.BodyPublishers.noBody()).build();
                            HttpClient client = HttpClient.newHttpClient();
                            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                            if (response.statusCode() != 200) return;
                            logger.info("Download successfully confirmed for package ID: " + packageId);
                            return;
                        }
                        catch (Exception ex) {
                            logger.error("An error occurred while confirming the download: " + ex.getMessage());
                            ex.printStackTrace();
                        }
                        return;
                    }
                    logger.error("No authentication token received.");
                    return;
                }
                catch (Exception ex) {
                    logger.error("An error occurred while retrieving the forms: {}", (Object)ex.getMessage());
                    context.ungetService(serviceReference);
                }
                return;
            }
            finally {
                context.ungetService(serviceReference);
            }
        } else {
            logger.error("ServiceReference for IMednetAuthService is null.");
        }
    }
}

