/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import at.medevit.ch.artikelstamm.IArtikelstammItem;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.IQuery;
import ch.elexis.mednet.webapi.core.fhir.resources.util.FhirResourceFactory;
import ch.elexis.mednet.webapi.core.service.ArtikelstammModelServiceHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;

public class MedicationStatementResource {
    public List<MedicationStatement> createMedicationStatementsFromPrescriptions(Reference patientReference, List<IPrescription> prescriptions, FhirResourceFactory resourceFactory) {
        ArrayList<MedicationStatement> medicationStatements = new ArrayList<MedicationStatement>();
        for (IPrescription prescription : prescriptions) {
            MedicationStatement ms;
            String productNumber;
            String pharmacode;
            IArticle article = prescription.getArticle();
            if (article == null) continue;
            Medication medication = resourceFactory.getResource(article, IArticle.class, Medication.class);
            if (medication == null) {
                medication = new Medication();
                medication.setId("unknown");
            }
            if (!medication.getMeta().hasProfile("https://mednet.swiss/fhir/StructureDefinition/mni-medication")) {
                medication.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-medication");
            }
            if (medication.getCode() != null && (medication.getCode().getText() == null || medication.getCode().getText().isEmpty())) {
                String defaultText = article.getName() != null ? article.getName() : "Undefined Medication";
                medication.getCode().setText(defaultText);
            }
            if ((pharmacode = this.getArticlePharmaCode(article)) != null && !pharmacode.isEmpty()) {
                medication.getCode().addCoding(new Coding().setSystem("urn:oid:2.16.756.5.30.2.6.1").setCode(pharmacode));
            }
            if ((productNumber = this.getArticleProductNumber(article)) != null && !productNumber.isEmpty()) {
                medication.getCode().addCoding(new Coding().setSystem("https://mednet.swiss/fhir/productNumber").setCode(productNumber));
            }
            this.adjustCodingSystems(medication);
            MedicationStatementResource.stripFreeTextCodes(medication);
            medication.setExtension(null);
            MedicationStatementResource.ensureAbsoluteExtensionUrls((DomainResource)medication);
            String medicationId = medication.getId();
            if (medicationId != null && medicationId.startsWith("Medication/")) {
                medicationId = medicationId.substring("Medication/".length());
                medication.setId(medicationId);
            }
            if (!(ms = resourceFactory.getResource(prescription, IPrescription.class, MedicationStatement.class)).getMeta().hasProfile("https://mednet.swiss/fhir/StructureDefinition/mni-medicationStatement")) {
                ms.getMeta().addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-medicationStatement");
            }
            ms.setExtension(null);
            MedicationStatementResource.ensureAbsoluteIdentifierSystems(ms);
            MedicationStatementResource.ensureDosageMeetsSlice(ms);
            if (!medication.hasId() || medication.getId().isEmpty()) {
                medication.setId(String.valueOf(ms.getId()) + "-med");
            }
            ms.addContained((Resource)medication);
            ms.setMedication((Type)new Reference("#" + medication.getId()));
            ms.setSubject(patientReference);
            medicationStatements.add(ms);
        }
        return medicationStatements;
    }

    private String getArticlePharmaCode(IArticle article) {
        Object value;
        String ret = "";
        try {
            Method method = article.getClass().getMethod("getPHAR", new Class[0]);
            ret = (String)method.invoke((Object)article, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException method) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)ret) && (value = article.getExtInfo((Object)"PharmaCode")) instanceof String && ((String)value).length() == 7) {
            ret = (String)value;
        }
        return StringUtils.defaultString((String)ret);
    }

    private void adjustCodingSystems(Medication medication) {
        if (medication.getCode() != null && medication.getCode().hasCoding()) {
            for (Coding coding : medication.getCode().getCoding()) {
                String system = coding.getSystem();
                if ("urn:oid:1.3.160".equals(system)) {
                    coding.setSystem("urn:oid:2.51.1.1");
                    continue;
                }
                if ("https://index.hcisolutions.ch/DataDoc/element/ARTICLE/ART/PHARMACODE".equals(system) || "2.16.756.5.30.2.6.1".equals(system)) {
                    coding.setSystem("urn:oid:2.16.756.5.30.2.6.1");
                    continue;
                }
                if ("urn:oid:2.16.840.1.113883.6.73".equals(system)) continue;
                "2.16.840.1.113883.6.73".equals(system);
            }
        }
    }

    private String getArticleProductNumber(IArticle article) {
        if (article != null) {
            IQuery query = ArtikelstammModelServiceHolder.get().getQuery(IArtikelstammItem.class);
            query.and("id", IQuery.COMPARATOR.EQUALS, (Object)article.getId());
            List results = query.execute();
            if (!results.isEmpty()) {
                IArtikelstammItem item = (IArtikelstammItem)results.get(0);
                return item.getProductId();
            }
        }
        return null;
    }

    private static boolean hasTextOrSpaces(String s) {
        return s != null && s.trim().contains(" ");
    }

    private static void ensureAbsoluteExtensionUrls(DomainResource r) {
        if (!r.hasExtension()) {
            return;
        }
        r.getExtension().forEach(ex -> {
            String u;
            if (ex.hasUrl() && (u = ex.getUrl()).startsWith("www.")) {
                ex.setUrl("https://" + u);
            }
        });
    }

    private static void stripFreeTextCodes(Medication med) {
        if (!med.hasCode() || !med.getCode().hasCoding()) {
            return;
        }
        ArrayList<Coding> keep = new ArrayList<Coding>();
        for (Coding c : med.getCode().getCoding()) {
            String sys = c.getSystem();
            if (!"urn:oid:2.51.1.1".equals(sys) && !"urn:oid:2.16.756.5.30.2.6.1".equals(sys) && !"https://mednet.swiss/fhir/productNumber".equals(sys)) continue;
            if (c.hasCode() && MedicationStatementResource.hasTextOrSpaces(c.getCode())) {
                String d = c.hasDisplay() ? String.valueOf(c.getDisplay()) + " " : "";
                c.setDisplay(String.valueOf(d) + c.getCode());
                c.setCode(null);
            }
            keep.add(c);
        }
        med.getCode().setCoding(keep);
    }

    private static void ensureDosageMeetsSlice(MedicationStatement ms) {
        if (!ms.hasDosage()) {
            ms.addDosage();
        }
        ms.getDosage().forEach(d -> {
            d.setAdditionalInstruction(null);
            d.setText(null);
            if (!d.hasTiming()) {
                Timing t = new Timing();
                t.setRepeat(new Timing.TimingRepeatComponent().setFrequency(1).setPeriod(1L).setPeriodUnit(Timing.UnitsOfTime.D));
                d.setTiming(t);
            }
            if (d.getDoseAndRate().isEmpty()) {
                d.addDoseAndRate().setDose((Type)new Quantity().setValue(1L));
            }
        });
    }

    private static void ensureAbsoluteIdentifierSystems(MedicationStatement ms) {
        if (!ms.hasIdentifier()) {
            ms.addIdentifier().setSystem("https://elexis.ch/fhir/identifier/medicationstatement").setValue(ms.getId());
        }
        ms.getIdentifier().forEach(id -> {
            if (id.hasSystem() && id.getSystem().startsWith("www.")) {
                id.setSystem("https://" + id.getSystem());
            }
        });
    }
}

