/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.fhir.resources;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.omnivore.model.IDocumentHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentResource {
    private static final Logger logger = LoggerFactory.getLogger(DocumentResource.class);

    public static List<DocumentReference> createDocuments(IPatient sourcePatient, String patientFullUrl, List<IDocument> selectedDocuments, boolean isEpdSelected) {
        ArrayList<DocumentReference> documentReferences = new ArrayList<DocumentReference>();
        for (IDocument document : selectedDocuments) {
            Attachment attachment;
            DocumentReference fhirDocument;
            block21: {
                IDocumentHandle docHandle;
                String documentPath;
                fhirDocument = new DocumentReference();
                fhirDocument.setId(UUID.nameUUIDFromBytes(document.getId().getBytes()).toString());
                Meta meta = new Meta();
                meta.addProfile("https://mednet.swiss/fhir/StructureDefinition/mni-documentReference");
                fhirDocument.setMeta(meta);
                fhirDocument.setStatus(Enumerations.DocumentReferenceStatus.CURRENT);
                CodeableConcept type = new CodeableConcept();
                Coding typeCoding = new Coding();
                typeCoding.setSystem("http://snomed.info/sct");
                typeCoding.setCode("419891008");
                typeCoding.setDisplay("Record artifact");
                type.addCoding(typeCoding);
                fhirDocument.setType(type);
                CodeableConcept category = new CodeableConcept();
                Coding snomedCoding = new Coding();
                snomedCoding.setSystem("http://snomed.info/sct");
                snomedCoding.setCode("371531000");
                snomedCoding.setDisplay("Report of clinical encounter (record artifact)");
                category.addCoding(snomedCoding);
                if (isEpdSelected) {
                    Coding esanitaCoding = new Coding();
                    esanitaCoding.setSystem("https://www.esanita.ch");
                    esanitaCoding.setCode("epd");
                    esanitaCoding.setDisplay("EPD");
                    category.addCoding(esanitaCoding);
                }
                fhirDocument.addCategory(category);
                fhirDocument.setSubject(new Reference(patientFullUrl));
                String authorReference = "urn:uuid:" + UUID.nameUUIDFromBytes(sourcePatient.getId().getBytes());
                fhirDocument.addAuthor(new Reference(authorReference));
                attachment = new Attachment();
                attachment.setContentType("application/pdf");
                String originalTitle = document.getTitle();
                if (originalTitle != null && originalTitle.contains(".")) {
                    originalTitle = originalTitle.substring(0, originalTitle.lastIndexOf(46));
                }
                attachment.setTitle(originalTitle);
                Date createdDate = document.getCreated();
                if (createdDate != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    String creationDate = dateFormat.format(createdDate);
                    attachment.setCreationElement(new DateTimeType(creationDate));
                }
                if ((documentPath = (docHandle = (IDocumentHandle)document).getHandle().getAbsolutePath()) != null && !documentPath.isEmpty()) {
                    File file;
                    Object path;
                    if (documentPath.startsWith("file:/")) {
                        path = documentPath.substring(6);
                        if (((String)path).startsWith("/")) {
                            path = ((String)path).substring(1);
                        }
                        file = new File((String)path);
                    } else {
                        file = new File(documentPath);
                    }
                    try {
                        path = null;
                        Object var21_23 = null;
                        try (FileInputStream fis = new FileInputStream(file);){
                            byte[] fileContent = new byte[(int)file.length()];
                            int bytesRead = fis.read(fileContent);
                            if (bytesRead != fileContent.length) {
                                logger.error("Konnte die gesamte Datei nicht lesen: " + documentPath);
                                continue;
                            }
                            attachment.setData(fileContent);
                            break block21;
                        }
                        catch (Throwable throwable) {
                            if (path == null) {
                                path = throwable;
                            } else if (path != throwable) {
                                ((Throwable)path).addSuppressed(throwable);
                            }
                            throw path;
                        }
                    }
                    catch (IOException e) {
                        logger.error("Fehler beim Lesen der Datei: " + file.getAbsolutePath());
                        e.printStackTrace();
                        continue;
                    }
                }
                logger.error("Dokumentpfad ist nicht verf\u00fcgbar f\u00fcr Dokument: " + document.getTitle());
                continue;
            }
            fhirDocument.addContent().setAttachment(attachment);
            documentReferences.add(fhirDocument);
        }
        return documentReferences;
    }
}

