/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.core.auth;

import ch.elexis.core.services.IConfigService;
import ch.elexis.mednet.webapi.core.IMednetAuthService;
import ch.elexis.mednet.webapi.core.IMednetAuthUi;
import ch.elexis.mednet.webapi.core.auth.GetAuthCodeWithStateSupplier;
import ch.elexis.mednet.webapi.core.constants.ApiConstants;
import ch.elexis.mednet.webapi.core.messages.Messages;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class MednetAuthService
implements IMednetAuthService {
    @Reference
    private IConfigService configService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private IMednetAuthUi authUi;
    private String currentState;
    private String currentCodeVerifier;

    @Override
    public Optional<String> getToken(Map<String, Object> parameters) {
        if (this.configService == null) {
            LoggerFactory.getLogger(this.getClass()).error("configService is null!");
            return Optional.empty();
        }
        String tokenGroup = (String)parameters.get("token_group");
        if (StringUtils.isNotBlank((CharSequence)tokenGroup)) {
            Optional<String> existingToken = this.validateToken(this.configService.getActiveMandator("mednet/auth/token/" + tokenGroup, null), tokenGroup);
            if (existingToken.isEmpty() && this.authUi != null) {
                return this.getToken(tokenGroup, this.authUi);
            }
            if (existingToken.isPresent()) {
                return existingToken;
            }
        }
        return Optional.empty();
    }

    private Optional<String> getToken(String tokenGroup, IMednetAuthUi iMednetAuthUi) {
        Optional<String> authCode = this.getAuthCode(tokenGroup, iMednetAuthUi);
        if (authCode.isPresent()) {
            return this.getAccessToken(tokenGroup, authCode.get(), this.getOauthRestUrl());
        }
        LoggerFactory.getLogger(this.getClass()).warn("No auth code for [" + tokenGroup + "]");
        return Optional.empty();
    }

    private String getOauthRestUrl() {
        return this.configService.get("mednet/auth/rest/baseurl", ApiConstants.getBaseUri());
    }

    private Optional<String> getAccessTokenWithRefresh(String tokenGroup, String refreshToken, String oauthRestUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "refresh_token");
        parameters.put("refresh_token", refreshToken);
        parameters.put("client_id", this.getClientId());
        parameters.put("client_secret", this.getClientSecret());
        String form = parameters.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.buildTokenEndpoint(oauthRestUrl))).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                Gson gson = new Gson();
                try {
                    Map map = (Map)gson.fromJson(response.body(), Map.class);
                    String token = (String)map.get("access_token");
                    this.configService.setActiveMandator("mednet/auth/token/" + tokenGroup, token);
                    String refreshtoken = (String)map.get("refresh_token");
                    if (StringUtils.isNotBlank((CharSequence)refreshtoken)) {
                        this.configService.setActiveMandator("mednet/auth/refreshtoken/" + tokenGroup, refreshtoken);
                    }
                    Double expiresInSeconds = (Double)map.get("expires_in");
                    Long expires = System.currentTimeMillis() + expiresInSeconds.longValue() * 1000L;
                    this.configService.setActiveMandator("mednet/auth/tokenexpires/" + tokenGroup, Long.toString(expires));
                    LoggerFactory.getLogger(this.getClass()).info("Got refreshed access token for [{}] expires [{}]", (Object)tokenGroup, (Object)Long.toString(expires));
                    return Optional.of(token);
                }
                catch (JsonSyntaxException ex) {
                    LoggerFactory.getLogger(this.getClass()).error("The answer is not a valid JSON: " + response.statusCode(), (Throwable)ex);
                }
            } else {
                LoggerFactory.getLogger(this.getClass()).error("Getting refreshed access token failed [" + response.statusCode() + " " + response.body() + "]");
            }
        }
        catch (IOException | InterruptedException e2) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting refreshed access token", (Throwable)e2);
        }
        return Optional.empty();
    }

    public Optional<String> getAuthCode(String tokenGroup, IMednetAuthUi iMedNetAuthUi) {
        String codeVerifier = this.generateCodeVerifier();
        String codeChallenge = this.generateCodeChallenge(codeVerifier);
        this.currentCodeVerifier = codeVerifier;
        String stateValue = this.getCurrentState(true);
        String authUrl = this.getQueryParamUrl(tokenGroup, codeChallenge, stateValue);
        iMedNetAuthUi.openBrowser(authUrl);
        LoggerFactory.getLogger(this.getClass()).info("Browser opened with URL: {}", (Object)authUrl);
        Object value = iMedNetAuthUi.getWithCancelableProgress(Messages.MednetAuthService_browserAuthorizationPrompt, new GetAuthCodeWithStateSupplier(stateValue));
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        LoggerFactory.getLogger(this.getClass()).warn("No authorization code received.");
        return Optional.empty();
    }

    private String getQueryParamUrl(String tokenGroup, String codeChallenge, String stateValue) {
        String oauthRestUrl = this.getOauthRestUrl();
        if (!oauthRestUrl.endsWith("/")) {
            oauthRestUrl = String.valueOf(oauthRestUrl) + "/";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(oauthRestUrl);
        sb.append("connect/authorize?");
        sb.append("response_type=code");
        sb.append("&client_id=").append(URLEncoder.encode(this.getClientId(), StandardCharsets.UTF_8));
        sb.append("&redirect_uri=").append(URLEncoder.encode(this.getRedirectUri(), StandardCharsets.UTF_8));
        sb.append("&scope=").append(URLEncoder.encode("openid profile mednet-web is-api email role offline_access", StandardCharsets.UTF_8));
        sb.append("&state=").append(URLEncoder.encode(stateValue, StandardCharsets.UTF_8));
        sb.append("&code_challenge=").append(URLEncoder.encode(codeChallenge, StandardCharsets.UTF_8));
        sb.append("&code_challenge_method=S256");
        sb.append("&login_hint=").append(URLEncoder.encode(this.getLoginHint(), StandardCharsets.UTF_8));
        LoggerFactory.getLogger(this.getClass()).info("Authorization URL: {}", (Object)sb.toString());
        return sb.toString();
    }

    private String getLoginHint() {
        if (this.configService == null) {
            throw new IllegalStateException("IConfigService ist nicht initialisiert.");
        }
        String userName = this.configService.getActiveUserContact("MedNetUserStringPreference", "");
        if (userName == null || userName.trim().isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).warn("Kein Login-Hinweis in den Einstellungen gefunden.");
        } else {
            LoggerFactory.getLogger(this.getClass()).info("Login-Hinweis abgerufen: {}", (Object)userName);
        }
        return userName;
    }

    private Optional<String> getAccessToken(String tokenGroup, String authCode, String oauthRestUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "authorization_code");
        parameters.put("code", authCode);
        parameters.put("redirect_uri", this.getRedirectUri());
        parameters.put("client_id", this.getClientId());
        parameters.put("client_secret", this.getClientSecret());
        parameters.put("code_verifier", this.currentCodeVerifier);
        String form = parameters.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.buildTokenEndpoint(oauthRestUrl))).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                Gson gson = new Gson();
                Map map = (Map)gson.fromJson(response.body(), Map.class);
                String token = (String)map.get("access_token");
                this.configService.setActiveMandator("mednet/auth/token/" + tokenGroup, token);
                String refreshToken = (String)map.get("refresh_token");
                if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
                    this.configService.setActiveMandator("mednet/auth/refreshtoken/" + tokenGroup, refreshToken);
                }
                Double expiresInSeconds = (Double)map.get("expires_in");
                Long expires = System.currentTimeMillis() + expiresInSeconds.longValue() * 1000L;
                this.configService.setActiveMandator("mednet/auth/tokenexpires/" + tokenGroup, Long.toString(expires));
                LoggerFactory.getLogger(this.getClass()).info("Got access token for [{}] expires [{}]", (Object)tokenGroup, (Object)expires);
                return Optional.of(token);
            }
            LoggerFactory.getLogger(this.getClass()).error("Getting access token failed [{} {}]", (Object)response.statusCode(), (Object)response.body());
        }
        catch (IOException | InterruptedException e2) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting access token", (Throwable)e2);
        }
        return Optional.empty();
    }

    private String generateCodeVerifier() {
        byte[] code = new byte[64];
        new Random().nextBytes(code);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(code).substring(0, 43);
    }

    private String generateCodeChallenge(String codeVerifier) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 Algorithm not available.", e);
        }
    }

    private String getRedirectUri() {
        return "https://tools.medelexis.ch/mednet/ac";
    }

    private String getCurrentState(boolean refresh) {
        if (refresh) {
            this.currentState = UUID.randomUUID().toString();
        }
        return this.currentState;
    }

    private String getClientId() {
        String mode = this.configService.getActiveUserContact("mednet_mode", "DEMO");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    if ("PRODUKTIV".equals(mode)) {
                        return idProps.getProperty("client_id_prod");
                    }
                    return idProps.getProperty("client_id_demo");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return "";
    }

    private String getClientSecret() {
        String mode = this.configService.getActiveUserContact("mednet_mode", "DEMO");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    if ("PRODUKTIV".equals(mode)) {
                        return idProps.getProperty("client_secret_prod");
                    }
                    return idProps.getProperty("client_secret_demo");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return "";
    }

    private Optional<String> validateToken(String existingToken, String tokenGroup) {
        String tokenExpires = this.configService.getActiveMandator("mednet/auth/tokenexpires/" + tokenGroup, null);
        String refreshToken = this.configService.getActiveMandator("mednet/auth/refreshtoken/" + tokenGroup, null);
        if (StringUtils.isNotBlank((CharSequence)existingToken) && StringUtils.isNotBlank((CharSequence)tokenExpires)) {
            try {
                long expires = Long.parseLong(tokenExpires);
                if (System.currentTimeMillis() < expires) {
                    return Optional.of(existingToken);
                }
            }
            catch (NumberFormatException expires) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)refreshToken)) {
            Optional<String> refreshed = this.getAccessTokenWithRefresh(tokenGroup, refreshToken, this.getOauthRestUrl());
            if (refreshed.isPresent()) {
                return refreshed;
            }
            this.configService.setActiveMandator("mednet/auth/refreshtoken/" + tokenGroup, null);
        }
        this.configService.setActiveMandator("mednet/auth/token/" + tokenGroup, null);
        this.configService.setActiveMandator("mednet/auth/tokenexpires/" + tokenGroup, null);
        return Optional.empty();
    }

    @Override
    public Optional<String> handleException(Exception ex, Map<String, Object> parameters) {
        if (ex.getMessage().contains("HTTP response code: 401")) {
            String tokenGroup = (String)parameters.get("token_group");
            LoggerFactory.getLogger(this.getClass()).info("Got HTTP 401 invalidating token for [{}]", (Object)tokenGroup);
            this.configService.setActiveMandator("mednet/auth/token/" + tokenGroup, null);
            this.configService.setActiveMandator("mednet/auth/tokenexpires/" + tokenGroup, null);
            return Optional.of("HIN oAuth token f\u00fcr [" + tokenGroup + "] ist nicht mehr g\u00fcltig.");
        }
        return Optional.empty();
    }

    private String buildTokenEndpoint(String base) {
        if (!base.endsWith("/")) {
            base = String.valueOf(base) + "/";
        }
        return String.valueOf(base) + "connect/token";
    }
}

