/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.medics.v2.dbcheck;

import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.LabItem;
import ch.elexis.data.Query;
import ch.elexis.labor.medics.v2.labimport.PatientLabor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class UpdateLabItemCode
extends ExternalMaintenance {
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        List<LabItem> items = this.getLabItems();
        pm.beginTask(String.valueOf(this.getMaintenanceDescription()) + " Lade Methodenstamm", -1);
        Map<String, String> nameToCodeMap = this.getNameToCodeMap();
        pm.beginTask(String.valueOf(this.getMaintenanceDescription()) + " (" + items.size() + " Medics Parameter) (" + nameToCodeMap.size() + " Medics Methodenstamm)", items.size());
        int updated = 0;
        int already = 0;
        int notfound = 0;
        for (LabItem item : items) {
            String code = nameToCodeMap.get(item.getName());
            if (code != null) {
                if (code.equals(item.getKuerzel())) {
                    ++already;
                    continue;
                }
                item.setKuerzel(code);
                ++updated;
                continue;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("No code found for medics item " + item.getLabel());
            ++notfound;
        }
        ConfigServiceHolder.setGlobal((String)"ch.elexis.laborimport.medics.v2.dbcheck.UpdateLabItemCode", (String)("done_" + LocalDateTime.now()));
        return "In " + items.size() + " Medics Parametern wurden " + updated + " angepasst, " + already + " waren bereits richtig und " + notfound + " konnte in " + nameToCodeMap.size() + " Methoden nicht gefunden werden.";
    }

    private Map<String, String> getNameToCodeMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ExcelWrapper exw = new ExcelWrapper();
        if (exw.load(((Object)((Object)this)).getClass().getResourceAsStream("/rsc/codes/methodenstamm_20200131.xlsx"), 0)) {
            int firstRow;
            exw.setFieldTypes(new Class[]{String.class, String.class});
            int lastRow = exw.getLastRow();
            int i = firstRow = exw.getFirstRow() + 1;
            while (i <= lastRow) {
                List row = exw.getRow(i);
                ret.put((String)row.get(1), (String)row.get(0));
                ++i;
            }
        }
        return ret;
    }

    private List<LabItem> getLabItems() {
        Query qli = new Query(LabItem.class);
        qli.add("Gruppe", "=", PatientLabor.LABOR_NAME);
        return qli.execute();
    }

    public String getMaintenanceDescription() {
        return "K\u00fcrzel der Medics Labor Parameter aus Methodenstamm setzen.";
    }

    public static boolean wasExecuted() {
        return ConfigServiceHolder.getGlobal((String)"ch.elexis.laborimport.medics.v2.dbcheck.UpdateLabItemCode", null) != null;
    }

    public static void execute() {
        Display display = Display.getDefault();
        display.syncExec(() -> {
            Shell activeshell = display.getActiveShell();
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(activeshell);
            try {
                progressDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        UpdateLabItemCode update = new UpdateLabItemCode();
                        String result = update.executeMaintenance(monitor, "");
                        LoggerFactory.getLogger(UpdateLabItemCode.class).info("LabItems update result:" + result);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                MessageDialog.openError((Shell)activeshell, (String)"Medics Importer", (String)"Fehler beim Update der Labor Parameter");
                LoggerFactory.getLogger(UpdateLabItemCode.class).error("Error on LabItems update", (Throwable)e);
            }
        });
    }
}

