/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.util;

import ch.rgw.io.FileTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MedicsLogger {
    private final String LOG_FILENAMEPATH = String.valueOf(System.getProperty("user.home")) + File.separator + "elexis" + File.separator + "medics.log";
    private PrintStream log;
    private static MedicsLogger logger = null;
    private String insetStr = "";

    public static MedicsLogger getLogger() {
        if (logger == null) {
            logger = new MedicsLogger();
        }
        return logger;
    }

    public MedicsLogger() {
        this.initLogger();
    }

    private void initLogger() {
        try {
            this.log = new PrintStream(new FileOutputStream(this.LOG_FILENAMEPATH, true));
        }
        catch (FileNotFoundException e) {
            this.log = System.out;
        }
    }

    public void println(String s) {
        this.log.println(String.valueOf(this.insetStr) + s);
    }

    public void print(String s) {
        this.log.print(String.valueOf(this.insetStr) + s);
    }

    public void addInset() {
        this.insetStr = String.valueOf(this.insetStr) + "   ";
    }

    public void removeInset() {
        if (this.insetStr.length() > 0) {
            this.insetStr = this.insetStr.substring(0, this.insetStr.length() - 3);
        }
    }

    public String getContent() {
        String content = "-";
        try {
            content = FileTool.readTextFile((File)new File(this.LOG_FILENAMEPATH));
        }
        catch (IOException e) {
            content = e.getMessage();
        }
        return content;
    }

    public void deleteLog() throws IOException {
        this.log.close();
        new File(this.LOG_FILENAMEPATH).delete();
        new File(this.LOG_FILENAMEPATH).createNewFile();
        this.initLogger();
    }

    protected void finalize() throws Throwable {
        if (this.log != null) {
            this.log.close();
        }
    }
}

