/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2.labimport;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.hl7.model.EncapsulatedData;
import ch.elexis.hl7.model.StringData;
import ch.elexis.hl7.model.TextData;
import ch.elexis.labor.medics.v2.MedicsPreferencePage;
import ch.elexis.labor.medics.v2.Messages;
import ch.rgw.io.FileTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;

public class PatientLabor {
    public static String KUERZEL = Messages.PatientLabor_kuerzelMedics;
    public static String LABOR_NAME = Messages.PatientLabor_nameMedicsLabor;
    private Labor myLab = null;
    private final Patient patient;
    private IDocumentManager docManager;

    public PatientLabor(Patient patient) {
        this.patient = patient;
        this.initLabor();
        this.initDocumentManager();
    }

    private void initDocumentManager() {
        Object os = Extensions.findBestService((String)"DocumentManagement");
        if (os != null) {
            this.docManager = (IDocumentManager)os;
        }
    }

    private void checkCreateCategory(String category) {
        if (category != null) {
            boolean catExists = false;
            String[] stringArray = this.docManager.getCategories();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                if (category.equals(cat)) {
                    catExists = true;
                }
                ++n2;
            }
            if (!catExists) {
                this.docManager.addCategorie(category);
            }
        }
    }

    private boolean addDocument(String title, String category, String dateStr, File file) throws IOException, ElexisException {
        this.checkCreateCategory(category);
        List documentList = this.docManager.listDocuments(this.patient, category, title, null, new TimeSpan(String.valueOf(dateStr) + "-" + dateStr), null);
        if (documentList == null || documentList.size() == 0) {
            this.docManager.addDocument((IOpaqueDocument)new GenericDocument(this.patient, title, category, file, dateStr, null, null));
            return true;
        }
        return false;
    }

    private void initLabor() {
        Query qbe = new Query(Labor.class);
        qbe.add("Kuerzel", "LIKE", "%" + KUERZEL + "%");
        List list = qbe.execute();
        this.myLab = list.size() < 1 ? new Labor(KUERZEL, LABOR_NAME) : (Labor)list.get(0);
    }

    private LabItem getLabItem(String kuerzel, LabItemTyp type) {
        Query qli = new Query(LabItem.class);
        qli.add("kuerzel", "=", kuerzel);
        qli.and();
        qli.add("LaborID", "=", this.myLab.get("ID"));
        qli.and();
        qli.add("Typ", "=", new Integer(type.ordinal()).toString());
        LabItem labItem = null;
        List itemList = qli.execute();
        if (itemList.size() > 0) {
            labItem = (LabItem)itemList.get(0);
        }
        return labItem;
    }

    private LabResult getLabResult(LabItem labItem, String name, TimeTool date) {
        Query qli = new Query(LabResult.class);
        qli.add("ItemID", "=", labItem.getId());
        qli.and();
        qli.add("Datum", "=", date.toDBString(false));
        qli.and();
        qli.add("PatientID", "=", this.patient.getId());
        LabResult labResult = null;
        List resultList = qli.execute();
        if (resultList.size() > 0) {
            labResult = (LabResult)resultList.get(0);
        }
        return labResult;
    }

    public void addLaborItem(StringData data) {
        LabItem labItem = this.getLabItem(data.getName(), LabItemTyp.NUMERIC);
        if (labItem == null) {
            String sequence;
            String group = data.getGroup();
            if (group == null || group.length() == 0) {
                group = LABOR_NAME;
            }
            if ((sequence = data.getSequence()) == null || sequence.length() == 0) {
                sequence = "50";
            }
            labItem = new LabItem(data.getName(), data.getName(), (Kontakt)this.myLab, null, null, data.getUnit(), LabItemTyp.NUMERIC, group, sequence);
        }
        if ("m".equals(this.patient.getGeschlecht())) {
            String newRefMann;
            String labRefMann = labItem.getRefM();
            if ((labRefMann == null || labRefMann.length() == 0) && (newRefMann = data.getRange()) != null && newRefMann.length() > 0) {
                labItem.setRefM(newRefMann);
            }
        } else {
            String newRefFrau;
            String labRefFrau = labItem.getRefW();
            if ((labRefFrau == null || labRefFrau.length() == 0) && (newRefFrau = data.getRange()) != null && newRefFrau.length() > 0) {
                labItem.setRefW(newRefFrau);
            }
        }
        TimeTool dateTime = new TimeTool();
        dateTime.setTime(data.getDate());
        LabResult lr = new LabResult(this.patient, dateTime, labItem, data.getValue(), data.getComment());
        lr.set("Quelle", LABOR_NAME);
    }

    public void addLaborItem(TextData data) {
        LabItem labItem = this.getLabItem(data.getName(), LabItemTyp.TEXT);
        if (labItem == null) {
            String sequence;
            String group = data.getGroup();
            if (group == null || group.length() == 0) {
                group = LABOR_NAME;
            }
            if ((sequence = data.getSequence()) == null || sequence.length() == 0) {
                sequence = "50";
            }
            labItem = new LabItem(data.getName(), data.getName(), (Kontakt)this.myLab, null, null, "", LabItemTyp.TEXT, group, sequence);
        }
        TimeTool dateTime = new TimeTool();
        dateTime.setTime(data.getDate());
        LabResult lr = this.getLabResult(labItem, data.getName(), dateTime);
        if (lr != null) {
            if (lr.getComment().indexOf(data.getText()) < 0) {
                lr.set("Kommentar", String.valueOf(lr.getComment()) + "\n-----------\n\n" + data.getText());
            }
        } else {
            lr = new LabResult(this.patient, dateTime, labItem, "Text", data.getText());
        }
        lr.set("Quelle", LABOR_NAME);
    }

    public void addDocument(EncapsulatedData data) throws IOException {
        if (this.docManager == null) {
            throw new IOException(MessageFormat.format(Messages.PatientLabor_errorKeineDokumentablage, data.getName(), this.patient.getLabel()));
        }
        String category = MedicsPreferencePage.getDokumentKategorie();
        this.checkCreateCategory(category);
        String downloadDir = MedicsPreferencePage.getDownloadDir();
        File tmpDir = new File(String.valueOf(downloadDir) + File.separator + "tmp");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException(MessageFormat.format(Messages.PatientLabor_errorCreatingTmpDir, tmpDir.getName()));
        }
        String filename = data.getName();
        File tmpPdfFile = new File(String.valueOf(downloadDir) + File.separator + "tmp" + File.separator + filename);
        tmpPdfFile.deleteOnExit();
        FileTool.writeFile((File)tmpPdfFile, (byte[])data.getData());
        TimeTool dateTime = new TimeTool();
        dateTime.setTime(data.getDate());
        String dateTimeStr = dateTime.toString(4);
        try {
            this.addDocument(filename, category, dateTimeStr, tmpPdfFile);
            String kuerzel = "doc";
            LabItem labItem = this.getLabItem(kuerzel, LabItemTyp.DOCUMENT);
            if (labItem == null) {
                String sequence;
                String group = data.getGroup();
                if (group == null || group.length() == 0) {
                    group = LABOR_NAME;
                }
                if ((sequence = data.getSequence()) == null || sequence.length() == 0) {
                    sequence = "50";
                }
                labItem = new LabItem(kuerzel, Messages.PatientLabor_nameDokumentLaborParameter, (Kontakt)this.myLab, "", "", FileTool.getExtension((String)filename), LabItemTyp.DOCUMENT, group, sequence);
            }
            LabResult lr = new LabResult(this.patient, dateTime, labItem, filename, data.getComment());
            lr.set("Quelle", LABOR_NAME);
        }
        catch (ElexisException e) {
            throw new IOException(MessageFormat.format(Messages.PatientLabor_errorAddingDocument, tmpPdfFile.getName()), e);
        }
    }
}

