/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.eurolyser.ui;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.laborimport.eurolyser.EurolyserImporter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabImportPage
extends ImporterPage {
    private static Logger logger = LoggerFactory.getLogger(LabImportPage.class);
    private ILaboratory eurolyserLabor = LabImportUtilHolder.get().getOrCreateLabor("Eurolyser");
    private Shell parentShell;
    private File archiveDir;

    public String getTitle() {
        return "Eurolyser";
    }

    public List<String> getObjectClass() {
        return Arrays.asList(ILabResult.class.getName(), "ch.elexis.omnivore.model.IDocumentHandle");
    }

    public String getDescription() {
        return "Bitte w\u00e4hlen Sie ein Verzeichnis mit Dateien im Eurolyser-Format f\u00fcr den Import aus";
    }

    public Composite createPage(Composite parent) {
        this.parentShell = parent.getShell();
        ImporterPage.DirectoryBasedImporter ret = new ImporterPage.DirectoryBasedImporter(parent, (ImporterPage)this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return ret;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        String dirname = this.results[0];
        List<File> files = this.getEurolyserFiles(dirname);
        monitor.beginTask("Eurolyser import.", files.size());
        for (File file : files) {
            try {
                EurolyserImporter importer = new EurolyserImporter(this.eurolyserLabor, file);
                if (importer.createResults()) {
                    this.archiveFile(file);
                }
                monitor.worked(1);
            }
            catch (IllegalStateException e) {
                this.parentShell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)LabImportPage.this.parentShell, (String)"Fehler", (String)("Die Datei konnte nicht eingelesen werden.\n[" + e.getLocalizedMessage() + "]"));
                    }
                });
            }
        }
        ElexisEventDispatcher.reload(LabItem.class);
        return Status.OK_STATUS;
    }

    private List<File> getEurolyserFiles(String dirname) {
        File[] list;
        ArrayList<File> ret = new ArrayList<File>();
        File dir = new File(dirname);
        File[] fileArray = list = dir.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isEurolyserFile(file)) {
                ret.add(file);
            }
            ++n2;
        }
        if (!ret.isEmpty()) {
            this.archiveDir = this.createArchiveDir(dir);
        }
        return ret;
    }

    private File createArchiveDir(File dir) {
        File ret = new File(dir, "archiv");
        if (!ret.exists()) {
            ret.mkdir();
        }
        return ret;
    }

    private void archiveFile(File file) {
        String prefix = "";
        while (!file.renameTo(new File(this.archiveDir, String.valueOf(prefix) + file.getName()))) {
            prefix = String.valueOf(prefix) + "_";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEurolyserFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(file);){
                byte[] buffer = new byte[256];
                int len = input.read(buffer);
                if (len > 30) {
                    String[] parts;
                    ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(bis));
                    String line = reader.readLine().trim();
                    if (line != null && !line.isEmpty() && (parts = line.split(";")).length == 5) {
                        reader.close();
                        return true;
                    }
                    reader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.warn("File [" + file.getAbsolutePath() + "] is not in eurolyser format.");
        return false;
    }
}

