/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.ui;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.ui.service.AeskulapImporterServiceHolder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class AeskulapImporter
extends ImporterPage {
    private boolean overwrite = false;
    private boolean keepPatientNumber = true;

    public String getTitle() {
        return "Aeskulap";
    }

    public List<String> getObjectClass() {
        return Arrays.asList(IPatient.class.getName(), ILabResult.class.getName(), ILabItem.class.getName(), IContact.class.getName(), IDocumentLetter.class.getName());
    }

    public String getDescription() {
        return "Datenimport Aeskulap";
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        String filename = this.results[0];
        if (StringUtils.isBlank((CharSequence)filename)) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Verzeichnis ausgew\u00e4hlt."));
            return new Status(4, "ch.elexis", "No file given");
        }
        File directory = new File(filename);
        if (!directory.exists() || !directory.isDirectory()) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Das Verzeichnis " + filename + " existiert nicht, oder ist kein Verzeichnis.")));
            return new Status(4, "ch.elexis", "Invalid file given");
        }
        List files = AeskulapImporterServiceHolder.get().setImportDirectory(directory);
        if (!files.isEmpty()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
            System.setProperty("aeskulap.keepPatientNumber", Boolean.toString(this.keepPatientNumber));
            List problems = AeskulapImporterServiceHolder.get().importFiles(files, this.overwrite, subMonitor);
            if (problems.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                files.stream().filter(af -> af.getType() != IAeskulapImportFile.Type.LETTERDIRECTORY).forEach(f -> {
                    StringBuilder stringBuilder2 = sb.append(String.valueOf(f.getFile().getName()) + "\n");
                });
                Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)("Die Dateien\n\n" + sb.toString() + "\nwurden erfolgreich importiert.")));
            } else {
                StringBuilder sb = new StringBuilder();
                problems.stream().filter(af -> af.getType() != IAeskulapImportFile.Type.LETTERDIRECTORY).forEach(f -> {
                    StringBuilder stringBuilder2 = sb.append(String.valueOf(f.getFile().getName()) + "\n");
                });
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Bei folgenden Dateien\n\n" + sb.toString() + "\nist ein Problem aufgetreten.")));
            }
        } else {
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)("Im Verzeichnis " + filename + " wurden keine Dateien zum Import gefunden.")));
        }
        return Status.OK_STATUS;
    }

    public Composite createPage(Composite parent) {
        ImporterPage.DirectoryBasedImporter fbi = new ImporterPage.DirectoryBasedImporter(parent, (ImporterPage)this);
        fbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        final Button overwriteBtn = new Button((Composite)fbi, 32);
        overwriteBtn.setText("Bereits importierte Daten \u00fcberschreiben.");
        overwriteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AeskulapImporter.this.overwrite = overwriteBtn.getSelection();
            }
        });
        overwriteBtn.setSelection(this.overwrite);
        Button keepPatientNumberBtn = new Button((Composite)fbi, 32);
        keepPatientNumberBtn.setText("Patientennummer aus csv \u00fcbernehmen.");
        keepPatientNumberBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AeskulapImporter.this.keepPatientNumber = overwriteBtn.getSelection();
            }
        });
        keepPatientNumberBtn.setSelection(this.keepPatientNumber);
        Button removeDuplicatesBtn = new Button((Composite)fbi, 8);
        removeDuplicatesBtn.setText("Patienten Duplikate entfernen");
        removeDuplicatesBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Shell parentShell = Display.getDefault().getActiveShell();
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(parentShell);
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            AeskulapImporterServiceHolder.get().removePatientDuplicates(monitor);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)parentShell, (String)"Patienten Duplikate entfernen", (String)"Fehler beim erzeugen der strukturierten Diagnosen.");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error removing duplicate patients", (Throwable)e);
                }
            }
        });
        return fbi;
    }
}

