/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.data.Anschrift;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class PatientFile
extends AbstractCsvImportFile<Patient>
implements IAeskulapImportFile {
    private File file;
    private int highestPatNr = 0;
    private IAeskulapImportFile mandatorFile;

    public PatientFile(File file) {
        super(file);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line.length > 0 && line[0].equalsIgnoreCase("pat_no");
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Patienten");
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Patienten Import", this.getLineCount());
        try {
            this.mandatorFile = transientFiles.get((Object)IAeskulapImportFile.Type.MANDATOR);
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                Patient patient = (Patient)this.getExisting(line[0]);
                if (patient == null) {
                    patient = this.create(line);
                } else if (!overwrite) continue;
                this.setProperties(patient, line);
                monitor.worked(1);
            }
            return true;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", (Throwable)e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.PATIENT;
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/PatID";
    }

    @Override
    public Patient create(String[] line) {
        TimeTool tt = new TimeTool(line[12]);
        String gender = line[13].equals("1") ? "m" : "w";
        Patient patient = new Patient(line[2], line[3], tt.toString(4), gender);
        if (Boolean.getBoolean("aeskulap.keepPatientNumber")) {
            this.updatePatientNumber(patient, Integer.parseInt(line[0]));
        }
        return patient;
    }

    @Override
    public void setProperties(Patient patient, String[] line) {
        Anschrift an = patient.getAnschrift();
        an.setStrasse(line[5]);
        an.setPlz(line[6]);
        an.setOrt(line[7]);
        patient.setAnschrift(an);
        if (this.mandatorFile != null) {
            patient.set("Gruppe", (String)this.mandatorFile.getTransient(line[8]));
        }
        patient.set("Telefon1", line[18]);
        patient.set("Telefon2", line[17]);
        patient.set("NatelNr", line[19]);
        patient.set("E-Mail", line[20]);
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)line[21])) {
            sb.append("Verstorben: ").append(line[21]).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)line[14])) {
            sb.append("Kommentar: ").append(line[14]).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)line[15])) {
            sb.append("Warnung: ").append(line[15]).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)line[11])) {
            sb.append("Beruf: ").append(line[11]).append("\n");
        }
        patient.setBemerkung(sb.toString());
        if (!StringUtils.isBlank((CharSequence)line[22])) {
            patient.addXid("www.ahv.ch/xid", line[22], true);
        }
        patient.addXid(this.getXidDomain(), line[0], true);
    }

    private void updatePatientNumber(Patient patient, Integer patNr) {
        String lockid = PersistentObject.lock((String)"PatNummer", (boolean)true);
        String pid = PersistentObject.getDefaultConnection().queryString("SELECT WERT FROM CONFIG WHERE PARAM='PatientNummer'");
        int currNum = Integer.parseInt(pid);
        if (this.highestPatNr == 0) {
            this.highestPatNr = currNum;
        }
        if (patNr + 1 > this.highestPatNr) {
            this.highestPatNr = patNr + 1;
        }
        PersistentObject.getDefaultConnection().exec("UPDATE CONFIG set wert='" + this.highestPatNr + "', lastupdate=" + Long.toString(System.currentTimeMillis()) + " where param='PatientNummer'");
        PersistentObject.unlock((String)"PatNummer", (String)lockid);
        patient.set("PatientNr", patNr.toString());
    }
}

