/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.data.Kontakt;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class CoverageGarant
extends AbstractCsvImportFile<Kontakt>
implements IAeskulapImportFile {
    private File file;
    private CoverageGarant garant;
    private Map<String, String[]> garantKurzBezMap;

    public CoverageGarant(File file) {
        super(file);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line.length > 1 && line[1] != null && line[1].equalsIgnoreCase("GARANT_NO");
    }

    @Override
    public Kontakt create(String[] line) {
        throw new IllegalStateException();
    }

    private void init() {
        this.garantKurzBezMap = new HashMap<String, String[]>();
        try {
            try {
                String[] line = null;
                while ((line = this.getNextLine()) != null) {
                    this.garantKurzBezMap.put(line[0], line);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error importing file", (Throwable)e);
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    public String[] getGuarantLine(String garKurzBez) {
        if (this.garantKurzBezMap == null) {
            this.init();
        }
        return this.garantKurzBezMap.get(garKurzBez);
    }

    @Override
    public void setProperties(Kontakt contact, String[] line) {
        throw new IllegalStateException();
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        return false;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.COVERAGE;
    }

    @Override
    public String getXidDomain() {
        throw new IllegalStateException();
    }
}

