/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.services.holder.BillingSystemServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.CoverageGarant;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class CoverageFile
extends AbstractCsvImportFile<Fall>
implements IAeskulapImportFile {
    private File file;
    private CoverageGarant coverageGarant;

    public CoverageFile(File file) {
        super(file);
        this.file = file;
        File[] garantFile = file.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals("garant.csv");
            }
        });
        if (garantFile.length <= 0) {
            throw new IllegalStateException("Could not find garant.csv in [" + file.getParentFile() + "]");
        }
        this.coverageGarant = new CoverageGarant(garantFile[0]);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Pat_Garanten");
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line.length > 1 && line[1] != null && line[1].equalsIgnoreCase("GAR_KURZBEZ");
    }

    @Override
    public Fall create(String[] line) {
        Patient patient = (Patient)this.getWithXid("elexis.ch/aeskulap_import/PatID", line[0]);
        if (patient == null) {
            LoggerFactory.getLogger(this.getClass()).error("Could not find patient_no (Patient) [" + line[0] + "]");
            return null;
        }
        ICoverage coverage = (ICoverage)new ICoverageBuilder(CoreModelServiceHolder.get(), ConfigServiceHolder.get(), BillingSystemServiceHolder.get(), patient.toIPatient()).build();
        Optional<IOrganization> guarantor = this.getGuarantor(line[1]);
        if (guarantor.isPresent()) {
            coverage.setGuarantor((IContact)guarantor.get());
            coverage.setCostBearer((IContact)guarantor.get());
        }
        CoreModelServiceHolder.get().save((Identifiable)coverage);
        return Fall.load((String)coverage.getId());
    }

    private Optional<IBillingSystem> getBillingSystem(String string) {
        if (StringUtils.isEmpty((CharSequence)string) || string.toLowerCase().startsWith("g")) {
            return BillingSystemServiceHolder.get().getBillingSystem("KVG");
        }
        if (StringUtils.isNotEmpty((CharSequence)string) && string.toLowerCase().startsWith("u")) {
            return BillingSystemServiceHolder.get().getBillingSystem("UVG");
        }
        if (StringUtils.isNotEmpty((CharSequence)string) && string.toLowerCase().startsWith("z")) {
            return BillingSystemServiceHolder.get().getBillingSystem("VVG");
        }
        return Optional.empty();
    }

    private Optional<IOrganization> getGuarantor(String garKurzBez) {
        String[] guarantLine = this.coverageGarant.getGuarantLine(garKurzBez);
        if (guarantLine != null) {
            List found;
            List found2;
            String ean = guarantLine[17];
            if (StringUtils.isNotBlank((CharSequence)ean) && (found2 = XidServiceHolder.get().findObjects("www.xid.ch/id/ean", ean, IOrganization.class)).size() > 0) {
                return Optional.of((IOrganization)found2.get(0));
            }
            String bsv = guarantLine[20];
            if (StringUtils.isNotBlank((CharSequence)bsv) && (found = XidServiceHolder.get().findObjects("www.xid.ch/id/kknum", bsv, IOrganization.class)).size() > 0) {
                return Optional.of((IOrganization)found.get(0));
            }
        }
        return Optional.empty();
    }

    private void updateBillingSystem(IBillingSystem system) {
        if (system != null) {
            String optionals;
            String requirements = BillingSystemServiceHolder.get().getRequirements(system);
            if (!requirements.contains("Versicherungsnummer:T")) {
                requirements = StringUtils.isBlank((CharSequence)requirements) ? "Versicherungsnummer:T" : String.valueOf(requirements) + ";Versicherungsnummer:T";
                BillingSystemServiceHolder.get().addOrModifyBillingSystem(system.getName(), system.getLaw().toString(), system.getName(), requirements, system.getLaw());
            }
            if (!(optionals = StringUtils.defaultString((String)BillingSystemServiceHolder.get().getOptionals(system))).contains("VEKANr:T")) {
                optionals = StringUtils.isBlank((CharSequence)optionals) ? "VEKANr:T" : this.appendWithoutDuplicateSeparator(optionals, "VEKANr:T");
                BillingSystemServiceHolder.get().addOrModifyBillingSystem(system.getName(), system.getLaw().toString(), system.getName(), BillingSystemServiceHolder.get().getRequirements(system), system.getLaw());
            }
        }
    }

    private String appendWithoutDuplicateSeparator(String current, String append) {
        if (current.endsWith(";")) {
            return String.valueOf(current) + append;
        }
        return String.valueOf(current) + ";" + append;
    }

    @Override
    public void setProperties(Fall fall, String[] line) {
        if (fall != null) {
            ICoverage coverage = (ICoverage)CoreModelServiceHolder.get().load(fall.getId(), ICoverage.class).orElseThrow(() -> new IllegalStateException("Could not convert coverage [" + fall.getId() + "]"));
            TimeTool insertedTime = new TimeTool(line[5]);
            this.getBillingSystem(line[4]).ifPresent(bs -> coverage.setBillingSystem(bs));
            coverage.setInsuranceNumber(line[3]);
            coverage.setDateFrom(insertedTime.toLocalDate());
            if (StringUtils.isNotBlank((CharSequence)line[9]) && line[9].startsWith("80")) {
                this.updateBillingSystem(coverage.getBillingSystem());
                coverage.setExtInfo((Object)"VEKANr", (Object)StringUtils.defaultIfBlank((CharSequence)line[9], (CharSequence)""));
                coverage.setExtInfo((Object)"VEKAValid", (Object)StringUtils.defaultIfBlank((CharSequence)line[10], (CharSequence)""));
            }
            fall.addXid(this.getXidDomain(), line[2], true);
            CoreModelServiceHolder.get().save((Identifiable)coverage);
        }
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap F\u00e4lle Import", this.getLineCount());
        try {
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                Fall fall = (Fall)this.getExisting(line[2]);
                if (fall == null) {
                    fall = this.create(line);
                } else if (!overwrite) continue;
                this.setProperties(fall, line);
                monitor.worked(1);
            }
            return true;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", (Throwable)e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.COVERAGE;
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/CoverageID";
    }
}

