/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.views.EncounterDisplay;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class EncounterView
extends ViewPart {
    public static final String ID = "ch.elexis.icpc.encounterView";
    private EncounterDisplay display;

    @Inject
    void activePatient(@Optional IPatient patient) {
        if (this.display != null && !this.display.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.display.setEncounter(null));
        }
    }

    @Inject
    void selectedEncounter(@Optional IcpcEncounter encounter) {
        if (this.display != null && !this.display.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.display.setEncounter(encounter));
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.display = new EncounterDisplay(parent);
        this.display.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
    }

    public void setFocus() {
        this.display.setFocus();
    }

    public void selectionEvent(PersistentObject obj) {
        if (obj instanceof IcpcEncounter) {
            this.display.setEncounter((IcpcEncounter)obj);
        } else if (obj instanceof Patient) {
            this.display.setEncounter(null);
        }
    }
}

