/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.model.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ICPCCode;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.internal.Messages;
import ch.elexis.icpc.model.internal.service.IcpcModelServiceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class Code
extends AbstractIdModelAdapter<ICPCCode>
implements Identifiable,
IcpcCode {
    public static final String[] classes = new String[]{Messages.IcpcCode_class_A, Messages.IcpcCode_class_B, Messages.IcpcCode_class_D, Messages.IcpcCode_class_F, Messages.IcpcCode_class_H, Messages.IcpcCode_class_K, Messages.IcpcCode_class_L, Messages.IcpcCode_class_N, Messages.IcpcCode_class_P, Messages.IcpcCode_class_R, Messages.IcpcCode_class_S, Messages.IcpcCode_class_T, Messages.IcpcCode_class_U, Messages.IcpcCode_class_W, Messages.IcpcCode_class_X, Messages.IcpcCode_class_Y, Messages.IcpcCode_class_Z};
    public static final String[] components = new String[]{Messages.IcpcCode_comp_1, Messages.IcpcCode_comp_2, Messages.IcpcCode_comp_3, Messages.IcpcCode_comp_4, Messages.IcpcCode_comp_5, Messages.IcpcCode_comp_6, Messages.IcpcCode_comp_7};
    public static final String CODESYSTEM_NAME = "ICPC";
    private static List<IDiagnosisTree> rootCodes;
    private IDiagnosisTree parent;

    public static List<IDiagnosisTree> getRootCodes() {
        if (rootCodes == null) {
            Code.initialize();
        }
        return rootCodes;
    }

    public Code(ICPCCode entity) {
        super((EntityWithId)entity);
        if (rootCodes == null) {
            Code.initialize();
        }
    }

    private static void initialize() {
        rootCodes = new ArrayList<IDiagnosisTree>();
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            TransientCode classCode = new TransientCode(string);
            rootCodes.add(classCode);
            String[] stringArray2 = components;
            int n3 = components.length;
            int n4 = 0;
            while (n4 < n3) {
                String comp = stringArray2[n4];
                TransientCode compCode = new TransientCode(comp);
                compCode.setParent(classCode);
                classCode.addChild(compCode);
                ++n4;
            }
            ++n2;
        }
    }

    public IDiagnosisTree getParent() {
        return this.parent;
    }

    public void setParent(IDiagnosisTree value) {
        this.parent = value;
    }

    public List<IDiagnosisTree> getChildren() {
        return Collections.emptyList();
    }

    public String getDescription() {
        return ((ICPCCode)this.getEntity()).getText();
    }

    public void setDescription(String value) {
        ((ICPCCode)this.getEntity()).setText(value);
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getCode() {
        return ((ICPCCode)this.getEntity()).getId();
    }

    public void setCode(String value) {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return ((ICPCCode)this.getEntity()).getShortName();
    }

    public void setText(String value) {
        ((ICPCCode)this.getEntity()).setShortName(value);
    }

    public String getLabel() {
        return String.valueOf(this.getId()) + " " + this.getText();
    }

    @Override
    public String getIcd10() {
        return ((ICPCCode)this.getEntity()).getIcd10();
    }

    @Override
    public void setIcd10(String value) {
        ((ICPCCode)this.getEntity()).setIcd10(value);
    }

    @Override
    public String getCriteria() {
        return ((ICPCCode)this.getEntity()).getCriteria();
    }

    @Override
    public void setCriteria(String value) {
        ((ICPCCode)this.getEntity()).setCriteria(value);
    }

    @Override
    public String getInclusion() {
        return ((ICPCCode)this.getEntity()).getInclusion();
    }

    @Override
    public void setInclusion(String value) {
        ((ICPCCode)this.getEntity()).setInclusion(value);
    }

    @Override
    public String getExclusion() {
        return ((ICPCCode)this.getEntity()).getExclusion();
    }

    @Override
    public void setExclusion(String value) {
        ((ICPCCode)this.getEntity()).setExclusion(value);
    }

    @Override
    public String getNote() {
        return ((ICPCCode)this.getEntity()).getNote();
    }

    @Override
    public void setNote(String value) {
        ((ICPCCode)this.getEntity()).setNote(value);
    }

    @Override
    public String getConsider() {
        return ((ICPCCode)this.getEntity()).getConsider();
    }

    @Override
    public void setConsider(String value) {
        ((ICPCCode)this.getEntity()).setConsider(value);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    private static class TransientCode
    implements IDiagnosisTree {
        private List<IDiagnosisTree> children;
        private IDiagnosisTree parent;
        private String code;
        private String text;

        public TransientCode(String string) {
            String[] parts = string.split(": ");
            this.code = parts[0];
            this.text = parts[1];
        }

        public void addChild(IDiagnosisTree diagnosis) {
            if (this.children == null) {
                this.children = new ArrayList<IDiagnosisTree>();
            }
            this.children.add(diagnosis);
        }

        public String getDescription() {
            return this.text;
        }

        public void setDescription(String value) {
            throw new UnsupportedOperationException();
        }

        public String getCodeSystemName() {
            return Code.CODESYSTEM_NAME;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String value) {
            throw new UnsupportedOperationException();
        }

        public String getText() {
            return this.text;
        }

        public void setText(String value) {
            throw new UnsupportedOperationException();
        }

        public String getId() {
            return this.code;
        }

        public String getLabel() {
            return String.valueOf(this.code) + ": " + this.text;
        }

        public boolean addXid(String domain, String id, boolean updateIfExists) {
            throw new UnsupportedOperationException();
        }

        public IXid getXid(String domain) {
            throw new UnsupportedOperationException();
        }

        public Long getLastupdate() {
            return 0L;
        }

        public IDiagnosisTree getParent() {
            return this.parent;
        }

        public void setParent(IDiagnosisTree value) {
            this.parent = value;
        }

        public List<IDiagnosisTree> getChildren() {
            if (NumberUtils.isCreatable((String)this.code) && this.children == null) {
                IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcCode.class);
                query.and("id", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.parent.getId()) + "%"));
                query.and("component", IQuery.COMPARATOR.EQUALS, (Object)this.getId());
                this.children = query.execute();
                this.children.forEach(c -> c.setParent((IDiagnosisTree)this));
                return this.children;
            }
            return this.children;
        }
    }
}

