/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.IQuery;
import ch.elexis.data.Konsultation;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.TConsultation;
import ch.elexis.icpc.fire.model.TDiagnose;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.elexis.icpc.model.icpc.IcpcEncounter;
import ch.elexis.icpc.model.icpc.IcpcPackage;
import ch.elexis.icpc.service.IcpcModelServiceHolder;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DiagnosesBuilder {
    private Konsultation consultation;
    private FireConfig config;

    public DiagnosesBuilder(FireConfig config) {
        this.config = config;
    }

    public DiagnosesBuilder consultation(Konsultation consultation) {
        this.consultation = consultation;
        return this;
    }

    public Optional<TConsultation.Diagnoses> build() {
        IEncounter encounter = CoreModelServiceHolder.get().load(this.consultation.getId(), IEncounter.class).orElse(null);
        IQuery query = IcpcModelServiceHolder.get().getQuery(IcpcEncounter.class);
        query.and((EStructuralFeature)IcpcPackage.Literals.ICPC_ENCOUNTER__ENCOUNTER, IQuery.COMPARATOR.EQUALS, (Object)encounter);
        List icpcEncounters = query.execute();
        if (!icpcEncounters.isEmpty()) {
            TConsultation.Diagnoses ret = this.config.getFactory().createTConsultationDiagnoses();
            for (IcpcEncounter enc : icpcEncounters) {
                IcpcCode reason;
                IcpcCode diag = enc.getDiag();
                if (diag != null) {
                    TDiagnose tDiag = this.config.getFactory().createTDiagnose();
                    tDiag.setIcpc(diag.getCode());
                    tDiag.setDescription(diag.getText());
                    ret.getDiagnose().add(tDiag);
                }
                if ((reason = enc.getRfe()) == null) continue;
                TDiagnose tReason = this.config.getFactory().createTDiagnose();
                tReason.setIcpc(reason.getCode());
                tReason.setDescription(reason.getText());
                ret.getReason().add(tReason);
            }
            if (!ret.getDiagnose().isEmpty()) {
                return Optional.of(ret);
            }
        }
        return Optional.empty();
    }
}

