/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.icpc.fire.handlers.ExportFireHandler;
import ch.elexis.icpc.fire.model.DiagnosesBuilder;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.LaborsBuilder;
import ch.elexis.icpc.fire.model.MedisBuilder;
import ch.elexis.icpc.fire.model.Report;
import ch.elexis.icpc.fire.model.TConsultation;
import ch.elexis.icpc.fire.model.TMedi;
import ch.elexis.icpc.fire.model.TVital;
import ch.elexis.icpc.fire.model.VitalSignsBuilder;
import ch.elexis.icpc.fire.model.XmlUtil;
import ch.rgw.tools.TimeTool;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import org.slf4j.LoggerFactory;

public class ConsultationBuilder {
    private Konsultation consultation;
    private VitalSignsBuilder vitalsignsBuilder;
    private DiagnosesBuilder diagnosesBuilder;
    private LaborsBuilder laborsBuilder;
    private MedisBuilder medisBuilder;
    private FireConfig config;

    public ConsultationBuilder(FireConfig config) {
        this.config = config;
        this.vitalsignsBuilder = new VitalSignsBuilder(config);
        this.diagnosesBuilder = new DiagnosesBuilder(config);
        this.laborsBuilder = new LaborsBuilder(config);
        this.medisBuilder = new MedisBuilder(config);
    }

    public ConsultationBuilder consultation(Konsultation consultation) {
        this.consultation = consultation;
        return this;
    }

    public Optional<TConsultation> build(Map<String, Set<TMedi>> unreferencedStopMedisPerPatient) throws DatatypeConfigurationException {
        if (this.consultation != null) {
            TConsultation ret = this.config.getFactory().createTConsultation();
            Optional<TVital> vital = this.vitalsignsBuilder.consultation(this.consultation).build();
            vital.ifPresent(v -> ret.setVital((TVital)v));
            Optional<TConsultation.Diagnoses> diagnoses = this.diagnosesBuilder.consultation(this.consultation).build();
            diagnoses.ifPresent(d -> ret.setDiagnoses((TConsultation.Diagnoses)d));
            Optional<TConsultation.Labors> labors = this.laborsBuilder.consultation(this.consultation).build();
            labors.ifPresent(l -> ret.setLabors((TConsultation.Labors)l));
            Optional<TConsultation.Medis> medis = this.medisBuilder.consultation(this.consultation).build(unreferencedStopMedisPerPatient);
            medis.ifPresent(m -> ret.setMedis((TConsultation.Medis)m));
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public static Map<String, Set<TMedi>> initializeUnreferencedStopMedisPerPatient(FireConfig config) throws DatatypeConfigurationException {
        HashMap<String, Set<TMedi>> unreferencedStopMedisPerPatient = new HashMap<String, Set<TMedi>>();
        Query qre = new Query(Prescription.class);
        qre.add("DateUntil", ">=", String.valueOf(ExportFireHandler.getTtFrom().toString(9)) + "%");
        qre.add("DateUntil", "<=", String.valueOf(ExportFireHandler.getTtTo().toString(9)) + "%");
        List execute = qre.execute();
        for (Prescription prescription : execute) {
            TMedi tMedi = MedisBuilder.createTMedi(prescription, config);
            String patientId = prescription.get("PatientID");
            HashSet<TMedi> unreferencedStoppedMedis = (HashSet<TMedi>)unreferencedStopMedisPerPatient.get(patientId);
            if (unreferencedStoppedMedis == null) {
                unreferencedStoppedMedis = new HashSet<TMedi>();
                unreferencedStopMedisPerPatient.put(patientId, unreferencedStoppedMedis);
            }
            unreferencedStoppedMedis.add(tMedi);
        }
        return unreferencedStopMedisPerPatient;
    }

    public void handleUnreferencedStopMedisPerPatient(FireConfig fireConfig, Report report, Map<String, Set<TMedi>> unreferencedStopMedisPerPatient) {
        Set<Map.Entry<String, Set<TMedi>>> entrySet = unreferencedStopMedisPerPatient.entrySet();
        Iterator<Map.Entry<String, Set<TMedi>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<TMedi>> entryByPatientId = iterator.next();
            String patientId = entryByPatientId.getKey();
            Set<TMedi> unreferencedStoppedMedis = entryByPatientId.getValue();
            if (!unreferencedStoppedMedis.isEmpty()) {
                Map<String, Set<TMedi>> groupByDate = this.groupUnreferencedStopMedisByDate(unreferencedStoppedMedis);
                Set<Map.Entry<String, Set<TMedi>>> entrySetGroupByDate = groupByDate.entrySet();
                for (Map.Entry<String, Set<TMedi>> entryForPatientByDate : entrySetGroupByDate) {
                    TConsultation pseudoTConsultation = fireConfig.getFactory().createTConsultation();
                    BigInteger patId = fireConfig.getPatId(Patient.load((String)patientId));
                    pseudoTConsultation.setPatId(patId);
                    pseudoTConsultation.setConsType("7");
                    try {
                        pseudoTConsultation.setDate(XmlUtil.getXmlGregorianCalendar(new TimeTool(entryForPatientByDate.getKey())));
                    }
                    catch (DatatypeConfigurationException e2) {
                        LoggerFactory.getLogger(ConsultationBuilder.class).warn("date error", (Throwable)e2);
                    }
                    TConsultation.Medis medis = new TConsultation.Medis();
                    Set<TMedi> entries = entryForPatientByDate.getValue();
                    Konsultation identifyingKons = entries.stream().filter(e -> e.getConsultation() != null).findFirst().map(e -> e.getConsultation()).orElse(null);
                    if (identifyingKons != null && identifyingKons.getMandant() != null) {
                        BigInteger docId = this.config.getDocId(identifyingKons.getMandant());
                        pseudoTConsultation.setDocId(docId);
                    }
                    medis.getMedi().addAll(entries);
                    pseudoTConsultation.setMedis(medis);
                    if (report.getConsultations() == null) {
                        report.setConsultations(fireConfig.getFactory().createReportConsultations());
                    }
                    report.getConsultations().getConsultation().add(pseudoTConsultation);
                }
            }
            iterator.remove();
        }
        assert (unreferencedStopMedisPerPatient.isEmpty());
    }

    private Map<String, Set<TMedi>> groupUnreferencedStopMedisByDate(Set<TMedi> unreferencedStoppedMedis) {
        HashMap<String, Set<TMedi>> group = new HashMap<String, Set<TMedi>>();
        for (TMedi tMedi : unreferencedStoppedMedis) {
            String date = tMedi.getEndDate().getYear() + String.format("%02d", tMedi.getEndDate().getMonth()) + String.format("%02d", tMedi.getEndDate().getDay());
            HashSet<TMedi> dateSet = (HashSet<TMedi>)group.get(date);
            if (dateSet == null) {
                dateSet = new HashSet<TMedi>();
                group.put(date, dateSet);
            }
            dateSet.add(tMedi);
        }
        return group;
    }
}

