/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.handlers;

import ch.elexis.core.data.interfaces.ISticker;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.elexis.icpc.fire.model.ConsultationBuilder;
import ch.elexis.icpc.fire.model.Report;
import ch.elexis.icpc.fire.model.ReportBuilder;
import ch.elexis.icpc.fire.model.TMedi;
import ch.elexis.icpc.fire.model.XmlUtil;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFireHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ExportFireHandler.class);
    public static final String FIRESTICKERNAME = "Fire (ICPC)";
    private Sticker fireSticker;

    public ExportFireHandler() {
        String id = new Query(Sticker.class).findSingle("Name", "=", FIRESTICKERNAME);
        if (id == null) {
            this.fireSticker = new Sticker(FIRESTICKERNAME, "0066CC", "C0C0C0");
            this.fireSticker.setClassForSticker(Konsultation.class);
        } else {
            this.fireSticker = Sticker.load((String)id);
        }
    }

    public static TimeTool getTtFrom() {
        TimeTool ttFrom = new TimeTool("20180101");
        String lastupdate = ConfigServiceHolder.getGlobal((String)"ICPC_FIRE_LAST_UPLOAD", null);
        if (lastupdate != null) {
            ttFrom = new TimeTool(lastupdate);
        }
        ttFrom.addHours(Report.EXPORT_DELAY * -1);
        return ttFrom;
    }

    public static TimeTool getTtTo() {
        TimeTool ttTo = new TimeTool();
        ttTo.addHours(Report.EXPORT_DELAY * -1);
        return ttTo;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Query qbe = new Query(Konsultation.class);
        qbe.add("Datum", ">", ExportFireHandler.getTtFrom().toString(9));
        qbe.add("Datum", "<=", ExportFireHandler.getTtTo().toString(9));
        qbe.orderBy(false, new String[]{"Datum"});
        List konsen = qbe.execute();
        if (konsen.size() > 0) {
            FileDialog fd = new FileDialog(Hub.getActiveShell(), 8192);
            fd.setFileName("elexis-fire" + new TimeTool().toString(9) + ".xml");
            fd.setFilterExtensions(new String[]{"xml"});
            fd.setFilterNames(new String[]{"XML-Dateien"});
            String expath = fd.open();
            if (expath != null) {
                ProgressMonitorDialog progress = new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                try {
                    progress.run(true, true, this.createReportExportRunnable(konsen, expath));
                }
                catch (InterruptedException | InvocationTargetException e) {
                    logger.warn("Exception during FIRE export", (Throwable)e);
                }
            }
        }
        return null;
    }

    public IRunnableWithProgress createReportExportRunnable(List<Konsultation> konsen, String expath) {
        return new ReportExportRunnable(konsen, expath);
    }

    private class ReportExportRunnable
    implements IRunnableWithProgress {
        private List<Konsultation> consultations;
        private String exportPath;

        public ReportExportRunnable(List<Konsultation> konsen, String expath) {
            this.consultations = konsen;
            this.exportPath = expath;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block19: {
                try {
                    monitor.beginTask("FIRE Export ", this.consultations.size() + 1);
                    int counter = 0;
                    ReportBuilder reportBuilder = new ReportBuilder();
                    if (reportBuilder.isValidConfig()) {
                        Map<String, Set<TMedi>> unreferencedStopMedisPerPatient = ConsultationBuilder.initializeUnreferencedStopMedisPerPatient(reportBuilder.getFireConfig());
                        for (Konsultation konsultation : this.consultations) {
                            Mandant mandant;
                            Patient pat;
                            if (monitor.isCanceled()) {
                                return;
                            }
                            monitor.setTaskName("FIRE exporting (" + ++counter + "/" + this.consultations.size() + ")");
                            Fall fall = konsultation.getFall();
                            if (fall == null || (pat = fall.getPatient()) == null || (mandant = konsultation.getMandant()) == null) continue;
                            if (!konsultation.getStickers().contains(ExportFireHandler.this.fireSticker)) {
                                try {
                                    BigInteger patId = reportBuilder.addPatient(pat);
                                    BigInteger docId = reportBuilder.addMandant(mandant);
                                    reportBuilder.addKonsultation(patId, docId, konsultation, unreferencedStopMedisPerPatient);
                                    konsultation.addSticker((ISticker)ExportFireHandler.this.fireSticker);
                                }
                                catch (IllegalStateException e) {
                                    logger.warn("Could not add consultation.", (Throwable)e);
                                }
                            }
                            monitor.worked(1);
                        }
                        reportBuilder.finish(unreferencedStopMedisPerPatient);
                        monitor.worked(1);
                        Optional<Report> report = reportBuilder.build();
                        if (!report.isPresent()) break block19;
                        try {
                            Object object = null;
                            Object var7_10 = null;
                            try (FileOutputStream fout = new FileOutputStream(new File(this.exportPath));){
                                XmlUtil.marshallFireReport(report.get(), fout);
                                ConfigServiceHolder.setGlobal((String)"ICPC_FIRE_LAST_UPLOAD", (String)new TimeTool().toString(9));
                                break block19;
                            }
                            catch (Throwable throwable) {
                                if (object == null) {
                                    object = throwable;
                                } else if (object != throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                throw object;
                            }
                        }
                        catch (IOException e) {
                            this.openError("Error", "Error writing report, see logs for details.");
                            logger.error("Error writing report.", (Throwable)e);
                        }
                        break block19;
                    }
                    this.openError("ICPC/Fire", "Bitte konfigurieren Sie das Fire Plugin (Datei-Einstellungen)");
                }
                catch (NumberFormatException | DatatypeConfigurationException e) {
                    this.openError("Error", "Error creating report, see logs for details.");
                    logger.error("Could not create XML output", (Throwable)e);
                }
            }
        }

        private void openError(final String title, final String description) {
            final Display display = Display.getDefault();
            if (display != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)title, (String)description);
                    }
                });
            }
        }
    }
}

