/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui.parts;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.documents.composites.CategorySelectionEditComposite;
import ch.elexis.core.ui.e4.fieldassist.AsyncContentProposalProvider;
import ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal;
import ch.elexis.core.ui.e4.providers.IdentifiableLabelProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import ch.elexis.global_inbox.ui.parts.MultiDateSelector;
import ch.elexis.global_inbox.ui.parts.contentproposal.TitleContentProposalProvider;
import ch.elexis.global_inbox.ui.parts.contentproposal.TitleControlContentAdapter;
import ch.elexis.global_inbox.ui.parts.contentproposal.TitleEntryContentProposal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GlobalInboxEntryDetailPart {
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    private GlobalInboxEntry globalInboxEntry;
    private Text txtTitle;
    private CategorySelectionEditComposite csec;
    private CDateTime archivingDate;
    private MultiDateSelector creationDateSelector;
    private ComboViewer cvPatient;
    private ComboViewer cvSender;
    private Text txtKeywords;
    private Button btnInfoTo;
    private ComboViewer cvInfoToReceiver;
    private static final String NO_CANDIDATES = "Keine Zuordnung gefunden. Eingeben um zu Suchen ...";
    private static final String MULT_CANDIDATES = "Keine eindeutige Zuordnung - %s Vorschl\u00e4ge. Bitte Ausw\u00e4hlen oder Eingeben.";

    @Inject
    public GlobalInboxEntryDetailPart(Composite parent, IConfigService configService, final EHandlerService handlerService) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parent, 0);
        label.setText("Titel");
        this.txtTitle = new Text(parent, 2048);
        this.txtTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtTitle.addModifyListener(e -> {
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setTitle(this.txtTitle.getText());
            }
        });
        ContentProposalAdapter titleContentProposalAdapter = new ContentProposalAdapter((Control)this.txtTitle, (IControlContentAdapter)new TitleControlContentAdapter(this.txtTitle), (IContentProposalProvider)new TitleContentProposalProvider(this.txtTitle), null, null);
        titleContentProposalAdapter.addContentProposalListener(proposal -> {
            TitleEntryContentProposal _proposal = (TitleEntryContentProposal)proposal;
            this.txtTitle.setText(_proposal.getTitleEntry().getTitle());
            this.csec.setCategoryByName(_proposal.getTitleEntry().getCategoryName());
            this.archivingDate.setFocus();
        });
        label = new Label(parent, 0);
        label.setText("Kategorie");
        this.csec = new CategorySelectionEditComposite(parent, 0, "ch.elexis.data.store.omnivore", true);
        this.csec.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.csec.addSelectionChangeListener(sc -> {
            ICategory category = (ICategory)sc.getStructuredSelection().getFirstElement();
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setCategory(category.getName());
            }
        });
        label = new Label(parent, 0);
        label.setText("Ablagedatum");
        this.archivingDate = new CDateTime(parent, 34605058);
        GridData gd_archivingDate = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_archivingDate.widthHint = 100;
        this.archivingDate.setLayoutData((Object)gd_archivingDate);
        this.archivingDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlobalInboxEntryDetailPart.this.globalInboxEntry != null) {
                    GlobalInboxEntryDetailPart.this.globalInboxEntry.setArchivingDate(GlobalInboxEntryDetailPart.this.archivingDate.getSelection());
                }
            }
        });
        Label lblHintCreationDateCandidateImage = new Label(parent, 0);
        GridData gdlblHintCreationDateCandidateImage = new GridData(4, 0x1000000, true, false, 2, 1);
        gdlblHintCreationDateCandidateImage.exclude = true;
        lblHintCreationDateCandidateImage.setLayoutData((Object)gdlblHintCreationDateCandidateImage);
        label = new Label(parent, 0);
        label.setText("Erstelldatum");
        this.creationDateSelector = new MultiDateSelector(parent, 0);
        GridData gd_multiDateSelector = new GridData(4, 0x1000000, true, false, 1, 1);
        this.creationDateSelector.setLayoutData(gd_multiDateSelector);
        this.creationDateSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlobalInboxEntryDetailPart.this.globalInboxEntry != null) {
                    GlobalInboxEntryDetailPart.this.globalInboxEntry.setCreationDate(GlobalInboxEntryDetailPart.this.creationDateSelector.getSelection());
                }
            }
        });
        Label lblHintPatientCandiateInfo = new Label(parent, 0);
        GridData gdlblHintPatientCandiateInfo = new GridData(4, 0x1000000, true, false, 2, 1);
        gdlblHintPatientCandiateInfo.exclude = true;
        lblHintPatientCandiateInfo.setLayoutData((Object)gdlblHintPatientCandiateInfo);
        final Link linkPatient = new Link(parent, 0);
        linkPatient.setText("<a>Patient</a>");
        linkPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor kontaktSelektor = new KontaktSelektor(linkPatient.getShell(), Patient.class, Messages.Core_Select_Patient, Messages.Core_Select_Patient, Patient.DEFAULT_SORT);
                if (kontaktSelektor.open() == 0) {
                    Patient patient = (Patient)kontaktSelektor.getSelection();
                    IPatient iPatient = patient.toIPatient();
                    GlobalInboxEntryDetailPart.this.cvPatient.add((Object)iPatient);
                    GlobalInboxEntryDetailPart.this.cvPatient.setSelection((ISelection)new StructuredSelection((Object)iPatient));
                    if (GlobalInboxEntryDetailPart.this.globalInboxEntry != null) {
                        GlobalInboxEntryDetailPart.this.globalInboxEntry.getPatientCandidates().add(iPatient);
                        GlobalInboxEntryDetailPart.this.globalInboxEntry.setPatient(iPatient);
                    }
                }
            }
        });
        this.cvPatient = new ComboViewer(parent, 0);
        final Combo comboPatient = this.cvPatient.getCombo();
        this.cvPatient.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvPatient.setLabelProvider((IBaseLabelProvider)new IdentifiableLabelProvider());
        AsyncContentProposalProvider<IPatient> cvpatacpp = new AsyncContentProposalProvider<IPatient>(new String[]{"description1", "description2", "dob", "code"}){

            public IQuery<IPatient> createBaseQuery() {
                return CoreModelServiceHolder.get().getQuery(IPatient.class);
            }

            protected boolean isPatientQuery() {
                return true;
            }

            public Widget getWidget() {
                return comboPatient;
            }
        };
        this.cvPatient.addSelectionChangedListener(sc -> {
            IContact familyDoctor;
            IMandator mandator;
            IPatient patient = (IPatient)sc.getStructuredSelection().getFirstElement();
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setPatient(patient);
            }
            if (patient != null && (mandator = (familyDoctor = patient.getFamilyDoctor()) != null ? (IMandator)CoreModelServiceHolder.get().load(familyDoctor.getId(), IMandator.class).orElse(null) : (IMandator)EncounterServiceHolder.get().getLatestEncounter(patient).map(enc -> enc.getMandator()).orElse(null)) != null) {
                this.cvInfoToReceiver.setSelection((ISelection)new StructuredSelection((Object)mandator));
            }
        });
        comboPatient.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        comboPatient.addListener(3, e -> {
            comboPatient.setText("");
            comboPatient.clearSelection();
        });
        ContentProposalAdapter cvpatcpa = new ContentProposalAdapter((Control)comboPatient, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)cvpatacpp, null, null);
        cvpatacpp.configureContentProposalAdapter(cvpatcpa);
        cvpatcpa.addContentProposalListener(proposal -> {
            IdentifiableContentProposal prop = (IdentifiableContentProposal)proposal;
            IPatient iPatient = (IPatient)prop.getIdentifiable();
            this.cvPatient.add((Object)iPatient);
            this.cvPatient.setSelection((ISelection)new StructuredSelection((Object)iPatient));
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.getPatientCandidates().add(iPatient);
                this.globalInboxEntry.setPatient(iPatient);
            }
        });
        Link linkSender = new Link(parent, 0);
        linkSender.setText("<a>Absender</a>");
        linkSender.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor kontaktSelektor = new KontaktSelektor(linkPatient.getShell(), Kontakt.class, Messages.Core_Select_Contact, Messages.Core_Please_Select_Contact, Patient.DEFAULT_SORT);
                if (kontaktSelektor.open() == 0) {
                    Kontakt contact = (Kontakt)kontaktSelektor.getSelection();
                    IContact iContact = contact.toIContact();
                    GlobalInboxEntryDetailPart.this.cvSender.add((Object)iContact);
                    GlobalInboxEntryDetailPart.this.cvSender.setSelection((ISelection)new StructuredSelection((Object)iContact));
                    if (GlobalInboxEntryDetailPart.this.globalInboxEntry != null) {
                        GlobalInboxEntryDetailPart.this.globalInboxEntry.setSender(iContact);
                    }
                }
            }
        });
        this.cvSender = new ComboViewer(parent, 0);
        final Combo comboSender = this.cvSender.getCombo();
        this.cvSender.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSender.setLabelProvider((IBaseLabelProvider)new IdentifiableLabelProvider());
        AsyncContentProposalProvider<IContact> cvsenderacpp = new AsyncContentProposalProvider<IContact>(new String[]{"description1", "description2", "description3", "code"}){

            public IQuery<IContact> createBaseQuery() {
                return CoreModelServiceHolder.get().getQuery(IContact.class);
            }

            public Widget getWidget() {
                return comboSender;
            }
        };
        comboSender.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cvSender.addSelectionChangedListener(sc -> {
            IContact sender = (IContact)this.cvSender.getStructuredSelection().getFirstElement();
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setSender(sender);
            }
        });
        comboSender.addListener(3, e -> {
            comboSender.setText("");
            comboSender.clearSelection();
        });
        ContentProposalAdapter cvsendercpa = new ContentProposalAdapter((Control)comboSender, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)cvsenderacpp, null, null);
        cvsenderacpp.configureContentProposalAdapter(cvsendercpa);
        cvsendercpa.addContentProposalListener(proposal -> {
            IdentifiableContentProposal contact = (IdentifiableContentProposal)proposal;
            IContact iContact = (IContact)contact.getIdentifiable();
            this.cvSender.add((Object)iContact);
            this.cvSender.setSelection((ISelection)new StructuredSelection((Object)iContact));
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setSender(iContact);
            }
        });
        label = new Label(parent, 0);
        label.setText("Stichw\u00f6rter");
        this.txtKeywords = new Text(parent, 2114);
        GridData gd_txtKeywords = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtKeywords.heightHint = 40;
        this.txtKeywords.setLayoutData((Object)gd_txtKeywords);
        this.txtKeywords.addModifyListener(e -> {
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setKeywords(this.txtKeywords.getText());
            }
        });
        label = new Label(parent, 0);
        label.setText("Info");
        Composite infoComposite = new Composite(parent, 0);
        infoComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_infoComposite = new GridLayout(2, false);
        gl_infoComposite.marginWidth = 0;
        gl_infoComposite.marginHeight = 0;
        infoComposite.setLayout((Layout)gl_infoComposite);
        this.btnInfoTo = new Button(infoComposite, 32);
        this.btnInfoTo.setText("Info an Stammarzt");
        this.btnInfoTo.setSelection(configService.getLocal("plugins/global_inbox/infoToInbox", false));
        this.btnInfoTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlobalInboxEntryDetailPart.this.globalInboxEntry != null) {
                    GlobalInboxEntryDetailPart.this.globalInboxEntry.setSendInfoTo(GlobalInboxEntryDetailPart.this.btnInfoTo.getSelection());
                }
            }
        });
        this.cvInfoToReceiver = new ComboViewer(infoComposite, 0);
        Combo comboInfoToReceiver = this.cvInfoToReceiver.getCombo();
        comboInfoToReceiver.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cvInfoToReceiver.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvInfoToReceiver.setLabelProvider((IBaseLabelProvider)new IdentifiableLabelProvider());
        List mandators = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        this.cvInfoToReceiver.setInput((Object)mandators);
        this.cvInfoToReceiver.addSelectionChangedListener(sc -> {
            if (this.globalInboxEntry != null) {
                this.globalInboxEntry.setInfoTo(sc.getStructuredSelection().toList());
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        Button btnView = new Button(buttonComposite, 0);
        btnView.setText("Anzeigen");
        btnView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterizedCommand cmd = GlobalInboxEntryDetailPart.this.commandService.createCommand("ch.elexis.global_inbox.command.globalinboxentryview");
                if (handlerService.canExecute(cmd)) {
                    handlerService.executeHandler(cmd);
                }
            }
        });
        Button btnAcceptAndNext = new Button(buttonComposite, 0);
        btnAcceptAndNext.setText("Ablegen und n\u00e4chstes");
        btnAcceptAndNext.addSelectionListener((SelectionListener)new AcceptAndNextSelectionHandler());
    }

    @Focus
    public void setFocus() {
        this.txtTitle.setFocus();
    }

    @Inject
    public void setGlobalInboxEntry(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") GlobalInboxEntry globalInboxEntry) {
        this.globalInboxEntry = globalInboxEntry;
        if (this.txtTitle == null || this.txtTitle.isDisposed()) {
            return;
        }
        if (globalInboxEntry == null) {
            this.txtTitle.setText("");
            this.csec.setCategoryByName(null);
            this.archivingDate.setSelection(null);
            this.creationDateSelector.setSelectionOptionsAndDefault(Collections.emptyList(), null);
            this.cvPatient.setInput(null);
            this.cvSender.setInput(null);
            this.txtKeywords.setText("");
            return;
        }
        this.txtTitle.setText(globalInboxEntry.getTitle());
        this.csec.setCategoryByName(globalInboxEntry.getCategory());
        this.txtKeywords.setText(globalInboxEntry.getKeywords() != null ? this.globalInboxEntry.getKeywords() : "");
        this.btnInfoTo.setSelection(globalInboxEntry.isSendInfoTo());
        Date selectedArchivingDate = globalInboxEntry.getArchivingDate();
        if (selectedArchivingDate != null) {
            this.archivingDate.setSelection(selectedArchivingDate);
        } else {
            this.archivingDate.setSelection(new Date());
        }
        Date creationDate = globalInboxEntry.getCreationDate();
        if (creationDate == null) {
            creationDate = TimeUtil.toDate((LocalDate)globalInboxEntry.getCreationDateCandidate());
        }
        Date creationDatePreselection = this.creationDateSelector.setSelectionOptionsAndDefault(globalInboxEntry.getDateTokens(), creationDate);
        globalInboxEntry.setCreationDate(creationDatePreselection);
        IPatient selectedPatient = globalInboxEntry.getPatient();
        List<IPatient> patientCandidates = globalInboxEntry.getPatientCandidates();
        this.cvPatient.setInput(patientCandidates);
        if (selectedPatient == null) {
            if (patientCandidates.isEmpty()) {
                this.cvPatient.getCombo().setText(NO_CANDIDATES);
            } else if (patientCandidates.size() == 1) {
                this.cvPatient.getCombo().setText("");
                this.cvPatient.setSelection((ISelection)new StructuredSelection((Object)patientCandidates.get(0)));
            } else {
                this.cvPatient.getCombo().setText(String.format(MULT_CANDIDATES, patientCandidates.size()));
            }
        } else {
            StructuredSelection selection = selectedPatient != null ? new StructuredSelection((Object)selectedPatient) : null;
            this.cvPatient.setSelection((ISelection)selection);
        }
        IContact selectedSender = globalInboxEntry.getSender();
        List<IContact> senderCandidates = globalInboxEntry.getSenderCandidates();
        if (selectedSender != null) {
            senderCandidates.add(selectedSender);
        }
        this.cvSender.setInput(senderCandidates);
        if (selectedSender == null) {
            if (senderCandidates.isEmpty()) {
                this.cvSender.getCombo().setText(NO_CANDIDATES);
            } else if (senderCandidates.size() == 1) {
                this.cvSender.getCombo().setText("");
                this.cvSender.setSelection((ISelection)new StructuredSelection((Object)senderCandidates.get(0)));
            } else {
                this.cvSender.getCombo().setText(String.format(MULT_CANDIDATES, patientCandidates.size()));
            }
        } else {
            StructuredSelection selection = selectedSender != null ? new StructuredSelection((Object)selectedSender) : null;
            this.cvSender.setSelection((ISelection)selection);
        }
    }

    private class AcceptAndNextSelectionHandler
    extends SelectionAdapter {
        private AcceptAndNextSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (GlobalInboxEntryDetailPart.this.globalInboxEntry == null) {
                return;
            }
            ParameterizedCommand cmd = GlobalInboxEntryDetailPart.this.commandService.createCommand("ch.elexis.global_inbox.command.globalinboxentryimport");
            if (GlobalInboxEntryDetailPart.this.handlerService.canExecute(cmd)) {
                GlobalInboxEntryDetailPart.this.handlerService.executeHandler(cmd);
                GlobalInboxEntryDetailPart.this.setGlobalInboxEntry(null);
            } else {
                SWTHelper.showError((String)"Could not import", (String)"Patient or category value is missing");
            }
        }
    }
}

