/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.global_inbox.model.GlobalInboxEntry;
import ch.elexis.global_inbox.ui.Messages;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalInboxUtil {
    private static IConfigService configService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Nullable
    public String tryImportForPatient(File file, String patientNo, String fileName) {
        List lPat = new Query(Patient.class, "PatientNr", patientNo).execute();
        if (lPat.size() == 1 && !this.isFileOpened(file)) {
            IDocumentManager dm;
            String cat;
            Patient pat;
            block5: {
                pat = (Patient)lPat.get(0);
                cat = GlobalInboxUtil.getCategory(file);
                if (cat.equals("-") || cat.equals("??")) {
                    cat = null;
                }
                dm = (IDocumentManager)Extensions.findBestService((String)"DocumentManagement");
                long heapSize = Runtime.getRuntime().totalMemory();
                long length = file.length();
                if (length < heapSize) break block5;
                this.logger.warn("Skipping " + file.getAbsolutePath() + " as bigger than heap size. (#3652)");
                return null;
            }
            try {
                GenericDocument fd = new GenericDocument(pat, fileName, cat, file, new TimeTool().toString(4), "", null);
                file.delete();
                boolean automaticBilling = CoreHub.localCfg.get("plugins/global_inbox/autobilling", false);
                return dm.addDocument((IOpaqueDocument)fd, automaticBilling);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.alert((String)Messages.InboxView_error, (String)ex.getMessage());
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean isFileOpened(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getDirectory(String defaultValue, IConfigService configService) {
        boolean isGlobal;
        if (GlobalInboxUtil.configService == null) {
            GlobalInboxUtil.configService = configService;
        }
        if (isGlobal = GlobalInboxUtil.configService.get("plugins/global_inbox/store_in_fs_global", false)) {
            return GlobalInboxUtil.configService.get("plugins/global_inbox/dir", defaultValue);
        }
        return GlobalInboxUtil.configService.getLocal("plugins/global_inbox/dir", defaultValue);
    }

    public static String getCategory(File file) {
        String dir = GlobalInboxUtil.getDirectory("", null);
        File parent = file.getParentFile();
        if (parent == null) {
            return Messages.Activator_noInbox;
        }
        String fname = parent.getAbsolutePath();
        if (fname.startsWith(dir)) {
            if (fname.length() > dir.length()) {
                return fname.substring(dir.length() + 1);
            }
            return "-";
        }
        return "??";
    }

    public void removeFiles(GlobalInboxEntry globalInboxEntry) {
        File[] extensionFiles;
        File mainFile = globalInboxEntry.getMainFile();
        try {
            Files.delete(mainFile.toPath());
        }
        catch (IOException e) {
            this.logger.warn("Could not delete " + mainFile, (Throwable)e);
        }
        File[] fileArray = extensionFiles = globalInboxEntry.getExtensionFiles();
        int n = extensionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File extensionFile = fileArray[n2];
            try {
                Files.delete(extensionFile.toPath());
            }
            catch (IOException e) {
                this.logger.warn("Could not delete " + extensionFile, (Throwable)e);
            }
            ++n2;
        }
    }
}

