/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox.core.util;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.io.InputStream;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ImportOmnivoreInboxUtil {
    private static IDocumentStore omnivoreDocumentStore;
    private static Logger logger;

    static {
        logger = LoggerFactory.getLogger(ImportOmnivoreInboxUtil.class);
    }

    @Reference(target="(storeid=ch.elexis.data.store.omnivore)")
    public void setDocumentStore(IDocumentStore documentStore) {
        omnivoreDocumentStore = documentStore;
    }

    @Nullable
    public String tryImportForPatient(IVirtualFilesystemService.IVirtualFilesystemHandle file, String patientNo, String fileName) {
        INamedQuery namedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
        Optional loaded = namedQuery.executeWithParametersSingleResult(namedQuery.getParameterMap(new Object[]{"code", patientNo}));
        if (loaded.isPresent()) {
            String cat;
            IPatient pat;
            block17: {
                pat = (IPatient)loaded.get();
                cat = ImportOmnivoreInboxUtil.getCategory(file);
                if (cat.equals("-") || cat.equals("??")) {
                    cat = null;
                }
                long heapSize = Runtime.getRuntime().totalMemory();
                long length = file.getContentLenght();
                if (length < heapSize) break block17;
                logger.warn("Skipping " + file.getAbsolutePath() + " as bigger than heap size. (#3652)");
                return null;
            }
            try {
                IDocument newDocument = omnivoreDocumentStore.createDocument(pat.getId(), fileName, cat);
                String extension = this.getFileExtension(file);
                if (extension != null && (newDocument.getMimeType() == null || newDocument.getMimeType().isEmpty())) {
                    MimeType mimetyp = MimeType.getByExtension((String)extension);
                    if (mimetyp != MimeType.undefined) {
                        newDocument.setMimeType(mimetyp.getContentType());
                    } else {
                        newDocument.setMimeType(file.getName());
                    }
                }
                Throwable throwable = null;
                Object var15_15 = null;
                try (InputStream contentStream = file.openInputStream();){
                    omnivoreDocumentStore.saveDocument(newDocument, contentStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                file.delete();
                return newDocument.getId();
            }
            catch (Exception ex) {
                logger.error("An error occurred while trying to import the document for patient with ID {}.", (Object)patientNo, (Object)ex);
            }
        }
        return null;
    }

    private String getFileExtension(IVirtualFilesystemService.IVirtualFilesystemHandle file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1 || lastIndexOf == 0) {
            return "";
        }
        return name.substring(lastIndexOf + 1);
    }

    public static String getDirectory(String defaultValue, String deviceName) {
        try {
            String deviceDir = ConfigServiceHolder.getGlobal((String)("plugins/global_inbox_server/device_dir_" + deviceName), (String)defaultValue);
            if (deviceDir == null) {
                logger.warn("Directory for device [{}] is null. Using default value [{}].", (Object)deviceName, (Object)defaultValue);
            }
            return deviceDir != null ? deviceDir : defaultValue;
        }
        catch (Exception ex) {
            logger.error("Error while fetching directory for device [{}].", (Object)deviceName, (Object)ex);
            return defaultValue;
        }
    }

    public static String getCategory(IVirtualFilesystemService.IVirtualFilesystemHandle file) {
        IVirtualFilesystemService.IVirtualFilesystemHandle parent;
        String category;
        block4: {
            try {
                category = ConfigServiceHolder.getGlobal((String)"plugins/global_inbox_server/last_selected_category", (String)"default");
                parent = file.getParent();
                if (parent != null) break block4;
                logger.warn("Parent directory for file [{}] is null.", (Object)file.getAbsolutePath());
                return "Error in inbox path";
            }
            catch (Exception ex) {
                logger.error("Error while determining category for file [{}].", (Object)file.getAbsolutePath(), (Object)ex);
                return "Error in category resolution";
            }
        }
        String fname = parent.getAbsolutePath();
        if (fname.startsWith(category)) {
            return parent.getName();
        }
        return category;
    }
}

