/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.extdoc.Messages;
import ch.elexis.extdoc.dialogs.MoveIntoSubDirsDialog;
import ch.elexis.extdoc.preferences.PreferenceConstants;
import ch.elexis.extdoc.util.FileFilters;
import ch.elexis.extdoc.util.ListFiles;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class MatchPatientToPath {
    private Patient pat;
    private static Log logger = Log.get((String)MoveIntoSubDirsDialog.class.getName());

    public MatchPatientToPath(Patient patient) {
        this.pat = patient;
    }

    private static void logAndConsole(String logEntry, int level) {
        logger.log(logEntry, level);
        System.out.println(logEntry);
    }

    public static String[] getFirstAndFamilyNameFromPathOldConvention(String fullPathname) {
        String separatedBySpace;
        String basename = new File(fullPathname).getName();
        if (basename.length() <= 6) {
            return new String[]{"", basename.replaceFirst(" *$", "")};
        }
        String lastname = MatchPatientToPath.cleanName(basename.substring(0, 6).replaceFirst(" *$", ""));
        if ((basename = basename.substring(6)).matches(separatedBySpace = ".*[. \\s].*")) {
            return new String[]{basename.replaceFirst("[. \\s].*", ""), lastname};
        }
        return new String[]{basename, lastname};
    }

    public static boolean MoveIntoSubDir(String path) {
        Patient pat = MatchPatientToPath.filenameBelongsToSomePatient(path);
        if (pat == null) {
            MatchPatientToPath.logAndConsole("No unique patient found for " + path, 3);
            return false;
        }
        MatchPatientToPath m = new MatchPatientToPath(pat);
        String dest = m.ShouldBeMovedToThisSubDir(path, pat.getGeburtsdatum());
        File destDir = new File(dest).getParentFile();
        if (!destDir.exists() && !destDir.mkdir()) {
            MatchPatientToPath.logAndConsole(String.format("Could not create subdir %1s created for patient %2s", destDir.getAbsolutePath(), pat.toString()), 3);
            return false;
        }
        MatchPatientToPath.logAndConsole(String.format("MoveIntoSubDir: %1s renameTo %2s", path, dest), 4);
        boolean success = new File(path).renameTo(new File(dest));
        return true;
    }

    private static String basenameMustBeginWith(String lastname, String firstname) {
        String shortLastname;
        firstname = MatchPatientToPath.firstToken(firstname);
        lastname = MatchPatientToPath.cleanName(lastname);
        firstname = MatchPatientToPath.cleanName(firstname);
        if (lastname.length() >= 6) {
            shortLastname = lastname.substring(0, 6);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(lastname);
            while (sb.length() < 6) {
                sb.append(" ");
            }
            shortLastname = sb.toString();
        }
        return String.valueOf(shortLastname) + firstname;
    }

    private static List<Patient> getPatient(String vorname, String nachname) {
        Query query = new Query(Patient.class);
        query.add("Name", "LIKE", String.valueOf(nachname) + "%", true);
        query.add("Vorname", "LIKE", String.valueOf(vorname) + "%", true);
        List patienten = query.execute();
        return patienten;
    }

    public static boolean filenameIsValid(String fullPathname, String familyName, String firstName) {
        String mustBeginWith = MatchPatientToPath.basenameMustBeginWith(familyName, firstName);
        File path = new File(fullPathname);
        File parent = new File(path.getParent());
        return path.getName().startsWith(mustBeginWith) || parent.getName().startsWith(mustBeginWith);
    }

    public static Patient filenameBelongsToSomePatient(String fullPathname) {
        String[] names = MatchPatientToPath.getFirstAndFamilyNameFromPathOldConvention(fullPathname);
        List<Patient> patienten = MatchPatientToPath.getPatient(names[0], names[1]);
        if (patienten.size() == 1) {
            return patienten.get(0);
        }
        MatchPatientToPath.logAndConsole(String.format("No unique patient found for %1s => %2s %3s (found %d) ", fullPathname, names[0], names[1], patienten.size()), 3);
        return null;
    }

    public static Object getFilesForPatient(Patient actPatient, String[] activePaths) {
        if (activePaths == null) {
            activePaths = PreferenceConstants.getActiveBasePaths();
        }
        FileFilters filter = new FileFilters(actPatient.getName(), actPatient.getVorname());
        List<File> list = ListFiles.getList(activePaths, actPatient.getName(), actPatient.getVorname(), actPatient.getGeburtsdatum(), filter);
        Object result = list.size() > 0 ? list : Messages.ExterneDokumente_no_files_found;
        return result;
    }

    public static String cleanName(String name) {
        if (name.length() == 0) {
            return name;
        }
        if ((name = name.replaceAll("-", "").replaceAll("_", "")).split("[. \\s]", 0).length > 1) {
            String clean = name.split("[. \\s]", 0)[0].toLowerCase();
            clean = String.valueOf(clean.substring(0, 1).toUpperCase()) + clean.substring(1);
            return clean;
        }
        return name;
    }

    public static String firstToken(String fullPathName) {
        String firstToken = fullPathName.replaceFirst("[_\\p{Space}].*", "");
        return firstToken;
    }

    public static String getSubDirPath(Patient pat) {
        String s = String.valueOf(CoreHub.localCfg.get("ch.elexis.externe_dokumente/BasisPfad", "")) + File.separatorChar + MatchPatientToPath.basenameMustBeginWith(pat.getName(), pat.getVorname());
        return s;
    }

    public static String geburtsDatumToCanonical(String geburtsDatum) {
        if (geburtsDatum == null || geburtsDatum.length() == 0) {
            return "1111-11-11";
        }
        String sortableDate = geburtsDatum.substring(6);
        if (sortableDate.length() != 4) {
            sortableDate = "XX";
        }
        sortableDate = String.valueOf(sortableDate) + "-" + geburtsDatum.substring(3, 5);
        sortableDate = String.valueOf(sortableDate) + "-" + geburtsDatum.substring(0, 2);
        return sortableDate;
    }

    public String ShouldBeMovedToThisSubDir(String oldPathname, String geburtsDatum) {
        String basename = new File(oldPathname).getName();
        String dirname = new File(oldPathname).getParent();
        String s = String.valueOf(dirname) + File.separatorChar + new File(MatchPatientToPath.getSubDirPath(this.pat)).getName() + " " + MatchPatientToPath.geburtsDatumToCanonical(geburtsDatum) + File.separatorChar + basename;
        return String.valueOf(dirname) + File.separatorChar + new File(MatchPatientToPath.getSubDirPath(this.pat)).getName() + " " + MatchPatientToPath.geburtsDatumToCanonical(geburtsDatum) + File.separatorChar + basename;
    }

    public static List<File> getAllOldConventionFiles() {
        ArrayList<File> allFiles = new ArrayList<File>();
        String[] paths = PreferenceConstants.getActiveBasePaths();
        int j = 0;
        while (j < paths.length) {
            FileFilter fileFilter;
            File dir;
            File[] files;
            if (paths[j] != null && paths[j].length() > 0 && (files = (dir = new File(paths[j])).listFiles(fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            })) != null) {
                int k = 0;
                while (k < files.length) {
                    allFiles.add(files[k]);
                    ++k;
                }
            }
            ++j;
        }
        return allFiles;
    }
}

