/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Patient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Email {
    private static Logger logger = null;

    private static String enc(String p) {
        if (p == null) {
            p = "";
        }
        try {
            return URLEncoder.encode(p, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public static void saveTextToClipboard(String body) {
        Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{body}, new Transfer[]{textTransfer});
        clipboard.dispose();
    }

    public static String getEmailPreface(Patient patient) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(patient.getName()) + " ");
        sb.append(String.valueOf(patient.getVorname()) + " ");
        sb.append(String.valueOf(patient.getPostAnschrift(false)) + " ");
        sb.append(String.valueOf(patient.get("Telefon1")) + " ");
        sb.append(String.valueOf(patient.getNatel()) + " ");
        sb.append(String.valueOf(patient.getMailAddress()) + " ");
        return sb.toString();
    }

    public static String getAllKonsultations(Patient patient) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public static boolean onWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static void runExternalProgram(String app, String params) {
        String cmd = String.valueOf(app) + " " + params;
        logger.info(cmd);
        try {
            File temp = File.createTempFile("batch", ".cmd");
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            bw.write("\"" + app + "\" " + params);
            bw.close();
            temp.setExecutable(true);
            logger.info("will call " + temp.getAbsolutePath());
            if (Email.onWindows()) {
                Runtime.getRuntime().exec("cmd /c " + temp.getAbsolutePath());
            } else {
                Runtime.getRuntime().exec(temp.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void openMailApplication(String to, String subject, String body, List<File> attachments) {
        logger = LoggerFactory.getLogger((String)"ch.elexis.extdoc");
        if (subject == null) {
            subject = CoreHub.localCfg.get("ch.elexis.externe_dokumente/Concerns", "\u00dcberweisung");
        }
        String app = CoreHub.localCfg.get("ch.elexis.externe_dokumente/Email_app", "mailto:");
        String params = "";
        try {
            if (app.toLowerCase().indexOf("outlook") >= 0) {
                params = String.valueOf(params) + " --composer --subject '" + subject + "'";
                if (attachments != null) {
                    for (File f : attachments) {
                        params = String.valueOf(params) + " /a \"" + f.getAbsolutePath() + "\"";
                    }
                }
                if (to != null && to.length() > 0) {
                    params = String.valueOf(params) + " " + to;
                }
                Email.runExternalProgram(app, params);
            } else if (app.toLowerCase().indexOf("kmail") >= 0) {
                params = String.valueOf(params) + " --composer --subject '" + subject + "'";
                File temp = File.createTempFile("message", ".tmp");
                BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
                bw.write(body);
                bw.close();
                params = String.valueOf(params) + " --msg " + temp.getAbsolutePath();
                if (attachments != null) {
                    for (File f : attachments) {
                        params = String.valueOf(params) + " --attach 'file://" + f.getAbsolutePath() + "'";
                    }
                }
                if (to != null && to.length() > 0) {
                    params = String.valueOf(params) + " " + to;
                }
                Email.runExternalProgram(app, params);
            } else if (app.toLowerCase().indexOf("thunderbird") >= 0 || app.toLowerCase().indexOf("icedove") >= 0) {
                params = String.valueOf(params) + " -compose \"";
                if (to != null && to.length() > 0) {
                    params = " to='" + to + "',";
                }
                params = String.valueOf(params) + "subject=\"" + subject + '\"';
                params = String.valueOf(params) + ",body='Bitte Ctrl-V benutzen, um Konsultationen einzuf\u00fcgen'";
                if (attachments != null && attachments.size() > 0) {
                    params = String.valueOf(params) + ",attachment='";
                    for (File f : attachments) {
                        params = String.valueOf(params) + '\"' + f.getAbsolutePath() + "\",";
                    }
                    params = params.substring(0, params.length() - 1);
                    params = String.valueOf(params) + "'";
                }
                params = String.valueOf(params) + "\"";
                Email.saveTextToClipboard(body);
                Email.runExternalProgram(app, params);
            } else {
                app = to != null && to.length() > 0 ? String.valueOf(app) + "?to=" + Email.enc(to) : String.valueOf(app) + "?";
                app = String.valueOf(app) + "subject=" + Email.enc(subject);
                app = String.valueOf(app) + "&body=" + Email.enc(body);
                Email.saveTextToClipboard(body);
                Email.runExternalProgram(app, "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

