/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.dialogs;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.extdoc.Messages;
import ch.elexis.extdoc.util.MatchPatientToPath;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveIntoSubDirsDialog
extends Action {
    private static Logger logger = null;

    public void run() {
        if (logger == null) {
            logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        logger.info("MoveIntoSubDirsDialog started");
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    int nrTreated = 0;
                    List<File> oldFiles = MatchPatientToPath.getAllOldConventionFiles();
                    int nrFiles = oldFiles.size();
                    String dialogTitle = String.format("Alle (%1d) Dateien in Unterverzeichnisse auslagern ...", nrFiles);
                    logger.info(dialogTitle);
                    if (oldFiles == null) {
                        SWTHelper.showInfo((String)dialogTitle, (String)Messages.MoveIntoSubDirsDialog_no_old_Files_found);
                        return;
                    }
                    monitor.beginTask(dialogTitle, oldFiles.size());
                    Iterator<File> iterator = oldFiles.iterator();
                    while (iterator.hasNext()) {
                        if (monitor.isCanceled()) break;
                        File f = iterator.next();
                        logger.info("Moving " + f.getAbsolutePath());
                        MatchPatientToPath.MoveIntoSubDir(f.getAbsolutePath());
                        if (++nrTreated % 10 != 1) continue;
                        monitor.subTask(String.format(Messages.MoveIntoSubDirsDialog_sub_task, f.getName()));
                        monitor.worked(10);
                    }
                    monitor.done();
                    logger.info("MoveIntoSubDirsDialog done");
                    SWTHelper.showInfo((String)dialogTitle, (String)Messages.MoveIntoSubDirsDialog_finished);
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            SWTHelper.showInfo((String)"Fehler beim Auslagern!!", (String)(String.valueOf(Messages.MoveIntoSubDirsDialog_finished) + "\n" + e.getMessage()));
            logger.info("Fehler beim Auslagern!!" + e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SWTHelper.showInfo((String)"Fehler beim Auslagern!", (String)(String.valueOf(Messages.MoveIntoSubDirsDialog_finished) + "\n" + e.getMessage()));
            logger.info("Fehler beim Auslagern!!" + e.getLocalizedMessage());
        }
    }
}

