/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.dialogs;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.extdoc.Messages;
import ch.elexis.extdoc.util.MatchPatientToPath;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileEditDialog
extends TitleAreaDialog {
    private static final int WIDGET_SPACE = 20;
    private Text tDateiname;
    private Text tExtension;
    private DatePickerCombo dp;
    private File file;

    public FileEditDialog(Shell parent, File file) {
        super(parent);
        this.file = file;
    }

    protected Control createDialogArea(Composite parent) {
        String fileName = this.file.getName();
        String fileExtension = "";
        Pattern p = Pattern.compile("^(.+)\\.([^.]+)$");
        Matcher m = p.matcher(fileName);
        if (m.matches()) {
            fileName = m.group(1);
            fileExtension = m.group(2);
        }
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        area.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(area, 0);
        label.setText(String.valueOf(Messages.FileEditDialog_file_name) + this.file.getParent());
        label.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.tDateiname = new Text(area, 2048);
        this.tDateiname.setText(fileName);
        this.tDateiname.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        SWTHelper.setSelectOnFocus((Text)this.tDateiname);
        label = new Label(area, 0);
        label.setText(String.format(Messages.FileEditDialog_file_date_and_explanation, new TimeTool(this.file.lastModified()).toString(4)));
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalIndent = 20;
        label.setLayoutData((Object)gd);
        label = new Label(area, 0);
        label.setText(Messages.FileEditDialog_extension);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalIndent = 20;
        label.setLayoutData((Object)gd);
        this.dp = new DatePickerCombo(area, 0);
        this.tExtension = new Text(area, 2048);
        this.tExtension.setText(fileExtension);
        this.tExtension.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        SWTHelper.setSelectOnFocus((Text)this.tExtension);
        return area;
    }

    public void create() {
        super.create();
        this.setMessage(Messages.ExterneDokumente_rename_or_change_date);
        this.setTitle(Messages.FileEditDialog_file_properties);
        this.getShell().setText(Messages.FileEditDialog_file_properties);
        this.setTitleImage(Images.IMG_LOGO.getImage());
    }

    protected void okPressed() {
        String fileName = this.tDateiname.getText();
        String fileExtension = this.tExtension.getText();
        String dateiname = StringTool.isNothing((Object)fileExtension) ? fileName : String.valueOf(fileName) + "." + fileExtension;
        Date datum = this.dp.getDate();
        if (datum != null && datum.getTime() != this.file.lastModified()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(datum);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Long newTime = cal.getTimeInMillis();
            System.out.println("new time: " + newTime + " (" + this.file.lastModified() + ")");
            this.file.setLastModified(newTime);
        }
        if (!this.file.getName().equals(dateiname)) {
            File newFile = new File(this.file.getParent(), dateiname);
            System.out.format("rename %1s ->%2s (%3s)", this.file.getAbsolutePath(), newFile.getAbsolutePath(), this.file.getName());
            String oldShort = MatchPatientToPath.firstToken(this.file.getName());
            String newShort = MatchPatientToPath.firstToken(newFile.getName());
            if (!oldShort.equals(newShort)) {
                if (SWTHelper.askYesNo((String)Messages.FileEditDialog_attribute_to_new_patient, (String)String.format(Messages.FileEditDialog_really_attribute_to_new_patient, oldShort, newShort))) {
                    System.out.format("okPressed move %1s -> %2s", oldShort, newShort);
                } else {
                    System.out.format("cancelPressed move %1s -> %2s", oldShort, newShort);
                    super.cancelPressed();
                    return;
                }
            }
            if (!this.file.renameTo(newFile)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.FileEditDialog_17, (String)Messages.FileEditDialog_18);
            }
        }
        super.okPressed();
    }
}

