/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.estudio.clustertec;

import ch.clustertec.estudio.schemas.order.ObjectFactory;
import ch.clustertec.estudio.schemas.order.Order;
import ch.clustertec.estudio.schemas.order.Product;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrderEntry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class ClustertecOrderFactory {
    public static Order createOrder(String clientNrPharmapool, String user, String password) {
        Order ret = new ObjectFactory().createOrder();
        ret.setClientNrRose(clientNrPharmapool);
        ret.setUser(user);
        ret.setPassword(password);
        ret.setDeliveryType(1);
        return ret;
    }

    public static Product createProduct(IOrderEntry item) {
        IArticle article = item.getArticle();
        String pharmacode = ClustertecOrderFactory.getPharmaCode(article);
        String eanId = ClustertecOrderFactory.getEan(article);
        String description = article.getName();
        int quantity = item.getAmount();
        Product product = new ObjectFactory().createProduct();
        product.setPharmacode(pharmacode);
        product.setEanId(eanId);
        product.setDescription(description);
        product.setQuantity(quantity);
        product.setPositionType(1);
        return product;
    }

    private static String getEan(IArticle article) {
        Object value;
        String ret = article.getGtin();
        if (StringUtils.isBlank((CharSequence)ret) && (value = article.getExtInfo((Object)"EAN")) instanceof String && ((String)value).length() > 11) {
            ret = (String)value;
        }
        return ret;
    }

    private static String getPharmaCode(IArticle article) {
        Object value;
        String ret = "";
        try {
            Method method = article.getClass().getMethod("getPHAR", new Class[0]);
            ret = (String)method.invoke((Object)article, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException method) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)ret) && (value = article.getExtInfo((Object)"Pharmacode")) instanceof String && ((String)value).length() == 7) {
            ret = (String)value;
        }
        return StringUtils.leftPad((String)StringUtils.defaultString((String)ret), (int)7, (String)"0");
    }
}

