/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import ch.docbox.ws.cdachservicesv2.CDACHServicesV2;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsClientUtil {
    private static Logger logger = LoggerFactory.getLogger(WsClientUtil.class);
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String toHex(byte[] v) {
        String out = "";
        int i = 0;
        while (i < v.length) {
            out = String.valueOf(out) + hex[v[i] >> 4 & 0xF] + hex[v[i] & 0xF];
            ++i;
        }
        return out;
    }

    public static String getSHA1(String password) {
        if (password == null || "".equals(password)) {
            return "";
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
            md.update(password.getBytes("UTF-8"));
            byte[] digest = md.digest();
            return WsClientUtil.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            logger.error("Error", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("Error", (Throwable)e);
        }
        return "";
    }

    public static boolean checkAccess(CDACHServicesV2 port) {
        Holder _checkAccess_success = new Holder();
        Holder _checkAccess_message = new Holder();
        port.checkAccess((Holder<Boolean>)_checkAccess_success, (Holder<String>)_checkAccess_message);
        logger.debug("checkAccess._checkAccess_success=" + _checkAccess_success.value);
        logger.debug("checkAccess._checkAccess_message=" + (String)_checkAccess_message.value);
        return (Boolean)_checkAccess_success.value;
    }

    public static void addWsSecurityAndHttpConfigWithClientCert(Service ss, final String username, final String password) {
        ss.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new SecurityHandler(username, password));
                return handlerList;
            }
        });
    }

    public static boolean isMedelexisBasicAuthAvailable() {
        InputStream basicAuthInputStream = null;
        try {
            basicAuthInputStream = WsClientUtil.class.getResourceAsStream("/cert/product.auth");
            boolean bl = basicAuthInputStream != null;
            return bl;
        }
        finally {
            if (basicAuthInputStream != null) {
                try {
                    basicAuthInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static InputStream getBasicAuthInputStream() {
        InputStream certInputStream = WsClientUtil.class.getResourceAsStream("/cert/product.auth");
        if (certInputStream != null) {
            logger.info("Using fragment basic auth.");
            return certInputStream;
        }
        return null;
    }

    public static class SecurityHandler
    implements SOAPHandler<SOAPMessageContext> {
        private String username;
        private String password;

        public SecurityHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public Set<QName> getHeaders() {
            return new TreeSet<QName>();
        }

        public boolean handleMessage(SOAPMessageContext context) {
            Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outboundProperty.booleanValue()) {
                try {
                    SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
                    SOAPFactory factory = SOAPFactory.newInstance();
                    String prefix = "wsse";
                    String uri = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
                    SOAPElement securityElem = factory.createElement("Security", prefix, uri);
                    SOAPElement usernameTokenEl = factory.createElement("UsernameToken", prefix, uri);
                    SOAPElement usernameEl = factory.createElement("Username", prefix, uri);
                    SOAPElement passwordEl = factory.createElement("Password", prefix, uri);
                    usernameEl.setTextContent(this.username);
                    passwordEl.setTextContent(this.password);
                    usernameTokenEl.addChildElement(usernameEl);
                    usernameTokenEl.addChildElement(passwordEl);
                    securityElem.addChildElement(usernameTokenEl);
                    SOAPHeader header = envelope.getHeader();
                    if (header == null) {
                        header = envelope.addHeader();
                    }
                    header.addChildElement(securityElem);
                }
                catch (Exception e) {
                    logger.error("Exception in handler: " + e);
                }
            }
            return true;
        }

        public boolean handleFault(SOAPMessageContext context) {
            return true;
        }

        public void close(MessageContext context) {
        }
    }
}

