/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.valueset;

import ch.elexis.core.findings.ICoding;
import ch.elexis.covid.cert.valueset.Coding;
import ch.elexis.covid.cert.valueset.ValueSetConceptArray;
import ch.elexis.covid.cert.valueset.ValueSetConceptMap;
import ch.elexis.covid.cert.valueset.ValueSetCummulatedArray;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class JsonValueSet {
    private ValueSetConceptMap valueSetMap;
    private ValueSetConceptArray valueSetArray;
    private ValueSetCummulatedArray cummulatedValueSet;
    private String cummulatedValueSetId;
    private String cummulatedFilter;
    private String cummulatedSystem;

    public static Optional<JsonValueSet> load(String name) {
        try {
            name = JsonValueSet.cummulatedMapName(name);
            InputStream jsonInput = JsonValueSet.class.getResourceAsStream("/rsc/" + name + ".json");
            if (jsonInput != null) {
                Gson gson = new GsonBuilder().create();
                if (JsonValueSet.isValueSetList(name)) {
                    ValueSetConceptArray valueSet = (ValueSetConceptArray)gson.fromJson(IOUtils.toString((InputStream)jsonInput, (String)"UTF-8"), ValueSetConceptArray.class);
                    return Optional.of(new JsonValueSet(valueSet));
                }
                if (JsonValueSet.isCummulated(name)) {
                    ValueSetCummulatedArray valueSet = (ValueSetCummulatedArray)gson.fromJson(IOUtils.toString((InputStream)jsonInput, (String)"UTF-8"), ValueSetCummulatedArray.class);
                    return Optional.of(new JsonValueSet(valueSet, "covid-19-lab-test-manufacturer", "https://covid-19-diagnostics.jrc.ec.europa.eu/devices", "type_code=LP217198-3"));
                }
                ValueSetConceptMap valueSet = (ValueSetConceptMap)gson.fromJson(IOUtils.toString((InputStream)jsonInput, (String)"UTF-8"), ValueSetConceptMap.class);
                return Optional.of(new JsonValueSet(valueSet));
            }
        }
        catch (JsonSyntaxException | IOException e) {
            LoggerFactory.getLogger(JsonValueSet.class).error("Error parsing valueset [" + name + "]", e);
        }
        return Optional.empty();
    }

    private static String cummulatedMapName(String name) {
        if ("test-manufacturer".equals(name)) {
            return "cummulated_tests_1.0.0";
        }
        return name;
    }

    private static boolean isValueSetList(String name) {
        return "country-alpha-2-de".equals(name);
    }

    private static boolean isCummulated(String name) {
        return name.startsWith("cummulated");
    }

    public JsonValueSet(ValueSetConceptMap valueSet) {
        this.valueSetMap = valueSet;
    }

    public JsonValueSet(ValueSetConceptArray valueSet) {
        this.valueSetArray = valueSet;
    }

    public JsonValueSet(ValueSetCummulatedArray valueSet, String valueSetId, String system, String filterString) {
        this.cummulatedValueSet = valueSet;
        this.cummulatedValueSetId = valueSetId;
        this.cummulatedSystem = system;
        this.cummulatedFilter = filterString;
    }

    public String getId() {
        if (this.valueSetArray != null) {
            return this.valueSetArray.valueSetId;
        }
        if (this.cummulatedValueSet != null) {
            return this.cummulatedValueSetId;
        }
        return this.valueSetMap.valueSetId;
    }

    public List<ICoding> getCoding() {
        if (this.valueSetArray != null) {
            if (this.valueSetArray.valueSetValues != null) {
                return Arrays.asList(this.valueSetArray.valueSetValues).stream().filter(map -> this.isActive((Map<String, String>)map)).map(map -> new Coding((Map<String, String>)map)).collect(Collectors.toList());
            }
        } else if (this.valueSetMap != null) {
            if (this.valueSetMap.valueSetValues != null) {
                return this.valueSetMap.valueSetValues.entrySet().stream().filter(entry -> this.isActive((Map)entry.getValue())).map(entry -> new Coding((Map.Entry<String, Map<String, String>>)entry)).collect(Collectors.toList());
            }
        } else if (this.cummulatedValueSet != null && this.cummulatedValueSet.entries != null) {
            return Arrays.asList(this.cummulatedValueSet.entries).stream().filter(entry -> this.isActive((Map<String, String>)entry) && this.isCummulatedFilter((Map<String, String>)entry, this.cummulatedFilter)).map(entry -> new Coding((Map<String, String>)entry)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isCummulatedFilter(Map<String, String> map, String cummulatedFilter) {
        String[] filterParts;
        if (cummulatedFilter != null && cummulatedFilter.split("=").length == 2 && StringUtils.isNotBlank((CharSequence)map.get((filterParts = cummulatedFilter.split("="))[0]))) {
            return filterParts[1].equals(map.get(filterParts[0]));
        }
        return true;
    }

    private boolean isActive(Map<String, String> map) {
        boolean activeValue = true;
        if (StringUtils.isNotBlank((CharSequence)map.get("active"))) {
            activeValue = Boolean.parseBoolean(map.get("active"));
        }
        boolean chAcceptedValue = true;
        if (StringUtils.isNotBlank((CharSequence)map.get("ch_accepted"))) {
            chAcceptedValue = Boolean.parseBoolean(map.get("ch_accepted"));
        }
        return activeValue && chAcceptedValue;
    }

    public String toString() {
        return "JsonValueSet [valueSet=" + this.valueSetMap + ", valueList=" + this.valueSetArray + "]";
    }

    public static String getSystemLanguage() {
        block16: {
            String language = Locale.getDefault().getLanguage();
            if (language == null) break block16;
            switch (language) {
                case "de": {
                    return "de-CH";
                }
                case "fr": {
                    return "fr-CH";
                }
                case "it": {
                    return "it-CH";
                }
                case "en": {
                    return "en-US";
                }
            }
        }
        return "de-CH";
    }
}

