/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.preference;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.IValueSetService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.covid.cert.service.CertificatesService;
import ch.elexis.data.Leistungsblock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    private ComboViewer modeCombo;
    private Text testingCenter;
    private Text otpText;
    private ComboViewer defaultVaccinationCombo;
    private ComboViewer defaultTestCombo;
    @Inject
    private CertificatesService service;
    @Inject
    private IValueSetService valueSetService;
    private Label textLabel;
    private Button bAutomaticBilling;

    public PreferencePage() {
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    public PreferencePage(String title) {
        super(title);
    }

    public PreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.modeCombo = new ComboViewer(ret, 2048);
        this.modeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.modeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.modeCombo.setInput((Object)CertificatesService.Mode.values());
        this.modeCombo.setSelection((ISelection)new StructuredSelection((Object)this.service.getMode()));
        this.modeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreferencePage.this.service.setMode((CertificatesService.Mode)((Object)event.getStructuredSelection().getFirstElement()));
            }
        });
        this.defaultVaccinationCombo = new ComboViewer(ret, 2048);
        this.defaultVaccinationCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List vaccinationValueSet = this.valueSetService.getValueSet("vaccines-covid-19-names");
        this.defaultVaccinationCombo.setInput((Object)vaccinationValueSet);
        this.defaultVaccinationCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        this.defaultVaccinationCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection() != null && !event.getStructuredSelection().isEmpty()) {
                    ICoding selected = (ICoding)event.getStructuredSelection().getFirstElement();
                    ConfigServiceHolder.get().set("ch.elexis.covid.cert/default/vaccproductcode", selected.getCode());
                }
            }
        });
        this.defaultVaccinationCombo.getControl().setToolTipText("Vorauswahl Impf-Produkt");
        this.defaultVaccinationCombo.getCombo().setText("Vorauswahl Impf-Produkt");
        String defaultVaccCode = ConfigServiceHolder.get().get("ch.elexis.covid.cert/default/vaccproductcode", null);
        if (defaultVaccCode != null) {
            vaccinationValueSet.stream().filter(c -> c.getCode().equals(defaultVaccCode)).findFirst().ifPresent(c -> this.defaultVaccinationCombo.setSelection((ISelection)new StructuredSelection(c)));
        }
        this.defaultTestCombo = new ComboViewer(ret, 2048);
        this.defaultTestCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List testsValueSet = this.valueSetService.getValueSet("covid-19-lab-test-manufacturer");
        this.defaultTestCombo.setInput((Object)testsValueSet);
        this.defaultTestCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        this.defaultTestCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection() != null && !event.getStructuredSelection().isEmpty()) {
                    ICoding selected = (ICoding)event.getStructuredSelection().getFirstElement();
                    ConfigServiceHolder.get().set("ch.elexis.covid.cert/default/testproductcode", selected.getCode());
                }
            }
        });
        this.defaultTestCombo.getControl().setToolTipText("Vorauswahl Test-Produkt");
        this.defaultTestCombo.getCombo().setText("Vorauswahl Test-Produkt");
        String defaultTestCode = ConfigServiceHolder.get().get("ch.elexis.covid.cert/default/testproductcode", null);
        if (defaultTestCode != null) {
            testsValueSet.stream().filter(c -> c.getCode().equals(defaultTestCode)).findFirst().ifPresent(c -> this.defaultTestCombo.setSelection((ISelection)new StructuredSelection(c)));
        }
        this.testingCenter = new Text(ret, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.testingCenter.setLayoutData((Object)gd);
        this.testingCenter.setMessage("Test Ort Name (z.B. Praxis Name) max. 50 Zeichen");
        this.testingCenter.setToolTipText("Test Ort Name (z.B. Praxis Name) max. 50 Zeichen");
        this.testingCenter.setText(ConfigServiceHolder.get().get(CertificatesService.CFG_TESTCENTERNAME, ""));
        this.testingCenter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigServiceHolder.get().set(CertificatesService.CFG_TESTCENTERNAME, PreferencePage.this.testingCenter.getText());
            }
        });
        Label lbl = new Label(ret, 258);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.bAutomaticBilling = new Button(ret, 32);
        this.bAutomaticBilling.setText("Automatische Verrechnung von Tests");
        this.bAutomaticBilling.setSelection(ConfigServiceHolder.get().get("ch.elexis.covid.cert.ui/automatic_billing", false));
        this.bAutomaticBilling.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.get().set("ch.elexis.covid.cert.ui/automatic_billing", PreferencePage.this.bAutomaticBilling.getSelection());
            }
        });
        this.createBillingBlock("ch.elexis.covid.cert.ui/kk_blockid", ret);
        this.createBillingBlock("ch.elexis.covid.cert.ui/kk_pcr_blockid", ret);
        this.createBillingBlock("ch.elexis.covid.cert.ui/sz_blockid", ret);
        this.createBillingBlock("ch.elexis.covid.cert.ui/sz_pcr_blockid", ret);
        lbl = new Label(ret, 258);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textLabel = new Label(ret, 0);
        this.otpText = new Text(ret, 2114);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        this.otpText.setLayoutData((Object)gd);
        this.otpText.setText(ConfigServiceHolder.get().getActiveMandator(CertificatesService.CFG_OTP, ""));
        this.otpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigServiceHolder.get().setActiveMandator(CertificatesService.CFG_OTP, PreferencePage.this.otpText.getText());
                ConfigServiceHolder.get().setActiveMandator(CertificatesService.CFG_OTP_TIMESTAMP, LocalDateTime.now().toString());
            }
        });
        this.updateTextLabel();
        return ret;
    }

    private void createBillingBlock(final String cfg, Composite ret) {
        Composite billingBlockComposite = new Composite(ret, 0);
        billingBlockComposite.setLayout((Layout)new RowLayout());
        final Text tAutomaticBillingBlock = new Text(billingBlockComposite, 2056);
        tAutomaticBillingBlock.setLayoutData((Object)new RowData(250, -1));
        tAutomaticBillingBlock.setTextLimit(80);
        String text = this.getText(cfg);
        tAutomaticBillingBlock.setMessage(text);
        tAutomaticBillingBlock.setToolTipText(text);
        Button blockCodeSelection = new Button(billingBlockComposite, 8);
        blockCodeSelection.setText("...");
        blockCodeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionDialog dialog = CodeSelectorFactory.getSelectionDialog((String)"Block", (Shell)PreferencePage.this.getShell(), (Object)"ignoreErrors");
                if (dialog.open() == 0) {
                    if (dialog.getResult() != null && dialog.getResult().length > 0) {
                        Leistungsblock block = (Leistungsblock)dialog.getResult()[0];
                        tAutomaticBillingBlock.setText(block.getLabel());
                        ConfigServiceHolder.get().set(cfg, block.getId());
                    } else {
                        ConfigServiceHolder.get().set(cfg, null);
                        tAutomaticBillingBlock.setText("");
                    }
                }
            }
        });
        if (ConfigServiceHolder.get().get(cfg, null) != null) {
            tAutomaticBillingBlock.setText(Leistungsblock.load((String)ConfigServiceHolder.get().get(cfg, null)).getLabel());
        }
    }

    private String getText(String cfg) {
        if (cfg.equals("ch.elexis.covid.cert.ui/kk_blockid")) {
            return "Block f\u00fcr Krankenkasse Antigen";
        }
        if (cfg.equals("ch.elexis.covid.cert.ui/kk_pcr_blockid")) {
            return "Block f\u00fcr Krankenkasse PCR";
        }
        if (cfg.equals("ch.elexis.covid.cert.ui/sz_blockid")) {
            return "Block f\u00fcr Selbstzahler Antigen";
        }
        if (cfg.equals("ch.elexis.covid.cert.ui/sz_pcr_blockid")) {
            return "Block f\u00fcr Selbstzahler PCR";
        }
        return "?";
    }

    private void updateTextLabel() {
        String timeStampString = ConfigServiceHolder.get().getActiveMandator(CertificatesService.CFG_OTP_TIMESTAMP, "");
        if (StringUtils.isNotBlank((CharSequence)timeStampString)) {
            LocalDateTime timeStamp = LocalDateTime.parse(timeStampString);
            this.textLabel.setText("OTP des Mandanten von " + DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(timeStamp));
        } else {
            this.textLabel.setText("OTP des Mandanten");
        }
    }
}

