/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.handler;

import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.covid.cert.ui.handler.CovidHandlerUtil;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CovidTestBill {
    @Inject
    private IContextService contextService;

    @Execute
    public void execute() {
        if (ConfigServiceHolder.get().get("ch.elexis.covid.cert.ui/automatic_billing", false)) {
            Optional activePatient = this.contextService.getActivePatient();
            activePatient.ifPresent(patient -> {
                ICodeElementBlock block;
                Map<String, ICodeElementBlock> blocks = CovidHandlerUtil.getConfiguredBlocks();
                if (!blocks.isEmpty() && (block = this.selectBlock(blocks)) != null) {
                    ICoverage coverage = null;
                    if (block == blocks.get("ch.elexis.covid.cert.ui/kk_blockid") || block == blocks.get("ch.elexis.covid.cert.ui/kk_pcr_blockid")) {
                        coverage = CovidHandlerUtil.getCoverageWithLaw(patient, CovidHandlerUtil.KK_LAWS).orElse(null);
                        if (coverage == null) {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Keine Verrechnung", (String)"Es wurde noch kein Fall mit Gesetz KVG angelegt."));
                        }
                    } else {
                        coverage = CovidHandlerUtil.getCoverageWithLaw(patient, CovidHandlerUtil.SZ_LAWS).orElse(null);
                        if (coverage == null) {
                            coverage = this.createPrivateCoverage((IPatient)patient);
                        }
                    }
                    if (coverage != null) {
                        IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)this.contextService.getActiveMandator().get()).buildAndSave();
                        CovidHandlerUtil.addBlockToEncounter(block, encounter);
                        this.contextService.getRootContext().setTyped((Object)encounter);
                    }
                }
            });
        }
    }

    private ICodeElementBlock selectBlock(Map<String, ICodeElementBlock> blocks) {
        if (blocks.size() == 1) {
            return (ICodeElementBlock)blocks.values().toArray()[0];
        }
        int ret = MessageDialog.open((int)3, (Shell)Display.getDefault().getActiveShell(), (String)"Verrechnungsblock Auswahl", (String)"Welcher Leistungsblock soll verrechnet werden.", (int)0x10000000, (String[])new String[]{"Krankenkasse Antigen", "Selbszahler Antigen", "Krankenkasse PCR", "Selbszahler PCR"});
        if (ret == 0) {
            return blocks.get("ch.elexis.covid.cert.ui/kk_blockid");
        }
        if (ret == 1) {
            return blocks.get("ch.elexis.covid.cert.ui/sz_blockid");
        }
        if (ret == 2) {
            return blocks.get("ch.elexis.covid.cert.ui/kk_pcr_blockid");
        }
        if (ret == 3) {
            return blocks.get("ch.elexis.covid.cert.ui/sz_pcr_blockid");
        }
        return null;
    }

    private ICoverage createPrivateCoverage(IPatient patient) {
        return new ICoverageBuilder(CoreModelServiceHolder.get(), patient, "Selbstzahler", ICoverageBuilder.getDefaultCoverageReason((IConfigService)ConfigServiceHolder.get()), BillingLaw.privat.name()).buildAndSave();
    }
}

