/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.handler;

import ch.elexis.core.findings.codes.IValueSetService;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.covid.cert.service.CertificateInfo;
import ch.elexis.covid.cert.service.CertificatesService;
import ch.elexis.covid.cert.service.rest.model.TestModel;
import ch.elexis.covid.cert.ui.handler.CovidHandlerUtil;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class CovidAntigenKk {
    @Inject
    private IValueSetService valueSetService;
    @Inject
    private CertificatesService service;
    @Inject
    private IContextService contextService;
    @Inject
    @Service(filterExpression="(storeid=ch.elexis.data.store.omnivore)")
    private IDocumentStore omnivoreStore;
    @Inject
    private ILocalDocumentService localDocumentService;

    @Execute
    public void execute() {
        Optional activePatient = this.contextService.getActivePatient();
        activePatient.ifPresent(patient -> {
            Map<String, ICodeElementBlock> blocks = CovidHandlerUtil.getConfiguredBlocks();
            if (!blocks.isEmpty()) {
                Optional<ICoverage> kkCoverage = CovidHandlerUtil.getCoverageWithLaw(patient, CovidHandlerUtil.KK_LAWS);
                Optional<CertificateInfo> todayCertificate = CovidHandlerUtil.getCertificateAtWithType(patient, LocalDate.now(), CertificateInfo.Type.TEST);
                if (kkCoverage.isPresent()) {
                    if (todayCertificate.isPresent()) {
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Vorhandenes Test Zertifikat", (String)"Es wurde heute bereits ein Test Zertifikat ausgestellt.\nM\u00f6chten Sie dieses anzeigen?")) {
                            CovidHandlerUtil.openCertDocument(todayCertificate.get(), this.omnivoreStore, this.localDocumentService);
                        }
                    } else {
                        Optional<IEncounter> antigenEncounter = this.billAntigen(kkCoverage.get());
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Test Resultat", (String)"Wurde der Patient positiv getestet?")) {
                            if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"PCR Test", (String)"Wurde ein PCR Test gemacht?") && antigenEncounter.isPresent()) {
                                Optional<IEncounter> pcrEncounter = this.billPcr(kkCoverage.get());
                                pcrEncounter.ifPresent(encounter -> {
                                    if (CovidHandlerUtil.isBilled((IEncounter)antigenEncounter.get(), "01.01.1100")) {
                                        CovidHandlerUtil.removeBilled(encounter, "01.01.1100");
                                    }
                                });
                            }
                        } else {
                            this.createCert(kkCoverage.get());
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Kein Fall", (String)"Es wurde noch kein Fall mit Gesetz KVG angelegt.");
                }
            }
        });
    }

    private void createCert(ICoverage coverage) {
        TestModel model = CovidHandlerUtil.getTestModel(coverage.getPatient(), this.service, this.valueSetService, "antigen");
        if (model != null) {
            try {
                Result<String> result = this.service.createTestCertificate(coverage.getPatient(), model);
                if (result.isOK()) {
                    CertificateInfo newCert = CertificateInfo.of(coverage.getPatient()).stream().filter(c -> c.getUvci().equals(result.get())).findFirst().orElse(null);
                    if (newCert != null) {
                        CovidHandlerUtil.openCertDocument(newCert, this.omnivoreStore, this.localDocumentService);
                    }
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)coverage.getPatient());
                    CovidHandlerUtil.showResultInfos(result);
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist folgender Fehler aufgetreten.\n\n" + result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "))));
                }
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Es ist ein Fehler beim Aufruf der API aufgetreten.");
                LoggerFactory.getLogger(this.getClass()).error("Error getting test certificate", (Throwable)ex);
            }
        }
    }

    private Optional<IEncounter> billAntigen(ICoverage coverage) {
        ICodeElementBlock kkBlock = CovidHandlerUtil.getConfiguredBlocks().get("ch.elexis.covid.cert.ui/kk_blockid");
        if (kkBlock != null) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)this.contextService.getActiveMandator().get()).buildAndSave();
            CovidHandlerUtil.addBlockToEncounter(kkBlock, encounter);
            this.contextService.getRootContext().setTyped((Object)encounter);
            return Optional.of(encounter);
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Krankenkassen Antigen Block konfiguriert.");
        return Optional.empty();
    }

    private Optional<IEncounter> billPcr(ICoverage coverage) {
        ICodeElementBlock kkBlock = CovidHandlerUtil.getConfiguredBlocks().get("ch.elexis.covid.cert.ui/kk_pcr_blockid");
        if (kkBlock != null) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)this.contextService.getActiveMandator().get()).buildAndSave();
            CovidHandlerUtil.addBlockToEncounter(kkBlock, encounter);
            this.contextService.getRootContext().setTyped((Object)encounter);
            return Optional.of(encounter);
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Krankenkassen PCR Block konfiguriert.");
        return Optional.empty();
    }
}

