/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.dialogs;

import ch.elexis.core.findings.codes.IValueSetService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.covid.cert.service.rest.model.RecoveryModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.LoggerFactory;

public class RecoveryModelDialog
extends Dialog {
    @Inject
    private IValueSetService valueSetService;
    private RecoveryModel model;
    private ComboViewer languageCombo;
    private CDateTime dateTime;
    private ComboViewer countryCombo;
    private Text transferCode;

    public RecoveryModelDialog(RecoveryModel model, Shell shell) {
        super(shell);
        this.model = model;
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Daten der Genesung / pos. Test");
        parent = (Composite)super.createDialogArea(parent);
        this.languageCombo = new ComboViewer(parent, 2048);
        this.languageCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languageCombo.setInput((Object)new String[]{"DE", "FR", "IT", "RM"});
        this.languageCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RecoveryModelDialog.this.model.setLanguage(((String)event.getStructuredSelection().getFirstElement()).toLowerCase());
            }
        });
        this.languageCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getLanguage().toUpperCase()));
        this.languageCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.languageCombo.getControl().setToolTipText("Sprache");
        this.dateTime = new CDateTime(parent, 2098179);
        this.dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Date now = new Date();
                if (RecoveryModelDialog.this.dateTime.getSelection() != null) {
                    Date selection = RecoveryModelDialog.this.dateTime.getSelection();
                    if (selection.before(now)) {
                        RecoveryModelDialog.this.model.getRecoveryInfo()[0].setDateOfFirstPositiveTestResult(new SimpleDateFormat("yyyy-MM-dd").format(selection));
                        RecoveryModelDialog.this.removeErrorDecoration((Control)RecoveryModelDialog.this.dateTime);
                    } else {
                        RecoveryModelDialog.this.addErrorDecoration((Control)RecoveryModelDialog.this.dateTime);
                    }
                }
            }
        });
        try {
            this.dateTime.setSelection(new SimpleDateFormat("yyyy-MM-dd").parse(this.model.getRecoveryInfo()[0].getDateOfFirstPositiveTestResult()));
        }
        catch (ParseException e1) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not parse date [" + this.model.getRecoveryInfo()[0].getDateOfFirstPositiveTestResult() + "]");
        }
        this.dateTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dateTime.setToolTipText("Datum des positiven Test");
        this.countryCombo = new ComboViewer(parent, 2048);
        this.countryCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.countryCombo.setInput(this.valueSetService.getValueSet("country-alpha-2-de").stream().map(c -> c.getCode()).collect(Collectors.toList()));
        this.countryCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RecoveryModelDialog.this.model.getRecoveryInfo()[0].setCountryOfTest((String)event.getStructuredSelection().getFirstElement());
            }
        });
        this.countryCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getRecoveryInfo()[0].getCountryOfTest()));
        this.countryCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.countryCombo.getControl().setToolTipText("Land der Testung");
        this.transferCode = new Text(parent, 2048);
        this.transferCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.transferCode.setTextLimit(9);
        this.transferCode.setMessage("Transfer Code");
        this.transferCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RecoveryModelDialog.this.transferCode.getText() != null) {
                    if (!RecoveryModelDialog.this.transferCode.getText().equals(RecoveryModelDialog.this.transferCode.getText().toUpperCase())) {
                        RecoveryModelDialog.this.transferCode.setText(RecoveryModelDialog.this.transferCode.getText().toUpperCase());
                        RecoveryModelDialog.this.transferCode.setSelection(RecoveryModelDialog.this.transferCode.getText().length());
                    }
                    if (RecoveryModelDialog.this.transferCode.getText().length() == 9) {
                        RecoveryModelDialog.this.model.setAppCode(RecoveryModelDialog.this.transferCode.getText());
                        return;
                    }
                }
                RecoveryModelDialog.this.model.setAppCode(null);
            }
        });
        this.dateTime.setFocus();
        return parent;
    }

    protected void okPressed() {
        try {
            if (this.model.getRecoveryInfo()[0].getDateOfFirstPositiveTestResult() == null || new SimpleDateFormat("yyyy-MM-dd").parse(this.model.getRecoveryInfo()[0].getDateOfFirstPositiveTestResult()).after(new Date())) {
                this.addErrorDecoration((Control)this.dateTime);
                return;
            }
        }
        catch (ParseException e) {
            this.addErrorDecoration((Control)this.dateTime);
            return;
        }
        super.okPressed();
    }

    private void removeErrorDecoration(Control control) {
        if (control.getData("deco") != null) {
            ((ControlDecoration)control.getData("deco")).hide();
            ((ControlDecoration)control.getData("deco")).dispose();
            control.setData("deco", null);
        }
    }

    private void addErrorDecoration(Control control) {
        if (control.getData("deco") == null) {
            ControlDecoration deco = new ControlDecoration(control, 16512);
            deco.setDescriptionText("Fehlende oder fehlerhafte Eingabe");
            deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            deco.setShowOnlyOnFocus(false);
            deco.show();
            control.setData("deco", (Object)deco);
        }
    }
}

