/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.dbcheck;

import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.rgw.tools.Result;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveSzBillingToSzCoverage
extends ExternalMaintenance {
    private int movedCount;
    private int canNotMoveCount;
    private ICodeElementBlock kkBlock;
    private IMandator activeMandator;
    private List<IPatient> notBillablePatients;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.activeMandator = (IMandator)ContextServiceHolder.get().getActiveMandator().orElseThrow(() -> new IllegalStateException("Es ist kein Mandant angemeldet."));
        IQuery encountersQuery = CoreModelServiceHolder.get().getQuery(IEncounter.class);
        this.movedCount = 0;
        this.canNotMoveCount = 0;
        Throwable throwable = null;
        Object var5_6 = null;
        try (IQueryCursor cursor = encountersQuery.executeAsCursor();){
            pm.beginTask("Bitte warten, COVID Test Zertifikat Selbstzahler Verrechnung wird korrigiert ...", cursor.size());
            while (cursor.hasNext()) {
                IEncounter encounter = (IEncounter)cursor.next();
                if (this.isSzEncounter(encounter) && this.shouldMove(encounter)) {
                    if (this.canMove(encounter)) {
                        this.move(encounter);
                        ++this.movedCount;
                    } else {
                        ++this.canNotMoveCount;
                    }
                }
                pm.worked(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return "Es wurden " + this.movedCount + " Selbstzahler Konsultationen verschoben." + (this.canNotMoveCount > 0 ? "\nEs gab " + this.canNotMoveCount + " Selbstzahler Konsultationen die nicht verschoben werden konnten." : "");
    }

    private void move(IEncounter encounter) {
        Result result;
        ICoverage privateCoverage = this.getPrivateCoverage(encounter.getPatient()).orElse(null);
        if (privateCoverage == null) {
            privateCoverage = this.createPrivateCoverage(encounter.getPatient());
        }
        if (!(result = EncounterServiceHolder.get().transferToCoverage(encounter, privateCoverage, false)).isOK()) {
            System.err.println("Move failed for encounter " + encounter.getLabel() + " [" + result.toString() + "]");
        }
    }

    private ICoverage createPrivateCoverage(IPatient patient) {
        return new ICoverageBuilder(CoreModelServiceHolder.get(), patient, "Selbstzahler", ICoverageBuilder.getDefaultCoverageReason((IConfigService)ConfigServiceHolder.get()), BillingLaw.privat.name()).buildAndSave();
    }

    private Optional<ICoverage> getPrivateCoverage(IPatient patient) {
        ICoverage bestMatch = null;
        for (ICoverage coverage : patient.getCoverages()) {
            if (!coverage.isOpen() || coverage.getBillingSystem().getLaw() != BillingLaw.privat && coverage.getBillingSystem().getLaw() != BillingLaw.VVG) continue;
            bestMatch = coverage;
        }
        return Optional.ofNullable(bestMatch);
    }

    private boolean canMove(IEncounter encounter) {
        Result editableResult = BillingServiceHolder.get().isEditable(encounter);
        if (!editableResult.isOK()) {
            System.err.println("Can not move encounter " + encounter.getLabel() + " [" + editableResult.toString() + "]");
        }
        return editableResult.isOK();
    }

    private boolean shouldMove(IEncounter encounter) {
        if (encounter.getCoverage() != null && encounter.getCoverage().getBillingSystem() != null) {
            BillingLaw law = encounter.getCoverage().getBillingSystem().getLaw();
            return law != BillingLaw.privat && law != BillingLaw.VVG;
        }
        return false;
    }

    private boolean isSzEncounter(IEncounter encounter) {
        Optional<IBilled> szBilled = encounter.getBilled().stream().filter(b -> b.getBillable() != null && b.getBillable().getCodeSystemName() != null && b.getBillable().getCodeSystemName().equalsIgnoreCase("Pandemie") && b.getCode().startsWith("01.99")).findFirst();
        return szBilled.isPresent();
    }

    public String getMaintenanceDescription() {
        return "COVID Test Zertifikat Selbstzahler Verrechnung korrigieren.";
    }
}

