/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.dbcheck;

import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.core.utils.CoreUtil;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FileWriter;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.LoggerFactory;

public class BillMissingTestAttests
extends ExternalMaintenance {
    private int billCount;
    private int notBillableCount;
    private ICodeElementBlock pcrBlock;
    private ICodeElementBlock kkBlock;
    private IMandator activeMandator;
    private List<IPatient> notBillablePatients;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.kkBlock = this.getConfiguredBlock().orElseThrow(() -> new IllegalStateException("Es ist kein Block f\u00fcr Krankenkasse zur Verrechnung von COVID Zertifikaten konfiguriert."));
        this.pcrBlock = this.getBlock("PCR_kasse").orElseThrow(() -> new IllegalStateException("Es ist kein Block f\u00fcr PCR Test Krankenkasse [PCR_kasse] vorhanden."));
        this.activeMandator = (IMandator)ContextServiceHolder.get().getActiveMandator().orElseThrow(() -> new IllegalStateException("Es ist kein Mandant angemeldet."));
        IQuery patientsQuery = CoreModelServiceHolder.get().getQuery(IPatient.class);
        this.billCount = 0;
        this.notBillableCount = 0;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (IQueryCursor cursor = patientsQuery.executeAsCursor();){
            pm.beginTask("Bitte warten, COVID Test Bescheinigungen werden verrechnet ...", cursor.size());
            while (cursor.hasNext()) {
                IPatient patient = (IPatient)cursor.next();
                this.billAttests(patient, false);
                this.billAttests(patient, true);
                pm.worked(1);
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (this.notBillablePatients != null && !this.notBillablePatients.isEmpty()) {
            File file = new File(CoreUtil.getWritableUserDir(), "NotBillablePatients.csv");
            try {
                throwable2 = null;
                Object var6_10 = null;
                try (FileWriter fw = new FileWriter(file);){
                    for (IPatient patient : this.notBillablePatients) {
                        fw.write(String.valueOf(patient.getPatientNr()) + "," + patient.getLastName() + "," + patient.getFirstName() + "," + patient.getDateOfBirth() + "\n");
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error writing not billable patients", (Throwable)e);
            }
        }
        return "Es wurden " + this.billCount + " Bescheinigungen neu verrechnet." + (this.notBillableCount > 0 ? "\nEs gab " + this.notBillableCount + " Patienten bei denen nicht verrechnet werden konnte. (NotBillablePatients.csv Datei im user home elexis Verzeichnis)" : "");
    }

    private void billAttests(IPatient patient, boolean positive) {
        List<IDocumentLetter> attests = this.getAttests(patient, positive);
        if (!attests.isEmpty()) {
            attests.forEach(attest -> {
                List<IEncounter> encountersAt = this.getEncountersAt(patient, attest.getCreated().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                Optional<IEncounter> attestBilledEncounter = encountersAt.stream().filter(encounter -> this.isCertificateBilled((IEncounter)encounter)).findFirst();
                if (!attestBilledEncounter.isPresent()) {
                    Optional<ICoverage> coverage = this.getCoverage(patient);
                    if (coverage.isPresent()) {
                        this.billAttest(coverage.get(), (IDocumentLetter)attest, positive);
                        ++this.billCount;
                    } else {
                        this.addNotBillable(patient);
                        ++this.notBillableCount;
                    }
                }
            });
        }
    }

    private List<IDocumentLetter> getAttests(IPatient patient, boolean positive) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IDocumentLetter.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        query.and("subject", IQuery.COMPARATOR.EQUALS, (Object)(positive ? "COVID Antigen positiv" : "COVID Antigen negativ"));
        return query.execute();
    }

    private void addNotBillable(IPatient patient) {
        if (this.notBillablePatients == null) {
            this.notBillablePatients = new ArrayList<IPatient>();
        }
        this.notBillablePatients.add(patient);
    }

    private void billAttest(ICoverage coverage, IDocumentLetter attest, boolean positive) {
        if (this.kkBlock != null) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, this.activeMandator).date(attest.getCreated().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).buildAndSave();
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Bill Certificate on new encounter [" + encounter + "] of [" + encounter.getPatient().getPatientNr() + "]");
            this.kkBlock.getElements(encounter).stream().filter(el -> el instanceof IBillable).map(el -> (IBillable)el).forEach(billable -> {
                Result result = BillingServiceHolder.get().bill(billable, encounter, 1.0);
            });
            if (positive) {
                this.pcrBlock.getElements(encounter).stream().filter(el -> el instanceof IBillable).map(el -> (IBillable)el).forEach(billable -> {
                    Result result = BillingServiceHolder.get().bill(billable, encounter, 1.0);
                });
            }
        }
    }

    private Optional<ICodeElementBlock> getConfiguredBlock() {
        Optional kkBlock;
        if (ConfigServiceHolder.get().get("ch.elexis.covid.cert.ui/kk_blockid", null) != null && (kkBlock = CoreModelServiceHolder.get().load(ConfigServiceHolder.get().get("ch.elexis.covid.cert.ui/kk_blockid", null), ICodeElementBlock.class)).isPresent()) {
            return kkBlock;
        }
        return Optional.empty();
    }

    private Optional<ICodeElementBlock> getBlock(String name) {
        IQuery query = CoreModelServiceHolder.get().getQuery(ICodeElementBlock.class);
        query.and("name", IQuery.COMPARATOR.EQUALS, (Object)name);
        return query.executeSingleResult();
    }

    private Optional<ICoverage> getCoverage(IPatient patient) {
        List coverages = patient.getCoverages();
        coverages.sort(new Comparator<ICoverage>(){

            @Override
            public int compare(ICoverage o1, ICoverage o2) {
                return o2.getDateFrom().compareTo(o1.getDateFrom());
            }
        });
        for (ICoverage coverage : coverages) {
            if (!coverage.isOpen() || coverage.getBillingSystem().getLaw() != BillingLaw.KVG) continue;
            return Optional.of(coverage);
        }
        return Optional.empty();
    }

    private List<IEncounter> getEncountersAt(IPatient patient, LocalDate localDate) {
        if (patient.getCoverages() != null) {
            List coverages = patient.getCoverages();
            coverages.sort(new Comparator<ICoverage>(){

                @Override
                public int compare(ICoverage o1, ICoverage o2) {
                    return o2.getDateFrom().compareTo(o1.getDateFrom());
                }
            });
            return coverages.stream().filter(coverage -> coverage.isOpen() && coverage.getBillingSystem().getLaw() == BillingLaw.KVG).flatMap(coverage -> coverage.getEncounters().stream()).filter(encounter -> encounter.getDate().equals(localDate)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isCertificateBilled(IEncounter encounter) {
        Optional<IBilled> found = encounter.getBilled().stream().filter(billed -> this.isCertificateBilled((IBilled)billed)).findFirst();
        return found.isPresent();
    }

    private boolean isCertificateBilled(IBilled billed) {
        IBillable billable = billed.getBillable();
        if (billable != null && "351".equals(billable.getCodeSystemCode())) {
            return "01.01.1300".equals(billable.getCode()) || "01.99.1300".equals(billable.getCode());
        }
        return false;
    }

    public String getMaintenanceDescription() {
        return "Noch nicht verrechnete COVID Test Bescheinigungen (Briefe) verrechnen.";
    }
}

