/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.sysmex.packages;

import ch.elexis.connect.sysmex.packages.AbstractUrinData;
import ch.elexis.connect.sysmex.packages.PackageException;
import ch.elexis.connect.sysmex.packages.Value;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import org.apache.commons.lang3.StringUtils;

public class UC1000Data
extends AbstractUrinData {
    private TimeTool date;
    private String patId;
    private AbstractUrinData.ResultInfo uro;
    private AbstractUrinData.ResultInfo bid;
    private AbstractUrinData.ResultInfo bil;
    private AbstractUrinData.ResultInfo ket;
    private AbstractUrinData.ResultInfo glu;
    private AbstractUrinData.ResultInfo pro;
    private AbstractUrinData.ResultInfo ph;
    private AbstractUrinData.ResultInfo nit;
    private AbstractUrinData.ResultInfo leu;
    private AbstractUrinData.ResultInfo sg;
    private AbstractUrinData.ResultInfo cre;
    private AbstractUrinData.ResultInfo alb;
    private AbstractUrinData.ResultInfo pcr;
    private AbstractUrinData.ResultInfo acr;
    private AbstractUrinData.ResultInfo sgr;
    private AbstractUrinData.ResultInfo color;
    private AbstractUrinData.ResultInfo tur;

    @Override
    public int getSize() {
        return 518;
    }

    @Override
    protected TimeTool getDate(String content) {
        int year = Integer.parseInt(content.substring(49, 53));
        int month = Integer.parseInt(content.substring(54, 56));
        int day = Integer.parseInt(content.substring(57, 59));
        TimeTool timetool = new TimeTool();
        timetool.set(year, month - 1, day);
        return timetool;
    }

    @Override
    protected String getPatientId(String content) {
        String patId = content.substring(0, 14).trim();
        if (patId != null && !patId.isEmpty()) {
            try {
                patId = Integer.valueOf(patId).toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return patId;
    }

    @Override
    protected Value getValue(String paramName) throws PackageException {
        return Value.getValueUC1000(paramName);
    }

    public AbstractUrinData.ResultInfo getResultInfo(String paramName) {
        switch (paramName.toLowerCase()) {
            case "uro": {
                return this.uro;
            }
            case "bid": {
                return this.bid;
            }
            case "bil": {
                return this.bil;
            }
            case "ket": {
                return this.ket;
            }
            case "glu": {
                return this.glu;
            }
            case "pro": {
                return this.pro;
            }
            case "ph": {
                return this.ph;
            }
            case "nit": {
                return this.nit;
            }
            case "leu": {
                return this.leu;
            }
            case "sg": {
                return this.sg;
            }
            case "cre": {
                return this.cre;
            }
            case "alb": {
                return this.alb;
            }
        }
        throw new IllegalStateException("Unknown parameter name [" + paramName + "]");
    }

    @Override
    protected int getDataIndex() {
        return 69;
    }

    @Override
    public String getPatientId() {
        return this.patId;
    }

    @Override
    public void write(Patient patient) throws PackageException {
        if (this.uro.isAnalyzed()) {
            this.write(this.uro, this.getValue("URO"), patient);
        }
        if (this.bid.isAnalyzed()) {
            if (this.bid.getSemiQualitativValue().indexOf(".") != -1) {
                this.write(this.bid, this.getValue("HEM"), patient);
            } else {
                this.write(this.bid, this.getValue("RBC"), patient);
            }
        }
        if (this.bil.isAnalyzed()) {
            this.write(this.bil, this.getValue("BIL"), patient);
        }
        if (this.ket.isAnalyzed()) {
            this.write(this.ket, this.getValue("KET"), patient);
        }
        if (this.glu.isAnalyzed()) {
            this.write(this.glu, this.getValue("GLU"), patient);
        }
        if (this.pro.isAnalyzed()) {
            this.write(this.pro, this.getValue("PRO"), patient);
        }
        if (this.ph.isAnalyzed()) {
            this.write(this.ph, this.getValue("PH"), patient);
        }
        if (this.nit.isAnalyzed()) {
            this.write(this.nit, this.getValue("NIT"), patient);
        }
        if (this.leu.isAnalyzed()) {
            this.write(this.leu, this.getValue("LEU"), patient);
        }
        if (this.sg.isAnalyzed()) {
            this.write(this.sg, this.getValue("SG"), patient);
        }
        if (this.cre.isAnalyzed()) {
            this.write(this.cre, this.getValue("CRE"), patient);
        }
        if (this.alb.isAnalyzed()) {
            this.write(this.alb, this.getValue("ALB"), patient);
        }
    }

    private void write(AbstractUrinData.ResultInfo resultInfo, Value value, Patient patient) {
        String result = "";
        String comment = "";
        if (StringUtils.isNotBlank((CharSequence)resultInfo.getSemiQualitativValue())) {
            result = resultInfo.getSemiQualitativValue();
            if (StringUtils.isNotBlank((CharSequence)resultInfo.getQualitativValue())) {
                comment = "Qualitativ Wert: " + resultInfo.getQualitativValue();
            }
        } else {
            result = resultInfo.getQualitativValue();
            if (StringUtils.isNotBlank((CharSequence)resultInfo.getSemiQualitativValue())) {
                comment = "Semiqualitativ Wert: " + resultInfo.getSemiQualitativValue();
            }
        }
        Integer patho = 0;
        if (StringUtils.isNotBlank((CharSequence)resultInfo.getQualitativValue()) && Character.isDigit(resultInfo.getQualitativValue().charAt(0)) && resultInfo.getQualitativValue().contains("+")) {
            patho = patho | 1;
        }
        value.fetchValue(patient, result, patho, this.date, comment);
    }

    @Override
    public void parse(String content) {
        this.date = this.getDate(content);
        this.patId = this.getPatientId(content);
        this.uro = AbstractUrinData.ResultInfo.parse(69, 101, content);
        this.bid = AbstractUrinData.ResultInfo.parse(101, 133, content);
        this.bil = AbstractUrinData.ResultInfo.parse(133, 165, content);
        this.ket = AbstractUrinData.ResultInfo.parse(165, 197, content);
        this.glu = AbstractUrinData.ResultInfo.parse(197, 229, content);
        this.pro = AbstractUrinData.ResultInfo.parse(229, 261, content);
        this.ph = AbstractUrinData.ResultInfo.parse(261, 293, content);
        this.nit = AbstractUrinData.ResultInfo.parse(293, 325, content);
        this.leu = AbstractUrinData.ResultInfo.parse(325, 357, content);
        this.sg = AbstractUrinData.ResultInfo.parse(357, 389, content);
        this.cre = AbstractUrinData.ResultInfo.parse(389, 421, content);
        this.alb = AbstractUrinData.ResultInfo.parse(421, 453, content);
        this.pcr = AbstractUrinData.ResultInfo.parse(453, 468, content);
        this.acr = AbstractUrinData.ResultInfo.parse(468, 483, content);
        this.sgr = AbstractUrinData.ResultInfo.parse(483, 498, content);
        this.color = AbstractUrinData.ResultInfo.parse(498, 518, content);
        this.tur = AbstractUrinData.ResultInfo.parse(498, 518, content);
    }
}

