/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.sysmex.packages;

import ch.elexis.connect.sysmex.packages.IProbe;
import ch.elexis.connect.sysmex.packages.PackageException;
import ch.elexis.connect.sysmex.packages.Value;
import ch.rgw.tools.TimeTool;

public abstract class AbstractUrinData
implements IProbe {
    @Override
    public abstract int getSize();

    protected abstract int getDataIndex();

    protected abstract TimeTool getDate(String var1);

    protected abstract Value getValue(String var1) throws PackageException;

    protected abstract String getPatientId(String var1);

    public static class ResultInfo {
        private boolean isAnalyzed;
        private String commentMark;
        private String qualitativValue;
        private String semiQualitativValue;
        private String reflective1Value;
        private boolean isReflective;

        public static ResultInfo parse(int start, int end, String content) {
            ResultInfo ret = new ResultInfo();
            String part = content.substring(start, end);
            ret.isAnalyzed = ResultInfo.isAnalyzed(part);
            if (ret.isAnalyzed) {
                if (part.length() == 32) {
                    ret.commentMark = ResultInfo.getCommentMark(part);
                    ret.qualitativValue = ResultInfo.getQualitativValue(part);
                    ret.semiQualitativValue = ResultInfo.getSemiQualitativValue(part);
                    String reflective1 = ResultInfo.getReflective1(part);
                    if (reflective1 != null && !reflective1.isEmpty()) {
                        ret.isReflective = true;
                        ret.reflective1Value = reflective1;
                    } else {
                        ret.isReflective = false;
                    }
                } else if (part.length() == 15) {
                    ret.commentMark = ResultInfo.getCommentMark(part);
                    ret.qualitativValue = ResultInfo.getQualitativValue(part);
                    ret.semiQualitativValue = ResultInfo.getSemiQualitativValue(part);
                } else if (part.length() != 20) {
                    throw new IllegalStateException("Unknown part size " + part.length());
                }
            }
            return ret;
        }

        private static String getReflective1(String part) {
            return part.substring(14, 19).trim();
        }

        private static String getSemiQualitativValue(String part) {
            return part.substring(8, 14).trim();
        }

        private static String getQualitativValue(String part) {
            return part.substring(2, 8).trim();
        }

        private static String getCommentMark(String part) {
            return part.substring(1, 2);
        }

        private static boolean isAnalyzed(String part) {
            return part.substring(0, 1).equals("0");
        }

        public boolean isAnalyzed() {
            return this.isAnalyzed;
        }

        public String getCommentMark() {
            return this.commentMark;
        }

        public String getQualitativValue() {
            return this.qualitativValue;
        }

        public String getSemiQualitativValue() {
            return this.semiQualitativValue;
        }

        public String getReflective1Value() {
            return this.reflective1Value;
        }

        public boolean isReflective() {
            return this.isReflective;
        }
    }
}

